include("scripts/appliances/fireplaceappliance.lua")
include("scripts/appliances/elevator.lua")
--include("scripts/appliances/coffeeMachine.lua")

include("scripts/products/regularproduct.lua")
include("scripts/products/firewoodproduct.lua")
include("scripts/products/getmailproduct.lua")
include("scripts/products/rest2_basegrillproduct.lua")
include("scripts/products/rest2_grillproduct.lua")
include("scripts/products/elevatorbutton.lua")
include("scripts/products/getkeyproduct.lua")
include("scripts/products/deliverkeyproduct.lua")

include("scripts/specialevents/mailmanspecial.lua")

-- global variables and behavior we might need in a specific restaurant

-- entry node
-- npc's and such will be spawned at this location
entryX = 39
entryY = 3
entryNode = nil

-- exit node
exitX = 39
exitY = 3
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = 29
movieY = 4
movieNode = nil

-- worker table
-- this is the 1 person table that the cleaner sits on
workerTable = nil

-- restaurant class
class 'restaurant2' (interface)

-- mailman special event stuff
restaurant2.mailSpecial = mailmanspecial()
restaurant2.elevator = nil

function restaurant2:__init() super()
end

function restaurant2:onLevelInited()
	self.mailSpecial:onLevelInited()
	restaurant.mailSpecial.doMailmanEvent = true
	restaurant.mailSpecial.appliance = "rest2_reception"
	self.mailSpecial.entryNode = grid:getNode(45, 3)
	self.mailSpecial.exitNode = grid:getNode(45, 3)	
	om:getCounter():setYPos(-93)	
	
	if (self.elevator) then
		self.elevator:onLevelInited()
	end
	
	self.snow = level:getLayer(0):addParticleEffectAfter("PARTICLE_SNOW_RESTAURANT")
	self.snow:play()
	self.snow:addInitialTime(15000)
	
end

function restaurant2:onDayEnd()
	if (self.elevator) then
		self.elevator:onDayEnd()
	end
end

function restaurant2:onTick(time)
	self.mailSpecial:onTick(time)	
end

function restaurant2:onNotify(notification)
	self.mailSpecial:onNotify(notification)
	if (self.elevator) then
		self.elevator:onNotify(notification)
	end
end

function restaurant2:createObject(desc)

	if (desc:getObjectId() == "rest2_fireplace") then
		result = fireplaceAppliance()
		result:setType(desc:getType())
		return result

	elseif (desc:getObjectId() == "rest2_elevator") then
		result = elevator()
		
		result.shaftInfo.imageName = "APP_ELEVATOR_BACK"
		result.shaftInfo.baseX = -98
		result.shaftInfo.baseY = -134
		
		result.cabinInfo.imageName = "APP_ELEVATOR_CABIN"
		result.cabinInfo.baseX = -101
		result.cabinInfo.baseY = -143
		
		result.fakeCustomerInfo.imageName = "INGAME_CUSTOMER_MALE_REGULAR_IDLE"
		result.fakeCustomerInfo.baseX = -60
		result.fakeCustomerInfo.baseY = -132
		
		result.doorInfo.imageNameL = "APP_ELEVATOR_DOOR_L"
		result.doorInfo.imageNameR = "APP_ELEVATOR_DOOR_R"
		if (um:hasUpgrade("APP_ELEVATOR_DOOR_R") ~= 1) then
			result.doorInfo.imageNameR = "APP_ELEVATOR_DOOR_UPGRADE_R"
		end
		if (um:hasUpgrade("APP_ELEVATOR_DOOR_L") ~= 1) then
			result.doorInfo.imageNameL = "APP_ELEVATOR_DOOR_UPGRADE_L"
		end
			
		result.doorInfo.baseLX = -81
		result.doorInfo.baseLY = -126
		result.doorInfo.baseRX = -32
		result.doorInfo.baseRY = -124
		
		result.exteriorInfo.imageName = "APP_ELEVATOR_FRONT"
		result.exteriorInfo.baseX = -112
		result.exteriorInfo.baseY = -160
		
		result.indicatorInfo.imageName = "APP_ELEVATOR_POINTER"
		result.indicatorInfo.baseX = -24
		result.indicatorInfo.baseY = -127
		
		result:initAppearance()
		result:setType(desc:getType())
		self.elevator = result
		return result
	end
	
	return nil
end

function restaurant2:createProduct(base)

	bubbleGrillX = 100
	bubbleGrillY = 450
	bubbleGrillS = true
	
	if (type(base) == "string")	then
	
		if (base == "ROAST") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetY(-4)
			return p
		
		elseif (base == "ASPARAGUS") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_GRAB_SQUID_CAVIAR")
			p:setWorkOffsetY(-2)
			return p
				
		elseif (base == "CHAMPAGNE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_POUR_FLUID")
			return p
			
		elseif (base == "PUMPKINPIE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p
			
		elseif (base == "COFFEE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_MAKECOFFEE")
			return p
			
		elseif (base == "ENVELOP" or base == "MAIL") then
			p = getmailproduct	(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_PICKUP_POST_CARD")
			p:setWorkOffsetX(5)
			return p
			
		elseif (base == "WOOD") then
			p = firewoodProduct(base)
			p:setApplianceName("rest2_fireplace")
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_LOG_ON_FIRE")
			
			return p
			
		elseif (base == "ELEVATOR_01" or
				base == "ELEVATOR_02" or
				base == "ELEVATOR_03") then
			p = elevatorButton(base)
			p:setElevatorName("rest2_elevator")
			p:setWorkSound("SOUND_LIFT_BUTTON")
			
			return p
		
		elseif (base == "KEY_1" or base == "KEY_2" or base == "KEY_3") then
			p = getkeyproduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_KEY")
			p:setStock(0)
			p:setMaxStock(5)
			p:setWorkOffsetX(0)
			p:setVisible(false)
			return p
			
		elseif (base == "KEY_1_DROP" or base == "KEY_2_DROP" or base == "KEY_3_DROP") then
			p = deliverkeyproduct(base)
			
			if (base == "KEY_1_DROP") then
				p.keyProduct = "KEY_1"
			elseif (base == "KEY_2_DROP") then
				p.keyProduct = "KEY_2"
			else
				p.keyProduct = "KEY_3"
			end
			
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(200)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_KEY")
			p:setWorkOffsetX(0)
			return p
			
		-- temp is for restaurant 3		
		--elseif (base == "SPIES") then
			--p = rest2_baseGrillProduct(base)
			--p:setBubbleX(bubbleGrillX)
			--p:setBubbleY(bubbleGrillY)
			--p:setBubbleSmall(bubbleGrillS)
			--p:setWorkOffsetX(0)
			--p:setWorkTime(400)
			--p:setWorkAnimation("WORK_FRONT")
			--p:setWorkSound("SOUND_DROPMULTIPLESLICES")
			--p:setVisibleOnTray(false)
			--p:setWorkOffsetX(-4)
			--return p
		--
		elseif (base == "MEAT") then
			p = rest2_baseGrillProduct(base)
			p:setBubbleX(bubbleGrillX)
			p:setBubbleY(bubbleGrillY)
			p:setBubbleSmall(bubbleGrillS)
			p:setWorkOffsetX(0)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_DROPMULTIPLESLICES")
			p:setVisibleOnTray(false)
			p:setWorkOffsetX(-2)
			return p
		
		elseif (base == "PAPRIKA") then
			p = rest2_baseGrillProduct(base)
			p:setBubbleX(bubbleGrillX)
			p:setBubbleY(bubbleGrillY)
			p:setBubbleSmall(bubbleGrillS)
			p:setWorkOffsetX(0)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_DROPMULTIPLESLICES")
			p:setVisibleOnTray(false)
			p:setWorkOffsetX(1)	
			return p
		
		elseif (base == "PINEAPPLE") then
			p = rest2_baseGrillProduct(base)
			p:setBubbleX(bubbleGrillX)
			p:setBubbleY(bubbleGrillY)
			p:setBubbleSmall(bubbleGrillS)
			p:setWorkOffsetX(0)
			p:setWorkTime(400)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_DROPMULTIPLESLICES")
			p:setVisibleOnTray(false)
			p:setWorkOffsetX(4)	
			return p

		elseif (base == "PINEAPPLE_PINEAPPLE_PINEAPPLE" or
				base == "PINEAPPLE_PINEAPPLE_MEAT" or
				base == "PINEAPPLE_MEAT_PINEAPPLE" or
				base == "PINEAPPLE_MEAT_MEAT" or
				base == "PINEAPPLE_MEAT_PAPRIKA" or				
				base == "PINEAPPLE_PAPRIKA_PAPRIKA" or
				base == "PINEAPPLE_PINEAPPLE_PAPRIKA" or
				base == "PINEAPPLE_PAPRIKA_PINEAPPLE" or
				base == "PINEAPPLE_PAPRIKA_MEAT" or
				base == "PAPRIKA_PINEAPPLE_PAPRIKA" or
				base == "PAPRIKA_MEAT_PAPRIKA" or
				base == "PAPRIKA_MEAT_MEAT" or
				base == "PAPRIKA_PINEAPPLE_PINEAPPLE" or
				base == "PAPRIKA_PINEAPPLE_MEAT" or
				base == "PAPRIKA_MEAT_PINEAPPLE" or
				base == "PAPRIKA_PAPRIKA_PINEAPPLE" or
				base == "PAPRIKA_PAPRIKA_MEAT" or
				base == "PAPRIKA_PAPRIKA_PAPRIKA" or
				base == "MEAT_PAPRIKA_PAPRIKA" or
				base == "MEAT_PAPRIKA_MEAT" or
				base == "MEAT_PAPRIKA_PINEAPPLE" or
				base == "MEAT_MEAT_PAPRIKA" or
				base == "MEAT_PINEAPPLE_PINEAPPLE" or
				base == "MEAT_PINEAPPLE_MEAT" or
				base == "MEAT_PINEAPPLE_PAPRIKA" or
				base == "MEAT_MEAT_PINEAPPLE" or
				base == "MEAT_MEAT_MEAT") then
				
			p = rest2_grillProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setBubbleTarget("rest2_grill")
			return p
			
		end
		
	elseif (type(base) == "userdata") then
		
		local tempBase = base:getBase()
		if (tempBase == "PINEAPPLE_PINEAPPLE_PINEAPPLE" or
			tempBase == "PINEAPPLE_PINEAPPLE_MEAT" or
			tempBase == "PINEAPPLE_MEAT_PINEAPPLE" or
			tempBase == "PINEAPPLE_MEAT_MEAT" or
			tempBase == "PINEAPPLE_MEAT_PAPRIKA" or
			tempBase == "PINEAPPLE_PAPRIKA_PAPRIKA" or
			tempBase == "PINEAPPLE_PINEAPPLE_PAPRIKA" or
			tempBase == "PINEAPPLE_PAPRIKA_PINEAPPLE" or
			tempBase == "PINEAPPLE_PAPRIKA_MEAT" or
			tempBase == "PAPRIKA_PINEAPPLE_PAPRIKA" or
			tempBase == "PAPRIKA_MEAT_PAPRIKA" or
			tempBase == "PAPRIKA_MEAT_MEAT" or
			tempBase == "PAPRIKA_PINEAPPLE_PINEAPPLE" or
			tempBase == "PAPRIKA_PINEAPPLE_MEAT" or
			tempBase == "PAPRIKA_MEAT_PINEAPPLE" or
			tempBase == "PAPRIKA_PAPRIKA_PINEAPPLE" or
			tempBase == "PAPRIKA_PAPRIKA_MEAT" or
			tempBase == "PAPRIKA_PAPRIKA_PAPRIKA" or
			tempBase == "MEAT_PAPRIKA_PAPRIKA" or
			tempBase == "MEAT_PAPRIKA_MEAT" or
			tempBase == "MEAT_PAPRIKA_PINEAPPLE" or
			tempBase == "MEAT_MEAT_PAPRIKA" or
			tempBase == "MEAT_PINEAPPLE_PINEAPPLE" or
			tempBase == "MEAT_PINEAPPLE_MEAT" or
			tempBase == "MEAT_PINEAPPLE_PAPRIKA" or
			tempBase == "MEAT_MEAT_PINEAPPLE" or
			tempBase == "MEAT_MEAT_MEAT") then
			
			p = rest2_grillProduct(base)
			return p
			
		end
		
	end
	
	return nil	
end

function restaurant2:onRemoveProductFromTray(product)
	if (product == "KEY_1" or product == "KEY_2" or product == "KEY_3" or
		product == "ENVELOP" or product == "MAIL") then
		
		getProduct(product):setVisible(true)
		if (getProduct(product):isStockProduct()) then
			getProduct(product):incStock(1)
		end
		
	end
end

-- set restaurant
restaurant = restaurant2()