include("scripts/appliances/karaoke.lua")

-- day class
class 'day9' (interface)

day9.karaoke = nil
-- The time passed before Emily & Frankie find out the carol singers are ill
day9.karaokeEventMinTime = 140 * 1000
day9.karaokeEventMaxTime = 145 * 1000
day9.karaokeEventTimer = 0
day9.karaokeEventStarted = false

-- karaoke stats
-- The time gap between carol singers
day9.carolSingerMinTime = 10 * 1000
day9.carolSingerMaxTime = 12 * 1000
day9.carolSingerTimer = false
day9.carolSingerTimerSuspended = true
day9.nrCarolSingers = 0
day9.maxNrCarolSingers = 8		-- Nr of carol singers to complete event
day9.scoreApplaudedOne = 25
day9.scoreApplaudedAll = 100
day9.scoreOffsetY = -64

day9.fakeSinger = nil

function day9:__init() super()
end

function day9:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.karaoke = getAppliance("rest1_karaoke")
	self.karaokeEventTimer = getRandomRange(self.karaokeEventMinTime, self.karaokeEventMaxTime)
	
	if (self.karaoke) then
		self.karaoke:removeHighlight()
			--
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(self.maxNrCarolSingers)
		eventBar:setProgress(0)	
		eventBar:setSubjectImage("EVENT_BAR_KARAOKE", player:getCurrentResourceSection())

	end
	
	-- emily    
    emily:setPosition(grid:getNode(22, 18))
    emily:setAppearance("UP")
    
    entertainer:setPosition(grid:getNode(26, 18))
  --  entertainer:setAppearance("BACK_ELF")
    -- show the movie bar non-animated
	scene:showBars(false)
	
	local startSequence = 
	{
		{ "scene",			"qStartMovie",		2						},
		{ "emily",			"qSay",				"RESTAURANT1_DAY9_0"	},
		{ "entertainer",	"qSay",				"RESTAURANT1_DAY9_1"	},
		{ "emily",			"qSay",				"RESTAURANT1_DAY9_2"	},
		{ "emily",			"qSetAppearance",	""						},
		{ "entertainer",	"qSetAppearance",	"ELF"					},
		{ "",				"parallel"									},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()	},
		{ "entertainer",	"qWalkToXY",		29, 14					},
		{ "",				"sequential"								},
		{ "scene",			"qFinishMovie"								},
		{ "scene",			"qStartGame"								},
	}
	
	qSequence(startSequence)

end

function day9:createObject(desc)

	local result = nil
	if (desc:getObjectId() == "rest1_karaoke") then
		result = karaoke()
		result:createHighlight()
		result:setType(desc:getType())
		result:setOverheadX(40)
		
	end
	return result
end

function day9:onTick(time)
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end
	
	if (not self.karaokeEventStarted) then
		self.karaokeEventTimer = self.karaokeEventTimer - time
		if (self.karaokeEventTimer <= 0) then
			self:startKaraokeEvent()
		end
	end
	
	if (not self.carolSingerTimerSuspended) then
		self.carolSingerTimer = self.carolSingerTimer - time
		if (self.carolSingerTimer <= 0) then
			self:startCarolSinging()
		end
	end
	
end

function day9:startKaraokeEvent()
	if (not self.karaokeEventStarted) then
		self.karaokeEventStarted = true
		
		richard = pm:createPerson("npc")
		richard:setBaseName("INGAME_PERSON_RICHARD_WINTER")
		richard:setDefaultSection("characters")
		richard:setVisible(false)
		
		self.fakeSinger = pm:createPerson("fakecustomer")
		self.fakeSinger:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_REGULAR")
		self.fakeSinger:setPosition(entryNode)
		self.fakeSinger:setVisible(false)
		
		local karaokeNode = self.karaoke:getWorkNode()
		-- sort out the sequence
		local karaokeEventSeq = 
		{
			{ "scene",			"qStartMovie",			1						},
			{ "",				"parallel",										},
			{ "emily",			"qWalkToXY",			27, 18					},
			{ "entertainer",	"qWalkToXY",			24, 18					},
			{ "",				"sequential",									},
			{ "emily",			"qSetAppearance",		"ROLL_EYES"				},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_10"	},
			{ "emily",			"qSetAppearance",		""						},
			{ "entertainer",	"qSay",					"RESTAURANT1_DAY9_11"	},
			{ "emily",			"qSetAppearance",		"MOBILE"				},
			{ "emily",			"qWait",				1000					},
			{ "scene",			"qFadeToBlack",									},
			{ "emily",			"qWait",				1000					},
			{ "scene",			"qFadeOutBlack",								},
			{ "emily",			"qWait",				500						},
			{ "emily",			"qSetAppearance",		"PANIC"					},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_12"	},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_13"	},
			{ "emily",			"qSetAppearance",		"NEUTRAL"				},
			{ "entertainer",	"qSay",					"RESTAURANT1_DAY9_14"	},
			{ "emily",			"qSetAppearance",		"HAPPY"					},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_145"	},
			{ "emily",			"qWalkToNode",			karaokeNode				},
			{ "emily",			"qSetAppearance",		"CURIOUS"				},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_15"	},
			{ "emily",			"qSetAppearance",		"NEUTRAL"				},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_16"	},
			{ "emily",			"qSetAppearance",		"SAD"					},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_17"	},
			{ "richard",		"qSetPosition",			entryNode				},
			{ "richard",		"qSetVisible",			true					},
			{ "richard",		"qWalkToXY",			21, 18					},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_18"	},
			{ "emily",			"qSetAppearance",		"FLIRT"					},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_19"	},
			{ "emily",			"qSetAppearance",		""						},
			{ "",				"parallel"										},
			{ "emily",			"qWalkToXY",			21, 18					},
			{ "richard",		"qWalkToNode",			karaokeNode				},
			{ "emily",			"qSetAppearance",		"UP"					},
			{ "entertainer",	"qSetAppearance",		"BACK_ELF"				},
			{ "",				"sequential",									},
			{ "richard",		"qAnimate",				"SING", -1				},
			{ "richard",		"qPlaySound",			"SOUND_SINGING_MALE_LOOP", true			},
			{ "",				"parallel"										},
			{ "fakeSinger",		"qSetVisible",			true					},
			{ "fakeSinger",		"qWalkToXY",			27, 18					},
			{ "fakeSinger",		"qSetAppearance",		"UP"					},
			{ "richard",		"qWait",				1000					},
			{ "",				"sequential",									},
			{ "scene",			"qFadeToBlack",									},
			{ "richard",		"qWait",				1000					},
			{ "scene",			"qFadeOutBlack",								},			
			{ "richard",		"qWait",				1000					},
			{ "richard",		"qStopSound",			"SOUND_SINGING_MALE_LOOP"	},
			{ "richard",		"qAnimate",				"IDLE", 0				},
			{ "richard",		"qSetAppearance",		"SMUG"					},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_20"	},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_21"	},
			{ "",				"parallel"										},
			{ "fakeSinger",		"qSetAppearance",		""						},
			{ "fakeSinger",		"qWalkToNode",			karaokeNode				},
			{ "fakeSinger",		"qSetAppearance",		""						},
			{ "richard",		"qWalkToXY",			27, 18					},
			{ "",				"sequential",									},
			{ "richard",		"qSetAppearance",		"UP"					},
			{ "fakeSinger",		"qAnimate",				"SING", -1				},
			{ "fakeSinger",		"qPlaySound",			"SOUND_SINGING_FEMALE_LOOP", true			},
			{ "fakeSinger",		"qWait",				2000					},
			{ "fakeSinger",		"qStopSound",			"SOUND_SINGING_FEMALE_LOOP"	},
			{ "fakeSinger",		"qAnimateWait",			"BOW", 1				},
			{ "fakeSinger",		"qAnimate",				"IDLE", 0				},
			{ "",				"parallel"										},
			{ "emily",			"qSetAppearance",		""						},
			{ "entertainer",	"qSetAppearance",		"ELF"					},
			{ "richard",		"qSetAppearance",		""						},
			{ "fakeSinger",		"qWalkToNode",			exitNode				},
			{ "fakeSinger",		"qSetVisible",			false					},
			{ "fakeSinger",		"qDestroy",										},
			-- part 2
			{ "emily",			"qSetAppearance",		"CURIOUS"				},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_22"	},
			{ "emily",			"qSetAppearance",		""						},
			{ "",				"sequential",									},
			{ "richard",		"qSetAppearance",		"ROLL_EYES"				},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_23"	},
			{ "richard",		"qSetAppearance",		"HAPPY"					},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_24"	},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_25"	},
			{ "richard",		"qSetAppearance",		""						},
			{ "emily",			"qSetAppearance",		"CURIOUS"				},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_26"	},
			{ "emily",			"qSetAppearance",		""						},
			{ "richard",		"qSetAppearance",		"ROLL_EYES"				},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_27"	},
			{ "richard",		"qSetAppearance",		""						},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_28"	},
			{ "emily",			"qSay",					"RESTAURANT1_DAY9_29"	},
			{ "richard",		"qWalkToNode",			grid:getNode(7, 16)		},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_291"	},
			{ "richard",		"qSay",					"RESTAURANT1_DAY9_292"	},
			{ "",				"parallel"										},
			{ "richard",		"qWalkToNode",			grid:getNode(0, 16)		},
			{ "richard",		"qSetVisible",			false					},
			{ "richard",		"qDestroy",										},
			{ "emily",			"qWalkToNode",			grid:getCounterNode()	},
			{ "entertainer",	"qWalkToXY",			29, 14					},
			{ "",				"sequential"									},
			{ "scene",			"qNotify",				"karaoke_start"			},
			{ "scene",			"qFinishMovie"									},
		}
		
		qSequence(karaokeEventSeq)
	end
end

function day9:onNotify(notification)
	if (notification == "karaoke_start") then
		self:resetCarolTimer()
		eventBar:animateToActive()
		eventBar:raiseCurtain()
		
	elseif (notification == "carol_singer_applauded") then
		self:increaseApplaudedCount()
		
	elseif (notification == "carol_singer_left") then
		self:resetCarolTimer()
		
	end
end

function day9:resetCarolTimer()
	if (self.nrCarolSingers < self.maxNrCarolSingers) then
		self.carolSingerTimer = getRandomRange(self.carolSingerMinTime, self.carolSingerMaxTime)
		self.carolSingerTimerSuspended = false
	end
end

function day9:startCarolSinging()
	if (self.karaoke ~= nil and not self.karaoke.busy and not self.karaoke.queued) then
		self.karaoke.queued = true
		self.carolSingerTimerSuspended = true
	end
end

function day9:increaseApplaudedCount()
	self.nrCarolSingers = self.nrCarolSingers + 1
	
	local node = self.karaoke:getWorkNode()
	incScore(self.scoreApplaudedOne, node:getScreenCenterX(), node:getScreenCenterY() + self.scoreOffsetY)	
	
	if (self.nrCarolSingers == self.maxNrCarolSingers) then
		incScore(self.scoreApplaudedAll, 400, 300, scoreBonusFloaterDelay, "BONUS")
		eventBar:animateToDeactive()
	end
	
	-- update progress bar
	eventBar:setProgress(self.nrCarolSingers)
end

function day9:onDayEnd()
	
	autoAllPeopleWalkOut = false
	
	local sequenceDayEnd =
	{
		{ "scene",			"qStartMovie",				1						},
		{ "",				"parallel"											},
		{ "emily",			"qWalkToXY",				37, 16					},
		{ "entertainer",	"qWalkToXY",				34, 16					},
		{ "",				"sequential"										},
		{ "emily",			"qSetAppearance", 			"CURIOUS"				},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY9_30"	},
		{ "emily",			"qSetAppearance", 			""						},
		{ "entertainer",	"qSetAppearance", 			"HAPPY_ELF"				},
		{ "entertainer",	"qSay", 					"RESTAURANT1_DAY9_31"	},
		{ "entertainer",	"qSay", 					"RESTAURANT1_DAY9_32"	},
		{ "entertainer",	"qSetAppearance", 			"NEUTRAL_ELF"			},
		{ "entertainer",	"qSay", 					"RESTAURANT1_DAY9_33"	},
		{ "emily",			"qSetAppearance", 			"CURIOUS"				},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY9_34"	},
		{ "emily",			"qSetAppearance", 			""						},
		{ "entertainer",	"qSetAppearance", 			"ELF"					},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY9_35"	},
		{ "entertainer",	"qSetAppearance", 			"HAPPY_ELF"				},
		{ "entertainer",	"qSay", 					"RESTAURANT1_DAY9_36"	},
		{ "entertainer",	"qSay", 					"RESTAURANT1_DAY9_37"	},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},
	}
	qSequence(sequenceDayEnd)
	
end

-- set day
day = day9()
