include("scripts/events/candle.lua")

-- day class
class 'day8' (interface)

day8.coupleInfo =
{
	{maleImage="MALE_WINTER_ELDERLY",	femaleImage="FEMALE_WINTER_CHILD",	candleIndex=1, lightOffsetsX={-1, 1}, lightOffsetsY={1, 1}, maleLightIdle="UP",	femaleLightIdle="UP"},
	{maleImage="MALE_WINTER_REGULAR",	femaleImage="FEMALE_WINTER_REGULAR",candleIndex=2, lightOffsetsX={-1, 1}, lightOffsetsY={1, 1}, maleLightIdle="UP",	femaleLightIdle="UP"},
	{maleImage="FEMALE_WINTER_REGULAR",	femaleImage="FEMALE_WINTER_REGULAR",candleIndex=3, lightOffsetsX={-1, 1}, lightOffsetsY={1, 1}, maleLightIdle="UP",	femaleLightIdle="UP"},
	{maleImage="PAUL_WINTER",			femaleImage="ANGELA_WINTER",		candleIndex=4, lightOffsetsX={-1, 1}, lightOffsetsY={-1, -1}, maleLightIdle="",	femaleLightIdle=""},
}

day8.maleAdmireOffsetX = -1
day8.maleAdmireOffsetY = -1
day8.femaleAdmireOffsetX = 1
day8.femaleAdmireOffsetY = -1

day8.coupleArriveTimes = 
{
	-- min time		max time
	{5 * 1000,		7 * 1000},
	{3 * 1000,		4 * 1000},
	{3 * 1000,		4 * 1000},
	{3 * 1000,		4 * 1000},
}

day8.timeEventStart = 20 * 1000			-- Time after which the event starts
day8.eventStartTimer = 0

day8.spawnTimerSuspended = false
day8.coupleSpawnTimer = 0
day8.candles = {}
day8.candleCounter = 0
day8.stands = {}
day8.standCounter = 0

day8.spawnCounter = 0
day8.nrToSpawn = 0

day8.couplesSpawned = {}

-- Candle info
day8.candleLitTime = 100 * 1000
day8.candleFadeTime = 8 * 1000
day8.candleTimeToLightFromFade = 1 * 1000
day8.candleTimeToLightFromDead = 2 * 1000

day8.startSequence = nil

function day8:__init() super()
end

function day8:onLevelGlobals()
	
	autoStartGame = true
	autoAllPeopleWalkIn = true
	
	maggie = pm:createPerson("story_character")
    maggie:setBaseName("INGAME_PERSON_MAGGIE_WINTER")
    maggie:setPosition(entryNode)
    maggie:setAppearance("RUN")
    maggie:setVisible(false)

	self.startSequence =
	{
		{ "scene",			"qStartMovie",		3						},
		{ "emily",			"qWalkToCounter"							},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_0"	},
		{ "maggie",			"qSetAppearance",	"RUN"					},
		{ "maggie",			"qSetVisible",		true					},
		{ "maggie",			"qWalkToXY",		23, 17					},
		{ "maggie",			"qSetAppearance",	""						},
		{ "emily",			"qSetAppearance",	"LAUGH"					},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_1"	},
		{ "emily",			"qSetAppearance",	""						},
		
		{ "",				"parallel"									},
		{ "emily",			"qWalkToXY",		26, 17					},
		{ "maggie",			"qSetAppearance",	"NERVOUS"				},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_2"	},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_3"	},
		{ "maggie",			"qSetAppearance",	""						},
		
		{ "",				"sequential"								},
		{ "emily",			"qSetAppearance",	"CONFUSED"				},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_4"	},
		{ "maggie",			"qSetAppearance",	"HAPPY"					},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_5"	},
		{ "emily",			"qSetAppearance",	"NEUTRAL"				},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_6"	},
		{ "emily",			"qSetAppearance",	"HAPPY"					},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_7"	},
		{ "emily",			"qSetAppearance",	"SUSPICIOUS"			},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_8"	},
		{ "maggie",			"qSetAppearance",	""						},
		{ "maggie",			"qSetAppearance",	"NERVOUS"				},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_9"	},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_10"	},
		{ "emily",			"qSetAppearance",	"PANIC"					},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_11"	},
		{ "maggie",			"qSetAppearance",	"HAPPY"					},
		{ "maggie",			"qSay",				"RESTAURANT1_DAY8_12"	},
		{ "emily",			"qSetAppearance",	"NEUTRAL"				},
		{ "emily",			"qSay",				"RESTAURANT1_DAY8_13"	},
		
		{ "scene",			"qFadeToBlack"								},
		{ "emily",			"qNotify",			"activate_candles"		},
		{ "maggie",			"qSetAppearance",	""						},
		{ "maggie",			"qSetPosition",		exitNode				},
		{ "maggie",			"qSetVisible",		false					},
		{ "maggie",			"qDestroy"									},
		{ "emily",			"qSetAppearance",	""						},
		{ "emily",			"qSetPosition",		grid:getCounterNode()	},
		{ "scene",			"qFinishMovie"								},
		{ "scene",			"qFadeOutBlack"								},
		{ "",				"parallel"									},			
	}
	
end

function day8:onDayBegin()
	
	self.eventStartTimer = self.timeEventStart
	self.spawnTimerSuspended = true		-- Kind of hack to make sure no couples are spawned before the event started
	self.spawnCounter = 100				-- Kind of hack to make sure no couples are spawned before the event started
	
	-- TODO: Move line below to onTick and run as soon as self.eventStartTimer becomes 0:
--	self.coupleSpawnTimer = getRandomRange(self.coupleArriveTimes[1][1], self.coupleArriveTimes[1][2])
	
	-- Check how many couples should be spawned
	local nrCouples = table.getn(self.coupleInfo)
	local nrTimers = table.getn(self.coupleArriveTimes)
	local nrCandles = table.getn(self.candles)
	
	if (nrCouples < nrTimers) then
		self.nrToSpawn = nrCouples
	else
		self.nrToSpawn = nrTimers
	end
	if (nrCandles < self.nrToSpawn) then
		self.nrToSpawn = nrCandles
	end
end

function day8:onTick(time)
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end
	
	if (self.eventStartTimer > 0) then
		
		self.eventStartTimer = self.eventStartTimer - time
		
		if (self.eventStartTimer <= 0) then
			qSequence(self.startSequence)
			self.coupleSpawnTimer = getRandomRange(self.coupleArriveTimes[1][1], self.coupleArriveTimes[1][2])
			self.spawnTimerSuspended = false	-- Undo our hack so couples will be spawned now.
			self.spawnCounter = 0				-- Undo our hack so couples will be spawned now.
			
		end
		
	end
	
	if (not self.spawnTimerSuspended and self.spawnCounter < self.nrToSpawn) then
		self.coupleSpawnTimer = self.coupleSpawnTimer - time
		if (self.coupleSpawnTimer <= 0) then
			self:spawnCouple()
			cout("-----> spawning couple \n")
		end
	end
end

function day8:onDayEnd()

	local musicId = 3
	local coupleInfo = self.coupleInfo[self.nrToSpawn]
	local candle = self.candles[coupleInfo.candleIndex]
	if (candle:isLit()) then
		musicId = 1
	end

	-- check the win/lose conditions
	local sequence =
	{
		{ "scene",			"qStartMovie", musicId	},
		{ "",				"parallel"				},
	}
	qSequence(sequence)
	
	for i = 1, self.spawnCounter do
		self:startCoupleInspectCandleSequence(i)
	end
	
	sequence = 
	{
		{ "",				"sequential"				},
		{ "emily",			"qWait",			1000	},
		{ "",				"parallel"					},
	}
	qSequence(sequence)
	
	for i = 1, (self.spawnCounter - 1) do
		self:endCoupleInspectCandleSequence(i)
	end

	-- now sort out Angela's end sequence
	local coupleInfo = self.coupleInfo[self.nrToSpawn]
	local candle = self.candles[coupleInfo.candleIndex]
	if (candle:isLit()) then
		local winSequence =
		{
			{ "",			"parallel"										},
			{ "emily",		"qWalkToXY",			26, 17					},
			{ "angela",		"qSetAppearance",		""						},
			{ "angela",		"qWalkToXY",			23, 17					},
			{ "",			"sequential"									},
			{ "angela",		"qSay",					"RESTAURANT1_DAY8_30"	},
			{ "angela",		"qSay",					"RESTAURANT1_DAY8_31"	},
			{ "emily",		"qSetAppearance",		"CURIOUS"				},
			{ "emily",		"qSay",					"RESTAURANT1_DAY8_32"	},
			{ "angela",		"qSetAppearance",		"ENTHOUSIASTIC"			},
			{ "emily",		"qSetAppearance",		""						},
			{ "angela",		"qSay",					"RESTAURANT1_DAY8_33"	},
		}
		qSequence(winSequence)
	else
		local loseSequence = 
		{
			{ "",			"parallel"										},
			{ "emily",		"qWalkToXY",			26, 17					},
			{ "angela",		"qSetAppearance",		"SAD"					},
			{ "paul",		"qSetAppearance",		""						},
			{ "angela",		"qWalkToXY",			23, 17					},
			{ "",			"sequential"									},
			{ "angela",		"qSay",					"RESTAURANT1_DAY8_39"	},
			{ "angela",		"qSetAppearance",		"SMIRK"					},
			{ "angela",		"qSay",					"RESTAURANT1_DAY8_40"	},
			{ "angela",		"qSetAppearance",		""						},
			{ "emily",		"qSetAppearance",		"NEUTRAL"				},
			{ "angela",		"qSay",					"RESTAURANT1_DAY8_31"	},
			{ "angela",		"qSay",					"RESTAURANT1_DAY8_41"	},
			{ "emily",		"qSay",					"RESTAURANT1_DAY8_42"	},
		}
		qSequence(loseSequence)
	end
	
	sequence =
	{
		{ "",			"parallel"						},
		{ "paul",		"qWalkToNode",		exitNode	},
		{ "angela",		"qWalkToNode",		exitNode	},
		{ "emily",		"qWalkToNode",		exitNode	},
		{ "",			"sequential"					},
		{ "scene",		"qFinishMovie"					},
	}
	qSequence(sequence)
	
	self.couplesSpawned = nil
end

function day8:createObject(desc)

	local result = nil
	if (desc:getObjectId() == "rest1_candle") then
		result = candle()
		result:setType(desc:getType())
		result.canFade = true
		result:setVisible(false)
		
		self.candleCounter = self.candleCounter + 1
		self.candles[self.candleCounter] = result
	
	elseif (desc:getObjectId() == "rest1_candle_stand") then
		result = D2Object()
		result:animate("OBJECT_CANDLE_STAND", 0)
		result:setType(desc:getType())
		result:setVisible(false)
		
		self.standCounter = self.standCounter + 1
		self.stands[self.standCounter] = result
	end
	
	return result
	
end

function day8:startAngelaSequence()
    
    local midSequence =
    {
		{ "scene",				"qStartMovie",			3							},
		
		{ "angela",				"qWalkToXY",			25, 25						},
		{ "emily",				"qSay",					"RESTAURANT1_DAY8_20"		},
		
		{ "",					"parallel"											},
		{ "angela",				"qSetAppearance",		"ENTHOUSIASTIC"				},
		{ "angela",				"qSay",					"RESTAURANT1_DAY8_21"		},
		{ "emily",				"qWalkToXY",				29, 25					},
		
		{ "",					"sequential"										},
		{ "emily",				"qSetAppearance",		"LAUGH"						},
		{ "emily",				"qSay",					"RESTAURANT1_DAY8_22"		},
		{ "angela",				"qSetAppearance",		"SMIRK"						},
		{ "angela",				"qSay",					"RESTAURANT1_DAY8_23"		},
		{ "angela",				"qSetAppearance",		"THINKING"					},
		{ "angela",				"qSay",					"RESTAURANT1_DAY8_24"		},
		{ "paul",				"qSetVisible",			true						},
		{ "paul",				"qWalkToXY",			22, 25						},
		{ "emily",				"qSetAppearance",		"SHOCK"						},
		{ "paul",				"qSay",					"RESTAURANT1_DAY8_25"		},
		{ "emily",				"qSetAppearance",		"NEUTRAL"					},
		{ "angela",				"qSetAppearance",		""							},
		{ "emily",				"qSay",					"RESTAURANT1_DAY8_26"		},
		{ "angela",				"qSay",					"RESTAURANT1_DAY8_27"		},
		
		{ "angela",				"qCallback",			self, function(self)  self:startAngelaCandleSequence() end },
		
		{ "",					"sequential"										},
		{ "emily",				"qSetAppearance",		""							},
		{ "scene",				"qFinishMovie"										},
    }
    
    qSequence(midSequence)
	
end

function day8:spawnCouple()
	
	if (self.spawnCounter < self.nrToSpawn) then
		
		self.spawnTimerSuspended = true
		self.spawnCounter = self.spawnCounter + 1
		
		if (self.spawnCounter == self.nrToSpawn) then
			angela = pm:createPerson("story_character")
			angela:setBaseName("INGAME_PERSON_ANGELA_WINTER")
			angela:setDefaultSection("characters")
			angela:setPosition(entryNode)
			angela:setVisible(true)
			
			paul = pm:createPerson("story_character")
			paul:setBaseName("INGAME_PERSON_PAUL_WINTER")
			paul:setDefaultSection("characters")
			paul:setPosition(entryNode)
			paul:setVisible(false)
			
			self.couplesSpawned[self.spawnCounter] = {}
			self.couplesSpawned[self.spawnCounter].male = paul
			self.couplesSpawned[self.spawnCounter].female = angela
			
			self:startAngelaSequence()
			
		else
			local coupleInfo = self.coupleInfo[self.spawnCounter]
			local section = "customers"
			local baseName = "INGAME_CUSTOMER_"
			
			local male = pm:createPerson("npc")
			male:setBaseName(baseName .. coupleInfo.maleImage)
			male:setDefaultSection(section)
			male:setVisible(false)
			male:setPosition(entryNode)
			
			local female = pm:createPerson("npc")
			female:setBaseName(baseName .. coupleInfo.femaleImage)
			female:setDefaultSection(section)
			female:setVisible(false)
			female:setPosition(entryNode)
			
			self.couplesSpawned[self.spawnCounter] = {}
			self.couplesSpawned[self.spawnCounter].male = male
			self.couplesSpawned[self.spawnCounter].female = female
			
			self:startCoupleCandleSequence(self.spawnCounter)
			
		end

	end
end

function day8:startAngelaCandleSequence()
	insert()
	self:startCoupleCandleSequence(self.nrToSpawn)
	append()
end

function day8:startCoupleCandleSequence(coupleIndex)
	
	if (coupleIndex <= self.nrToSpawn) then
	
		local male = self.couplesSpawned[coupleIndex].male
		local female = self.couplesSpawned[coupleIndex].female
		
		local coupleInfo = self.coupleInfo[self.spawnCounter]
		local candle = self.candles[coupleInfo.candleIndex]
		local candleWorkNode = candle:getWorkNode()
		local lightCommand = "lightCandle=" .. coupleInfo.candleIndex
		local leaveCommand = "triggerCoupleLeave=" .. coupleIndex
		
		male:qSetVisible(true)
		male:qWalkToXY(candleWorkNode:getGridX() + coupleInfo.lightOffsetsX[1], candleWorkNode:getGridY() + coupleInfo.lightOffsetsY[1])
		male:qSetAppearance(coupleInfo.maleLightIdle)
		
		female:qWait(250)
		female:qSetVisible(true)
		female:qWalkToXY(candleWorkNode:getGridX() + coupleInfo.lightOffsetsX[2], candleWorkNode:getGridY() + coupleInfo.lightOffsetsY[1])
		female:qSetAppearance(coupleInfo.femaleLightIdle)
		female:qNotify(lightCommand)
		female:qWait(750)
		female:qNotify(leaveCommand)
		
		--local seq =
		--{
			--{ "",				"parallel"							},
			--{ male,				"qSetVisible",	true				},
			--{ male,				"qWalkToXY",	candleWorkNode:getGridX() + coupleInfo.lightOffsetsX[1], candleWorkNode:getGridY() + coupleInfo.lightOffsetsY[1]},
			--{ male,				"qSetAppearance", coupleInfo.maleLightIdle				},
			--{ female,			"qWait",		250					},
			--{ female,			"qSetVisible",	true				},
			--{ female,			"qWalkToXY",	candleWorkNode:getGridX() + coupleInfo.lightOffsetsX[2], candleWorkNode:getGridY() + coupleInfo.lightOffsetsY[1]},
			--{ female,			"qSetAppearance", coupleInfo.femaleLightIdle				},
			--{ "",				"sequential"						},
			--{ "emily",			"qNotify",		lightCommand		},
			--{ female,			"qWait",		500					},
			--{ "",				"parallel"							},
			--{ male,				"qWalkToNode",	exitNode			},
			--{ male,				"qSetVisible",  false				},
			--{ female,			"qWalkToNode",	exitNode			},
			--{ female,			"qSetVisible",  false				},
			--{ "emily",			"qNotify",		"reset_timer"		},
		--}
		--
		--qSequence(seq)
	end
end

function day8:startCoupleInspectCandleSequence(coupleIndex)
	
	if (coupleIndex <= self.nrToSpawn) then
	
		local male = self.couplesSpawned[coupleIndex].male
		local female = self.couplesSpawned[coupleIndex].female
		
		local coupleInfo = self.coupleInfo[coupleIndex]
		local candle = self.candles[coupleInfo.candleIndex]
		local candleWorkNode = candle:getWorkNode()
		local appearance = "HAPPY"
		
		if (not candle:isLit()) then
			appearance = "ANGRY"
		end
		
		local maleWait = 250 * (coupleIndex - 1)
		local femaleWait = 250 * coupleIndex
		local seq =
		{
			{ male,				"qWait",			maleWait			},
			{ male,				"qSetVisible",		true				},
			{ male,				"qWalkToXY",		candleWorkNode:getGridX() + self.maleAdmireOffsetX, candleWorkNode:getGridY() + self.maleAdmireOffsetY},
			{ male,				"qSetAppearance",	appearance			},
			{ female,			"qWait",			femaleWait			},
			{ female,			"qSetVisible",		true				},
			{ female,			"qWalkToXY",		candleWorkNode:getGridX() + self.femaleAdmireOffsetX, candleWorkNode:getGridY() + self.femaleAdmireOffsetY},
			{ female,			"qSetAppearance",	appearance			},
		}
		
		qSequence(seq)
		
	end
end

function day8:endCoupleInspectCandleSequence(coupleIndex)
	
	if (coupleIndex < self.nrToSpawn) then
	
		local male = self.couplesSpawned[coupleIndex].male
		local female = self.couplesSpawned[coupleIndex].female
		local seq =
		{
			{ male,				"qWalkToNode",	exitNode			},
			{ male,				"qSetVisible",  false				},
			{ male,				"qDestroy",							},
			{ female,			"qWalkToNode",	exitNode			},
			{ female,			"qSetVisible",  false				},
			{ female,			"qDestroy",							},
		}
		
		qSequence(seq)
		
	end
end

function day8:onNotify(notification)
	
	if (notification == "activate_candles") then
		self:setupCandles()
	elseif (notification == "reset_timer") then
		-- reset the spawn timer
		local nextCoupleIndex = self.spawnCounter + 1
		if (nextCoupleIndex <= self.nrToSpawn) then
			self.coupleSpawnTimer = getRandomRange(self.coupleArriveTimes[nextCoupleIndex][1], self.coupleArriveTimes[nextCoupleIndex][2])
			self.spawnTimerSuspended = false
		else
			self.spawnTimerSuspended = true
		end
	else
		local command, index = string.match(notification, "(%a+)=(%d+)")
		--cout("command = '" .. command .. "', index = '" .. index .. "'\n")
		if (command == "lightCandle" and index ~= nil) then
			local candle = self.candles[tonumber(index)]
			candle:setFlameState("alight")
			candle:setClickable(true)
			
		elseif (command == "triggerCoupleLeave" and index ~= nil) then
			--cout("**** Trigger couple leave, #" .. index .. " ****\n")
			local numIndex = tonumber(index)
			local male = self.couplesSpawned[numIndex].male
			local female = self.couplesSpawned[numIndex].female

			male:qWalkToNode(exitNode)
			male:qSetVisible(false)
			female:qWalkToNode(exitNode)
			female:qSetVisible(false)
			female:qNotify("reset_timer")
			
		end
	end
end

function day8:setupCandles()
	local nrCandles = table.getn(self.candles)
	local nrStands = table.getn(self.stands)
	
	for i = 1, nrCandles do
		self.candles[i]:setVisible(true)
		self.candles[i]:setClickable(false)
		self.candles[i].timerSuspended = false
		self.candles[i].timeAlight = self.candleLitTime
		self.candles[i].timeToFade = self.candleFadeTime
		self.candles[i].timeToLightFromFade = self.candleTimeToLightFromFade
		self.candles[i].timeToLightFromDead = self.candleTimeToLightFromDead
	end
	
	for i = 1, nrStands do
		self.stands[i]:setVisible(true)
	end
end

-- set day
day = day8()