include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Postcard"
}
-- day class
class 'day7' (interface)

day7.timeUntilFirstWalk = 		4 * 1000		-- Time before Paul walks to first card. (measured from day start)
day7.timeUntilFirstPick = 		5 * 1000		-- Time before Paul picks up card. (measured from where he STARTED walking)
day7.timeUntilFirstRemark = 	2 * 1000		-- Time before Paul makes remark. (measured from where he STARTED picking up)
day7.xPosFirstPickup = 			3
day7.yPosFirstPickup = 			18

												-- /!\ KEEP IN MIND THAT FIRST PICKUP MUST BE FINISHED COMPLETELY!
day7.timeUntilSecondWalk = 		20 * 1000		-- Time before Paul walks to second card. (measured from day start)
day7.timeUntilSecondPick = 		5 * 1000		-- Time before Paul picks up card. (measured from where he STARTED walking)
day7.timeUntilSecondRemark = 	2 * 1000		-- Time before Paul makes remark. (measured from where he STARTED picking up)
day7.xPosSecondPickup = 		47
day7.yPosSecondPickup = 		22
												-- /!\ KEEP IN MIND THAT SECOND PICKUP MUST BE FINISHED COMPLETELY!
day7.timeUntilThirdWalk = 		40 * 1000		-- Time before Paul walks to third card. (measured from day start)
day7.timeUntilThirdPick = 		10 * 1000		-- Time before Paul picks up card. (measured from where he STARTED walking)
day7.timeUntilThirdRemark = 	2 * 1000		-- Time before Paul makes remark. (measured from where he STARTED picking up)
day7.xPosThirdPickup = 			8
day7.yPosThirdPickup = 			9

day7.timeRemark	= 				2 * 1000		-- Time the remark is on screen.

day7.xPosReady = 				43				-- Position Paul walks to after he found all his (three) cards during the day
day7.yPosReady = 				12

-- Please keep away from these babies unless you know what you are doing:
day7.timerFirst = 0
day7.timerSecond = 0
day7.timerThird = 0
day7.nextAction = ""

function day7:__init() super()
end

function day7:onLevelGlobals()

	self.nextAction = "Walk to pickup"
	
	self.timerFirst = self.timeUntilFirstWalk
	self.timerSecond = self.timeUntilSecondWalk
	self.timerThird = self.timeUntilThirdWalk
	
	if (self.timerSecond < self.timerFirst + self.timeUntilFirstPick + self.timeUntilFirstRemark + self.timeRemark) then
		self.timerSecond = self.timerFirst + self.timeUntilFirstPick + self.timeUntilFirstRemark + self.timeRemark
		cout("day7:onLevelGlobals(): timerSecond was too low, manually adjusted to " .. self.timerSecond .. "\n")
	end
	
	if (self.timerThird < self.timerSecond + self.timeUntilSecondPick + self.timeUntilSecondRemark + self.timeRemark) then
		self.timerThird = self.timerSecond + self.timeUntilSecondPick + self.timeUntilSecondRemark + self.timeRemark
		cout("day7:onLevelGlobals(): timerThird was too low, manually adjusted to " .. self.timerThird .. "\n")
	end

	-- set event configuration
	event.baseName = "INGAME_PERSON_PAUL_WINTER"
	event.entryX = 49
	event.entryY = 16
	event.highlightX = 24
	event.highlightY = 22
	event.timeUntilEnterMin = 1
	event.timeUntilEnterMax = 2
	event.scoreFoundOne	= 10
	event.scoreFoundAll	= 30
	event.showItemsFromStart = true
	event.sequenceStart	= 								-- text when event starts
	{	
		{ "scene",		"qStartMovie",		3							},
		{ "",			"sequential"									},
		{ "emily",		"qSetAppearance",	"PANIC"						},
		{ "emily",		"qWalkToXY",		37, 16						},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_0"	    },
		{ "person",		"qWalkToXY",		44, 14						},
		{ "person",		"qSay",		        "RESTAURANT1_DAY7_1"	    },
		{ "emily",		"qSetAppearance",	"LAUGH"						},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_17"	    },
		{ "emily",		"qSetAppearance",	"HAPPY"						},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_18"	    },
		{ "emily",		"qSetAppearance",	""							},
		{ "emily",		"qWalkToCounter"								},
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qNotify",			"ho_arrived"				},		
		{ "scene",		"qNotify",			"show bar"					},
		{ "",			"parallel"										},			
	}

	event.sequenceDone = 
	{	
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie",		1							},
		{ "",			"parallel"										},
		{ "person",		"qWalkToXY",		34, 17						},
		{ "emily",		"qWalkToCounter"								},
		{ "",			"sequential"									},
		{ "person",		"qAnimateWait",		"PICK_UP", 1			    },
		{ "person",		"qWalkToXY",		26, 34						},
		{ "person",		"qSay",		        "RESTAURANT1_DAY7_2"	    },
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_3"	    },
		{ "person",		"qWalkToXY",		47, 33						},
		{ "scene",		"qFinishMovie" 									},
	}
	
	event.sequenceFail = 
	{	
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie",		1							},
		{ "",			"parallel"										},
		{ "person",		"qWalkToXY",		34, 17						},
		{ "emily",		"qWalkToCounter"								},
		{ "",			"sequential"									},
		{ "person",		"qAnimateWait",		"PICK_UP", 1			    },
		{ "person",		"qWalkToXY",		26, 34						},
		{ "person",		"qSetAppearance",	"SAD"		    			},
		{ "person",		"qSay",		        "RESTAURANT1_DAY7_4"	    },
		{ "emily",		"qSetAppearance",	"NEUTRAL"	    			},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_5"	    },
		{ "person",		"qSetAppearance",	""			    			},
		{ "emily",		"qSetAppearance",	""			    			},
		{ "person",		"qWalkToXY",		32, 28						},
	
	}
		
	self.sequenceEnd = 
	{
		{ "",			"sequential"									},
		{ "emily",		"qWalkToXY",		28, 28						},
		{ "emily",		"qWalkToXY",		41, 28						},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_6"	    },
		{ "person",		"qSetAppearance",	"ROLLEYES"	    			},
		{ "person",		"qSay",		        "RESTAURANT1_DAY7_7"	    },
		{ "person",		"qSetAppearance",	""			    			},
		{ "emily",		"qSetAppearance",	"FLIRT"		    			},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_8"	    },
		{ "emily",		"qSetAppearance",	""			    			},
		{ "person",		"qSetAppearance",	"BLUSH"		    			},
		{ "person",		"qSay",		        "RESTAURANT1_DAY7_9"	    },
		{ "person",		"qSetAppearance",	""			    			},
		{ "",			"parallel"										},
		{ "emily",		"qWalkToXY",		38, 15						},
		{ "person",		"qWalkToXY",		39, 24						},
		{ "",			"sequential"									},
		{ "person",		"qWalkToXY",		49, 16						},
		{ "person",		"qSetVisible",		false						},
		
		{ "entertainer","qAnimate",			"THINKING_ELF", 0 		    },
		{ "entertainer","qSay",		        "RESTAURANT1_DAY7_10"	    },
		{ "entertainer","qAnimate",			"IDLE", 0 				    },
		{ "entertainer","qSetAppearance",	"ELF"	 				    },
		{ "emily",		"qSetAppearance",	"ROLL_EYES"	    			},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_11"	    },
		{ "emily",		"qSetAppearance",	""			    			},
		{ "entertainer","qSay",		        "RESTAURANT1_DAY7_12"	    },
		{ "emily",		"qSetAppearance",	"FLIRT"		    			},
		{ "emily",		"qSay",		        "RESTAURANT1_DAY7_13"	    },
		{ "entertainer","qAnimate",			"SURPRISED_ELF", 0 		    },
		{ "entertainer","qSay",		        "RESTAURANT1_DAY7_14"	    },
		{ "entertainer","qAnimate",			"DISGUSTED_ELF", 0 		    },
		{ "entertainer","qSay",		        "RESTAURANT1_DAY7_15"	    },
		{ "entertainer","qAnimate",			"IDLE", 0 				    },
		{ "entertainer","qSetAppearance",	"ELF"			   			},
		{ "emily",		"qSetAppearance",	""			    			},
	}

end

function day7:onTick(time)
	
	if (scene:isStartingMovie() or scene:isPlayingMovie() or event.completed) then
		return
	end
	
	if (self.timerFirst > 0) then
		
		self.timerFirst = self.timerFirst - time
		self.timerSecond = self.timerSecond - time
		self.timerThird = self.timerThird - time
		
		if (self.timerFirst <= 0) then
			if (self.nextAction == "Walk to pickup") then
				event.person:qWalkToXY(self.xPosFirstPickup, self.yPosFirstPickup)
				self.nextAction = "Pick up"
				self.timerFirst = self.timeUntilFirstPick
			elseif (self.nextAction == "Pick up") then
				event.person:animate("PICK_UP", 1)
				self.nextAction = "Make remark"
				self.timerFirst = self.timeUntilFirstRemark
			elseif (self.nextAction == "Make remark") then
				event.person:animate("IDLE", 0)
				event.person:qSayTimed("RESTAURANT1_DAY7_16", self.timeRemark)
				self.nextAction = "Walk to pickup"
			end
		end
	
	elseif(self.timerSecond > 0) then

		self.timerSecond = self.timerSecond - time
		self.timerThird = self.timerThird - time
		
		if (self.timerSecond <= 0) then
			if (self.nextAction == "Walk to pickup") then
				event.person:qWalkToXY(self.xPosSecondPickup, self.yPosSecondPickup)
				self.nextAction = "Pick up"
				self.timerSecond = self.timeUntilSecondPick
			elseif (self.nextAction == "Pick up") then
				event.person:animate("PICK_UP", 1)
				self.nextAction = "Make remark"
				self.timerSecond = self.timeUntilSecondRemark
			elseif (self.nextAction == "Make remark") then
				event.person:animate("IDLE", 0)
				event.person:qSayTimed("RESTAURANT1_DAY7_16", self.timeRemark)
				self.nextAction = "Walk to pickup"
			end
		end
	
	elseif(self.timerThird > 0) then

		self.timerThird = self.timerThird - time
		
		if (self.timerThird <= 0) then
			if (self.nextAction == "Walk to pickup") then
				event.person:qWalkToXY(self.xPosThirdPickup, self.yPosThirdPickup)
				self.nextAction = "Pick up"
				self.timerThird = self.timeUntilThirdPick
			elseif (self.nextAction == "Pick up") then
				event.person:animate("PICK_UP", 1)
				self.nextAction = "Make remark"
				self.timerThird = self.timeUntilThirdRemark
			elseif (self.nextAction == "Make remark") then
				event.person:animate("IDLE", 0)
				event.person:qSayTimed("RESTAURANT1_DAY7_16", self.timeRemark)
				event.person:qWalkToXY(self.xPosReady, self.yPosReady)
				self.nextAction = "Grab a beer"
			end
		end
		
	end
	
end

function day7:onDayEnd()
	if (event.completed) then
		scene:qStartMovie(1)
	end	
	if (self.sequenceEnd ~= nil) then
		qSequence(self.sequenceEnd)		
	end		
	scene:qFinishMovie()
end

-- set day
day = day7()