include("scripts/events/mailmanevent.lua")

-- set event
event = mailmanEvent()

-- day class
class 'day6' (interface)

day6.chairNode = nil

function day6:__init() super()
end

function day6:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	self.chairNode = grid:getNode(23, 12)
	
	-- create santa
    bill = pm:createPerson("npc")
    bill:setBaseName("INGAME_PERSON_SPECIAL_MAILMAN")
    bill:setDefaultSection("characters")
    bill:setPosition(grid:getNode(49, 16))
    bill:setVisible(false)
	
	-- position everyone
    emily:setPosition(grid:getCounterNode())
    
    -- create santa
    santa = pm:createPerson("npc")
    santa:setBaseName("INGAME_PERSON_SANTA")
    santa:setDefaultSection("characters")
    santa:setPosition(grid:getEntryNode())

	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.timeUntilEnterMin = 20000
	event.timeUntilEnterMax = 24000
	event.timeUntilAngry = 6000
	event.timeUntilLeave = 3000
	event.numPackages = 8
	event.entryX = entryX
	event.entryY = entryY
	event.waitX = 39
	event.waitY = 16
	event.workX = 35
	event.workY = 16
	event.angryAnim = "IDLE_WAITING"
	event.workAnim = "GIVE_LEFT"
	event.workAnimEmily = "WORK_RIGHT"
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie",		2							},
		{ "santa",			"qWalkToXY",		30,	29						},
		{ "santa",			"qSay",				"RESTAURANT1_DAY6_0"		},
		{ "emily",			"qSetAppearance",	"FLIRT"						},
		{ "emily",			"qSay",				"RESTAURANT1_DAY6_1"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY6_2"		},
		{ "santa",			"qSay",				"RESTAURANT1_DAY6_3"		},
		{ "emily",			"qSetAppearance",	""							},
		{ "emily",			"qSay",				"RESTAURANT1_DAY6_4"		},
		{ "santa",			"qWalkToNode",		self.chairNode				},
		{ "santa",			"qAnimate",			"SIT_FRONT", 0				},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},
	}
	event.sequenceComplete = 
	{
		{ "scene",			"qStartMovie",		2							},
		{ "emily",			"qWalkToXY",		20,	15						},
		{ "emily",			"qSay",				"RESTAURANT1_DAY6_5"		},
		{ "santa",			"qSay",				"RESTAURANT1_DAY6_6"		},
		{ "scene",			"qFinishMovie" 									},
	}	

end

function day6:onDayEnd()

	if (event.gotAllPackages == false) then
		
		autoAllPeopleWalkOut = false
		
		local sequenceDayEnd =
		{
			{ "scene",			"qStartMovie",		1							},
			{ "emily",			"qWalkToXY",		20,	15						},
			{ "emily",			"qSetAppearance",	"SAD"						},
			{ "emily",			"qSay",				"RESTAURANT1_DAY6_7"		},
			{ "santa",			"qSetAppearance",	"SAD"						},
			{ "santa",			"qSay",				"RESTAURANT1_DAY6_8"		},
			{ "bill",			"qSetAppearance",	"CARRY"						},
			{ "bill", 			"qSetVisible", 		true						},
			{ "bill",			"qWalkToXY",		33,	16						},
			{ "bill",			"qSay",				"RESTAURANT1_DAY6_9"		},
			{ "emily",			"qSetAppearance",	""							},
			{ "", 				"parallel"										},
			{ "santa",			"qSetAppearance",	""							},
			{ "santa",			"qAnimate",			"IDLE", 0					},
			{ "emily",			"qAnimateWait",		"JUMP", 1, true, 8			},
			{ "emily",			"qAnimate",			"IDLE", 0					},
			{ "", 				"sequential"									},
			{ "", 				"parallel"										},
			{ "emily",			"qSay",				"RESTAURANT1_DAY6_10"		},
			{ "santa",			"qSay",				"RESTAURANT1_DAY6_10"		},
			{ "", 				"sequential"									},
			{ "bill",			"qSay",				"RESTAURANT1_DAY6_11"		},
			{ "emily",			"qSay",				"RESTAURANT1_DAY6_12"		},
			{ "bill",			"qSay",				"RESTAURANT1_DAY6_13"		},
			{ "bill",			"qWalkToXY",		27,	15						},
			{ "bill",			"qAnimateWait",		"PUTDOWN_BACK", 1, false, 8	},
			{ "bill",			"qSetAppearance",	""							},
			{ "bill",			"qAnimate",			"IDLE_UP", 0				},
			{ "scene",			"qFinishMovie" 									},
			{ "scene",			"qFinishGame" 									},
		}
		qSequence(sequenceDayEnd)
		
	end
	
end

-- set day
day = day6()