-- day class
class 'day5' (interface)


-- Tweak values:
day5.timeBeforeSwitch = 3 * 1000	-- How many (milli) seconds before the switch happens?
day5.speedMultiplier = 1.3			-- How many times is Richard faster than Emily?

-- Don't change:
day5.sequenceSwitch = nil
day5.switchTimer = 0

function day5:__init() super()
end

function day5:onLevelGlobals()

	self.switchTimer = self.timeBeforeSwitch

	-- create tashi
    richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD_WINTER")
    richard:setVisible(false)
    richard:setDefaultSection("characters")
    richard:setPosition(grid:getNode(0, 16))
    
	self.sequenceSwitch = 
  	{
  		{ "scene",			"qStartMovie",				3						},
  		{ "", 				"parallel"											},
  		{ "emily",			"qWalkToXY",				20, 28					},
  		{ "richard",		"qSetVisible",				true					},
		{ "richard",		"qWalkToXY",				15, 14					},
		{ "", 				"sequential"										},
		{ "emily",			"qAnimateWait", 			"WORK_FRONT", 2			},
		{ "emily",			"qAnimate", 				"IDLE", 0				},
		{ "emily",			"qSetAppearance", 			"PAIN"					},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY5_0"	},
		{ "richard",		"qWalkToXY",				25, 22					},
		{ "richard",		"qSetAppearance", 			"SMUG"					},
		{ "richard",	 	"qSay", 					"RESTAURANT1_DAY5_1"	},
		{ "richard",		"qSetAppearance", 			""						},
		{ "emily",			"qSetAppearance", 			"ROLL_EYES"				},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY5_2"	},
		{ "richard",		"qSetAppearance", 			"THINKING"				},
		{ "richard",		"qWait", 					1500					},
		{ "emily",			"qSetAppearance", 			""						},
		{ "richard",		"qWalkToXY",				34, 14					},
		{ "richard",		"qSetAppearance", 			""						},
		{ "richard",	 	"qSay", 					"RESTAURANT1_DAY5_3"	},
		{ "emily",			"qWalkToXY",				34, 14					},
		{ "emily",		 	"qSetAppearance", 			"RICHARD"				},	-- From this moment on, Richard
		{ "richard",		"qAnimate", 				"EMILY_SIZZLE", 0		},	-- and emily are switched
		{ "emily",			"qWalkToXY",				39, 14					},
		{ "richard",		"qWait", 					1000					},
		{ "richard",	 	"qSay", 					"RESTAURANT1_DAY5_4"	},
		{ "emily",			"qAnimate",					"LAUGH_RICHARD", -1, 8	},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY5_5"	},
		{ "emily",			"qAnimate",					"IDLE_RICHARD", 0		},
		{ "emily",		 	"qSetAppearance", 			"HAPPY_RICHARD"			},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY5_6"	},
		{ "emily",		 	"qSetAppearance", 			"RICHARD"				},
		{ "scene",			"qFinishMovie" 										}
  	}
	
end


function day5:onTick(time)
	
	-- wait until we can switch
	if (self.switchTimer > 0) then
		
	    self.switchTimer = self.switchTimer - time
	    if (self.switchTimer <= 0) then

			-- start sequence
			if (self.sequenceSwitch ~= nil) then
				qSequence(self.sequenceSwitch)
				emily:qSetWalkTimePerNode(emily:getWalkTimePerNode() / self.speedMultiplier)
			end			
	    	
	    end	
	end

end

function day5:onDayEnd()

	autoAllPeopleWalkOut = false
	
	local sequenceDayEnd =
	{
		{ "scene",			"qStartMovie",				3						},
		{ "emily",			"qWalkToXY",				34, 14					},
		{ "emily",		 	"qSetAppearance", 			""						},	-- From this moment on, Richard
		{ "richard",		"qAnimate", 				"IDLE", 0				},	-- and emily are switched back again
		{ "richard",		"qSetAppearance", 			"WORRIED"				},
		{ "emily",			"qWalkToXY",				39, 14					},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY5_7"	},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY5_8"	},
		{ "richard",		"qSetAppearance", 			"HAPPY"					},
		{ "richard",	 	"qSay", 					"RESTAURANT1_DAY5_9"	},
		{ "richard",		"qSetAppearance", 			"SORRY"					},
		{ "richard",	 	"qSay", 					"RESTAURANT1_DAY5_10"	},
		{ "emily",			"qSetAppearance", 			"FLIRT"					},
		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY5_11"	},
		{ "richard",		"qSetAppearance", 			""						},
		{ "emily",			"qSetAppearance", 			""						},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},
	}
	qSequence(sequenceDayEnd)
	
end

-- set day
day = day5()