include("scripts/events/cameraevent.lua")

-- set event
event = cameraEvent()

-- day class
class 'day4' (interface)

function day4:__init() super()
end

function day4:onLevelGlobals()
	
	local sequence2 =
	{
--		{ "camPerson",		"qSayTimed",		"RESTAURANT0_DAY5_20", 3000	},		
	}
	
	-- create tashi
    tashi = pm:createPerson("npc")
    tashi:setBaseName("INGAME_PERSON_TASHI")
    tashi:setVisible(false)
    tashi:setDefaultSection("characters")
    tashi:setPosition(grid:getNode(0, 16))


	-- set event configuration
	event.baseName = "INGAME_PERSON_BEAGLE_WINTER"
	event.coordinates =
	{-- |  dog	 |   em   |
		{ 39, 15, 36, 15 },
	--	{  9, 16, 13, 16, sequence2 },
		{  3,  5,  5,  8 },
		{  2, 16,  5, 17 },	
		{ 48, 33, 48, 30 },
		{ 11, 31,  9, 32 },	
		{ 24, 18, 26, 17 },
	}
	event.score = 500
	event.timerStart = 17 * 1000
	event.timerReturn = 8 * 1000
	event.scoreGotOne = 15
	event.scoreGotAll = 100
	event.sequenceStart =
	{
		{ "scene",			"qStartMovie",		2							},
		{ "",				"parallel"										},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "camPerson",		"qSetAppearance",	"RUN"						},
		{ "camPerson",		"qSetPosition",		movieNode					},
		{ "camPerson",		"qWalkToXY",		25, 21						},
		{ "",				"sequential"									},
		{ "emily",			"qWalkToXY",		27, 20						},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_0"		},
		{ "camPerson",		"qAnimateWait",		"JUMP_UP", 1				},
		{ "emily",			"qAnimate",			"LAUGH", -1, 8				},
		{ "emily",			"qWait",			750							},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_1"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_2"		},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "scene", 			"qFinishMovie" 									},
	}
	event.sequenceTooLate =
	{
		{ "camPerson",		"qSayTimed",		"RESTAURANT1_DAY4_BARF_SAD", 1000	},		
	}
	event.sequenceCompleted =
	{
		{ "scene",			"qStartMovie",		2							},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_3"		},
		{ "camPerson",		"qAnimateWait",		"JUMP_UP", 1				},
		{ "emily",			"qAnimate",			"LAUGH", -1, 8				},
		{ "emily",			"qWait",			750							},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_4"		},
		{ "camPerson",		"qAnimate",			"EAT", -1, 4				},
		{ "camPerson",		"qWait",			1500						},
		{ "camPerson",		"qAnimate",			"IDLE", 0					},
		{ "",				"parallel"										},
		{ "emily",			"qWalkToNode",		grid:getCounterNode()		},
		{ "camPerson",		"qWalkToXY",		48, 33						},
		{ "",				"sequential"									},
		{ "scene", 			"qFinishMovie" 									},
	}
	
end

function day4:onDayEnd()

	autoAllPeopleWalkOut = false
	
	local sequenceDayEnd =
	{
		{ "scene",			"qStartMovie",		2							},
		{ "",				"parallel"										},
		{ "tashi",			"qSetVisible",		true						},
		{ "tashi",			"qWalkToXY",		23, 24						},
		{ "camPerson",		"qWalkToXY",		27, 24						},
		{ "",				"sequential"									},
		{ "tashi",			"qSay",				"RESTAURANT1_DAY4_5"		},
		{ "",				"parallel"										},
		{ "tashi",			"qWalkToXY",		32, 28						},
		{ "camPerson",		"qWalkToXY",		28, 28						},
		{ "",				"sequential"									},
		{ "tashi",			"qSay",				"RESTAURANT1_DAY4_6"		},
		{ "tashi",			"qSay",				"RESTAURANT1_DAY4_7"		},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_8"		},
		{ "",				"parallel"										},
		{ "camPerson",		"qWalkToXY",		27, 34						},
		{ "emily",			"qWalkToXY",		31, 34						},
		{ "",				"sequential"									},
		{ "emily",			"qSay",				"RESTAURANT1_DAY4_9"		},
		{ "camPerson",		"qAnimate",			"BARK", -1, 4				},
		{ "camPerson",		"qWait",			1500						},
		{ "camPerson",		"qAnimate",			"IDLE", 0					},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}
	qSequence(sequenceDayEnd)
	
end

-- set day
day = day4()