include("scripts/events/cleaningreappearevent.lua")

-- set event
event = cleaningReappearEvent()
event.pixelsToClean = 350


-- day class
class 'day3' (interface)

day3.paulBlushing = false
day3.blushTimer = 0
day3.timeBlush = 2000				-- Time Paul blushes after each clean
day3.timeBetweenThrowMin = 10000
day3.timeBetweenThrowMax = 15000
day3.timeBetweenThrowTimer = 0		-- Counts time until next ball will be thrown
day3.throwAnimTimer = 0				-- Counts time until throw anim is finished (and result should be shown)
day3.framerateThrowSnowAnim = 12
day3.timeThrowSnowAnim = 0			-- Time until throw anim is finished
day3.framecountThrowSnowAnim = 20
day3.childBoyThrows = true
day3.missCount = 0
day3.timeBeforeSelfClean = 8000		-- Time until Paul cleans his own face
day3.timeBeforeSelfCleanTimer = 0	-- Counts time before Paul cleans his own face

day3.missPaul = nil
day3.missChair = nil
day3.missTable = nil

day3.snowballHit = nil

function day3:__init() super()
end

function day3:onLevelGlobals()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	self.timeBetweenThrowTimer = 0
	self.throwAnimTimer = 0
	local frameTimeThrowSnowAnim = (1000 / self.framerateThrowSnowAnim)
	self.timeThrowSnowAnim = (frameTimeThrowSnowAnim * self.framecountThrowSnowAnim)
	self.missCount = 0
	self.childBoyThrows = true

	event.eventBarImage = "EVENT_PAUL_SNOW_HIT_BAR"
	event.scoreFoundOne	= 50
	event.scoreFoundAll	= 100
	
	self.snowballHit = createSprite()
	self.snowballHit:setDefaultSection(player:getCurrentResourceSection())
	self.snowballHit:animate("EVENT_PAUL_SNOW_HIT", 0)
	self.snowballHit:setAlpha(1)
	self.snowballHit:setX(619)
	self.snowballHit:setY(298)
	level:getLayer(LAYER_FLOATERS):addChild(self.snowballHit)
	self.snowballHit:setVisible(false)
	
    -- initialize emily:
    emily:setPosition(grid:getCounterNode())
    
    -- initialize entertainer:
    entertainer:setPosition(grid:getEntertainerNode())
    
    -- create paul
    paul = pm:createPerson("npc")
    paul:setBaseName("INGAME_PERSON_PAUL_WINTER")
    paul:setDefaultSection("characters")
    paul:setPosition(grid:getNode(0, 16))
    self.blushTimer = 0
    self.lastThrower = nil
    
    -- create childBoy
    childBoy = pm:createPerson("npc")
    childBoy:setBaseName("INGAME_CUSTOMER_MALE_WINTER_CHILD")
    childBoy:setDefaultSection("customers")
    -- childBoy:setPosition(grid:getNode(21, 2))
    childBoy:setPosition(grid:getNode(0, 16))
    childBoy:setAppearance("RUN")
    
	-- create childGirl
    childGirl = pm:createPerson("npc")
    childGirl:setBaseName("INGAME_CUSTOMER_FEMALE_WINTER_CHILD")
    childGirl:setDefaultSection("customers")
    childGirl:setPosition(grid:getNode(0, 16))
    childGirl:setAppearance("RUN")
    
    self.missPaul = getObject("rest1_miss_paul")
	self.missChair = getObject("rest1_miss_chair")
	self.missTable = getObject("rest1_miss_table")
	
	self.missPaul:setVisible(false)
	self.missChair:setVisible(false)
	self.missTable:setVisible(false)
	
	self.missPaul:setAcceptingTasks(true)
	self.missChair:setAcceptingTasks(true)
	self.missTable:setAcceptingTasks(true)
  
  	local sequenceStart = 
	{
		{ "scene",			"qStartMovie",				1							},
		{ "", 				"parallel"												},
		{ "childBoy",		"qWalkToXY", 				11, 21						},
		{ "childGirl",		"qWalkToXY", 				26, 20						},
		{ "", 				"sequential"											},
		{ "childGirl",		"qAnimateWait", 			"THROW_SNOWBALL_LEFT", 1	},
		{ "missTable",		"qSetVisible",				true						},
		{ "missTable",		"qAnimateWait",				"OBJECT_SNOW_MISS_TABLE", 1, false, 12	},
		{ "missTable",		"qDestroy"												},
		{ "", 				"parallel"												},
		{ "childBoy",		"qWalkToXY", 				23, 19						},
		{ "childGirl",		"qWalkToXY", 				38, 20						},
		{ "", 				"sequential"											},
		{ "childBoy",		"qAnimateWait", 			"THROW_SNOWBALL_RIGHT", 1	},
		{ "missChair",		"qSetVisible",				true						},
		{ "missChair",		"qAnimateWait",				"OBJECT_SNOW_MISS_CHAIR", 1, false, 12	},
		{ "missChair",		"qDestroy"												},
		{ "", 				"parallel"												},
		{ "entertainer", 	"qWalkToNode", 				grid:getEntertainerNode()	},
		{ "paul",		 	"qWalkToXY", 				29, 29						},
		{ "emily",		 	"qWalkToNode", 				grid:getCounterNode()		},
		{ "childBoy",		"qWalkToXY", 				26, 15						},
		{ "childGirl",		"qWalkToXY", 				26, 32						},
		{ "", 				"sequential"											},
		{ "paul",			"qSetAppearance", 			"SORRY"						},
		{ "paul",		 	"qSay", 					"TEXT_RESTAURANT1_DAY3_0"	},
		{ "emily",		 	"qSay", 					"TEXT_RESTAURANT1_DAY3_1"	},
		{ "", 				"parallel"												},
		{ "childBoy",		"qWalkToXY", 				24, 23						},
		{ "childGirl",		"qWalkToXY", 				40, 24						},
		{ "", 				"sequential"											},
		{ "childBoy",		"qAnimateWait", 			"THROW_SNOWBALL_RIGHT", 1	},
		{ "scene", 			"qNotify", 					"hit girl"					},	-- Girl is hit!
		{ "childBoy",		"qWait",					2000						},
		{ "scene", 			"qNotify", 					"snow gone"					},
		{ "childGirl",		"qSetAppearance", 			"ANGRY"						},
		{ "childGirl",		"qSay", 					"TEXT_RESTAURANT1_DAY3_2"	},
		{ "emily",		 	"qWalkToXY", 				38, 23						},
		{ "emily",			"qSetAppearance", 			"CURIOUS"					},
		{ "emily",		 	"qSay", 					"TEXT_RESTAURANT1_DAY3_3"	},
		{ "emily",			"qSetAppearance", 			""							},
		{ "childGirl",		"qSay", 					"TEXT_RESTAURANT1_DAY3_4"	},
		{ "childBoy",		"qSay", 					"TEXT_RESTAURANT1_DAY3_5"	},
		{ "emily",		 	"qWalkToXY", 				34, 29						},
		{ "paul",			"qSetAppearance", 			""							},
		{ "paul",		 	"qSay", 					"TEXT_RESTAURANT1_DAY3_6"	},
		{ "emily",			"qSetAppearance", 			"NEUTRAL"					},
		{ "emily",		 	"qSay", 					"TEXT_RESTAURANT1_DAY3_7"	},
		{ "emily",			"qSetAppearance", 			""							},
		{ "paul",		 	"qWalkToXY", 				33, 23						},
		{ "paul",		 	"qSay", 					"TEXT_RESTAURANT1_DAY3_8"	},
		{ "paul",		 	"qSay", 					"TEXT_RESTAURANT1_DAY3_9"	},
		{ "paul",			"qSetAppearance", 			"SURPRISED"					},
		{ "emily",		 	"qAnimateWait", 			"LAUGH", 3					},
		{ "paul",			"qSetAppearance", 			""							},
		{ "childGirl",		"qSetAppearance", 			""							},
		{ "paul",		 	"qWalkToXY", 				40, 25						}, -- snowball spot
		{ "paul",		 	"qAnimateWait", 			"TAUNT", 3					},
		{ "paul",		 	"qAnimate", 				"IDLE", 0					},
		{ "childBoy",		"qWalkToXY", 				24, 25						},
		{ "childGirl",		"qWalkToXY", 				23, 23						},
		{ "emily",		 	"qWalkToNode", 				grid:getCounterNode()		},
		{ "scene",			"qFinishMovie" 											},
		{ "scene",			"qStartGame" 											},
		{ "scene",			"qNotify",					"show bar"					},
		{ "",				"parallel"												},			
	}
	
  	event.sequenceThanks = 
  	{
  		{ "paul",		 	"setAppearance", 			"BLUSH"					},
  		{ "scene",			"qNotify",					"snow removed"			}
  	}
  	
  	event.sequenceDone = 
  	{
  		{ "scene",			"qStartMovie",				1						},
  		{ "", 				"sequential"										},
  		{ "childBoy",		"qAnimate", 				"IDLE", 0				},
  		{ "childGirl",		"qAnimate", 				"IDLE", 0				},
  		{ "emily",			"qSetAppearance", 			"FLIRT"					},
  		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY3_10"	},
  		{ "emily",		 	"qWalkToXY", 				29, 26					},
  		{ "emily",		 	"qSay", 					"RESTAURANT1_DAY3_11"	},
  		{ "emily",			"qSetAppearance", 			""						},
  		{ "", 				"parallel"											},
  		{ "childBoy",		"qSay", 					"RESTAURANT1_DAY3_12"	},
  		{ "childGirl",		"qSay", 					"RESTAURANT1_DAY3_12"	},
  		{ "", 				"sequential"										},
  		{ "childBoy",		"qSay", 					"RESTAURANT1_DAY3_13"	},
		{ "", 				"parallel"											},
		{ "childBoy",		"qWalkToNode", 				exitNode				},
		{ "childBoy",		"qDestroy"											},
		{ "childGirl",		"qWalkToNode", 				exitNode				},
		{ "childGirl",		"qDestroy"											},
		{ "", 				"sequential"										},
		{ "emily",		 	"qWalkToXY", 				35, 10					},
		{ "emily",			"qAnimateWait", 			"WORK_FRONT", 3			},
		{ "emily",		 	"qWalkToXY", 				37, 25					},
		{ "paul",			"qAnimate", 				"COLD_SHAKING", -1		},
		{ "paul",			"qSay", 					"RESTAURANT1_DAY3_14"	},
		{ "emily",			"qSetAppearance", 			"FLIRT"					},
		{ "emily",			"qSay", 					"RESTAURANT1_DAY3_15"	},
		{ "emily",			"qSetAppearance", 			""						},
		{ "paul",			"qAnimate", 				"IDLE", 0				},
		{ "emily",		 	"qWalkToNode", 				grid:getCounterNode()	},
		{ "paul",		 	"qWalkToNode", 				exitNode				},
		{ "paul",		 	"qDestroy"											},
		{ "scene",			"qFinishMovie" 										}
  	}
 
	-- play start sequence
	qSequence(sequenceStart)
    
end	

function day3:onLevelInited()
	
end

function day3:onNotify(notification)

	if (notification == "hit girl") then
		
		self.snowballHit:setVisible(true)
		
	elseif (notification == "snow gone") then
		
		self.snowballHit:setVisible(false)
		
	elseif (notification == "snow removed") then
		
		paul:animate("IDLE", 0)
		
	end
	
end

function day3:onDayBegin()

	self.timeBetweenThrowTimer = self:getTimeBetweenThrows()
	
end

function day3:onTick(time)

	-- This block checks if Paul should stop blushing
	if ((paul ~= nil) and (self.blushTimer > 0)) then
		self.blushTimer = self.blushTimer - time
		
		if (self.blushTimer <= 0) then
			self.blushTimer = 0
			self.paulBlushing = false
			paul:setAppearance("")
		end
	end
	
	if (event.completed == false) then
		
		-- This block checks if Paul should start blushing
		if (self.paulBlushing == false and paul:getAppearance() == "BLUSH") then
			-- Paul just started blushing: Set the timer:
			self.blushTimer = self.timeBlush
			self.paulBlushing = true
			
		end
		
		-- This block checks if we can throw a snowball again (Paul shoud not be hit or blushing)
		if ((self.timeBetweenThrowTimer > 0) and (self.paulBlushing == false) and (event.objectCurrentlyClean == true)) then
			self.timeBetweenThrowTimer = self.timeBetweenThrowTimer - time
			
			if (self.timeBetweenThrowTimer <= 0) then
				self.timeBetweenThrowTimer = self:getTimeBetweenThrows()
				self:throwSnowball()
			end
		end
		
		-- This block checks if snowball throw anim is finished (and we should show result)
		if (self.throwAnimTimer > 0) then
			self.throwAnimTimer = self.throwAnimTimer - time
			
			if (self.throwAnimTimer <= 0) then
				self.throwAnimTimer = 0
				
				cout("----> self.missCount: " .. self.missCount .. "\n")
				-- After two misses, make sure the snowball hits: (random result unwanted for tweaking purposes)
				if (self.missCount == 2) then
					-- HIT!
					event:reappear() -- Object to clean reappears.
					cout("HIT \n")
					self.missCount = 0
					
					-- start checking if Paul wants to clean himself:
					self.timeBeforeSelfCleanTimer = self.timeBeforeSelfClean
					paul:animate("TAUNT", -1)
					
					-- Hint about clicking the dirty Paul
					if (gPaulDirtyArrowShown ~= true) then
						event.objectToClean:createOverhead("INGAME_ARROW")
						gPaulDirtyArrowShown = true
					end
					
				else
					self.missPaul:setVisible(true)
					self.missPaul:qAnimateWait("OBJECT_SNOW_MISS_PAUL", 1, false, 12)
					self.missPaul:qSetVisible(false)
					self.missCount = self.missCount + 1
					
				end
				
			end
		end
		
		-- This block checks if Paul will clean himself up (player was too late)
		if ((self.timeBeforeSelfCleanTimer > 0) and (event.cleanMode == false)) then
			
			if (event.objectCurrentlyClean == true) then
				-- Clock is ticking and we're not in clean mode, but the player cleaned Paul allready.
				self.timeBeforeSelfCleanTimer = 0	-- No need to keep counting anymore.
			else
				self.timeBeforeSelfCleanTimer = self.timeBeforeSelfCleanTimer - time
				
				if (self.timeBeforeSelfCleanTimer <= 0) then
					self.timeBeforeSelfCleanTimer = 0
					
					-- play clean animation
					paul:qAnimateWait("WIPE_SNOWBALL", 2)
					paul:qAnimate("IDLE", 0)
					-- remove dirty object
					event:removeObjectWithoutScoring()
				end
			end
			
		end
		
	end
end

function day3:throwSnowball()
	
	if (self.childBoyThrows == true) then
		childBoy:animate("THROW_SNOWBALL_RIGHT", 1, self.framerateThrowSnowAnim)
		self.childBoyThrows = false
	else
		childGirl:animate("THROW_SNOWBALL_RIGHT", 1, self.framerateThrowSnowAnim)
		self.childBoyThrows = true
	end
	
	self.throwAnimTimer = self.timeThrowSnowAnim
	cout("----- self.throwAnimTimer  = " .. self.throwAnimTimer .. "\n")
	
end

-- Helpers:
function day3:getTimeBetweenThrows()

	return getRandomRange(self.timeBetweenThrowMin, self.timeBetweenThrowMax)

end

-- set day
day = day3()