include("scripts/events/hiddenpersonevent.lua")

-- set event
event = hiddenPersonEvent()

-- day class
class 'day2' (interface)

day2.chairNode = nil

function day2:__init() super()
end

function day2:onLevelGlobals()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false

	self.chairNode = grid:getNode(23, 12)
	
	entertainer:setAutoActivation(false)
	entertainer:setVisible(false)
	entertainer:setClickable(false)

	-- create francois:
    francois = pm:createPerson("francois")
    francois:setBaseName("INGAME_PERSON_FRANCOIS_WINTER")
    francois:setPosition(grid:getNode(21, 33))
    
    -- initialize emily:
    emily:setPosition(grid:getCounterNode())
    
    -- create santa
    santa = pm:createPerson("npc")
    santa:setBaseName("INGAME_PERSON_SANTA")
    santa:setDefaultSection("characters")
    santa:setPosition(grid:getNode(0, 16))
    
    event.timeUntilPopMin = 10000			-- minimum time the person waits before pop
	event.timeUntilPopMax = 12000			-- maximum time the person waits before pop
	event.timeLooking = 5000				-- time person is looking
	event.countItems = 6					-- total times we need to click the person
	event.baseName = "EVENT_ELF"			-- appearance of the hidden person
	event.section = "characters"			-- section for hidden person image
	event.scoreFoundOne	= 10				-- score for finding one item
	event.scoreFoundAll	= 50				-- bonus for finding all items
	
	event.sequenceDone = 
	{
		{ "scene",			"qStartMovie",				3						},
		{ "emily",			"qWalkToCounter"									},
		{ "scene",			"qNotify",					"elf entertainer"		},
		{ "entertainer",	"qSetVisible",				false					},
		{ "entertainer",	"qSetPosition",				grid:getNode(2, 22)		},
		{ "entertainer",	"qSay",						"RESTAURANT1_DAY2_17"	},
		{ "entertainer",	"qSetVisible",				true					},
		{ "entertainer",	"qSay",						"RESTAURANT1_DAY2_18"	},
		{ "emily",			"qSetAppearance",			"CONSTRAINED_LAUGH"		},
		{ "entertainer", 	"qWalkToXY",				7, 22					},
		{ "entertainer",	"qWalkToNode",				grid:getEntertainerNode()	},
		{ "emily",			"qSetAppearance",			""						},
		{ "entertainer",	"qSetClickable",			true					},		
		{ "scene",			"qFinishMovie" 										}
	}
	
	event.sequenceFail = 
	{
		{ "scene",			"qStartMovie",				3						},
		{ "emily",			"qWalkToXY",				10, 20					},
		{ "emily",			"qSetAppearance",			"FLIRT"					},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_20"	},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_21"	},
		{ "scene",			"qNotify",					"elf entertainer"		},
		{ "entertainer",	"qSetVisible",				false					},
		{ "entertainer",	"qSetPosition",				grid:getNode(2, 22)		},
		{ "entertainer",	"qSay",						"RESTAURANT1_DAY2_22"	},
		{ "emily",			"qSetAppearance",			"PLEASE"				},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_23"	},
		{ "emily",			"qSetAppearance",			""						},
		{ "entertainer",	"qSay",						"RESTAURANT1_DAY2_24"	},
		{ "entertainer",	"qSetVisible",				true					},
		{ "entertainer",	"qSay",						"RESTAURANT1_DAY2_18"	},
		{ "emily",			"qSetAppearance",			"CONSTRAINED_LAUGH"		},
		{ "entertainer", 	"qWalkToXY",				7, 22					},
		{ "entertainer",	"qWalkToNode",				grid:getEntertainerNode()	},
		{ "emily",			"qSetAppearance",			""						},
		{ "entertainer",	"qSetClickable",			true					},		
		{ "scene",			"qFinishMovie" 										}
	}

	local sequenceStart = 
	{
		{ "scene",			"qStartMovie",				2						},
		{ "santa",			"qWalkToXY",				29, 27					},
		{ "santa",			"qSay",						"RESTAURANT1_DAY2_0"	},
		{ "emily",			"qSetAppearance",			"CONFUSED"				},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_1"	},
		{ "emily",			"qSetAppearance",			""						},
		{ "santa",			"qSetAppearance",			"LAUGH"					},
		{ "santa",			"qSay",						"RESTAURANT1_DAY2_2"	},
		{ "santa",			"qSetAppearance",			""						},
		{ "santa",			"qSay",						"RESTAURANT1_DAY2_3"	},
		{ "emily",			"qSetAppearance",			"LAUGH"					},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_4"	},
		{ "emily",			"qSetAppearance",			""						},
		{ "santa",			"qSay",						"RESTAURANT1_DAY2_5"	},
		{ "santa",			"qSay",						"RESTAURANT1_DAY2_6"	},
		{ "santa",			"qSetAppearance",			"SAD"					},
		{ "santa",			"qSay",						"RESTAURANT1_DAY2_7"	},
		{ "emily",			"qSetAppearance",			"FLIRT"					},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_8"	},
		{ "santa",			"qSetAppearance",			""						},
		{ "emily",			"qSetAppearance",			""						},
		{ "francois",		"qSetAppearance",			"SURPRISED"				},
		{ "francois",		"qSay",						"RESTAURANT1_DAY2_9"	},
		{ "francois",		"qSetAppearance",			"REFUSE"				},
		
		{ "francois",		"qSetAppearance",			"THINK"					},
		{ "francois",		"qSay",						"RESTAURANT1_DAY2_91"	},
		{ "francois",		"qSetAppearance",			""						},
		{ "cleaner",		"qWalkToNode",				grid:getCleanerNode()	},
		{ "cleaner",		"qSay",						"RESTAURANT1_DAY2_92"	},
		{ "francois",		"qSetAppearance",			"ROLLEYES"				},
		{ "francois",		"qSay",						"RESTAURANT1_DAY2_93"	},
		{ "francois",		"qSetAppearance",			""						},
		{ "francois",		"qSay",						"RESTAURANT1_DAY2_10"	},
		{ "emily",			"qSetAppearance",			"PLEASE"				},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_11"	},
		{ "francois",		"qSetAppearance",			"BLUSH"					},
		{ "francois",		"qSay",						"RESTAURANT1_DAY2_12"	},
		{ "emily",			"qSetAppearance",			""						},
		{ "scene",			"qFadeToBlack"										},
		{ "francois",		"qSetAppearance",			""						},
		{ "santa",			"qSetPosition",				self.chairNode			},
		{ "santa",			"qAnimate",					"SIT_FRONT", 0			},
		{ "francois",		"qSetVisible",				false					},
		{ "scene",			"qFadeOutBlack"										},
		{ "francois",		"qSetPosition",				grid:getNode(2, 22)		},
		{ "francois",		"qSay",						"RESTAURANT1_DAY2_13"	},
		{ "emily",			"qSetAppearance",			"ROLL_EYES"				},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_14"	},
		{ "emily",			"qSay",						"RESTAURANT1_DAY2_15"	},
		{ "emily",			"qSetAppearance",			""						},
		{ "francois",		"qSay",						"RESTAURANT1_DAY2_16"	},
		{ "francois",		"qSetPosition",				exitNode				},
		{ "francois",		"qDestroy"											},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qStartGame" 										}
	}	

	-- play completed sequence
	qSequence(sequenceStart)
	
end


function day2:onLevelInited()
	entertainer:setVisible(false)
	entertainer:setClickable(false)
end

function day2:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_BULLY")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c
	end
end

function day2:onNotify(notification)

	if (notification == "elf entertainer") then
		
		entertainer:setAutoActivation(true)
	
	end

end

-- set day
day = day2()