include("scripts/events/snowstormevent.lua")

-- set event
event = snowStormEvent()

-- day class
class 'day1' (interface)

function day1:__init() super()
end

function day1:onLevelGlobals()
	
	autoStartGame = false
	autoAllPeopleWalkIn = false

	-- create francois:
    --francois = pm:createPerson("francois")
    cleaner:setPosition(grid:getNode(0, 16))
    
    -- initialize emily:
    emily:setPosition(grid:getNode(38, 0))
    emily:setAppearance("SQUINTED")

	local sequenceStart = 
	{
		{ "scene",			"qStartMovie",				2						},
		{ "cleaner",		"qWalkToXY",				11, 17					},
		{ "cleaner",		"qSay",						"RESTAURANT1_DAY1_0"	},
		{ "emily",			"qWalkToXY",				38, 17					},
		{ "emily",			"qSay",						"RESTAURANT1_DAY1_1"	},
		{ "cleaner",		"qWalkToXY",				22, 24					},
		{ "cleaner",		"qSay",						"RESTAURANT1_DAY1_2"	},
		{ "emily",			"qWalkToXY",				28, 25					},
		{ "emily",			"qSay",						"RESTAURANT1_DAY1_3"	},
		{ "emily",			"qSay",						"RESTAURANT1_DAY1_4"	},
		{ "cleaner",		"qSay",						"RESTAURANT1_DAY1_5"	},
		{ "emily",			"qSay",						"RESTAURANT1_DAY1_6"	},
		{ "cleaner",		"qSay",						"RESTAURANT1_DAY1_7"	},
		{ "cleaner",		"qWalkToXY",				23, 21					},
		{ "cleaner",		"qSay",						"RESTAURANT1_DAY1_8"	},
		{ "emily",			"qSay",						"RESTAURANT1_DAY1_9"	},
		{ "", 				"parallel"											},
		{ "cleaner",		"qWalkToNode",				grid:getCleanerNode()	},
		{ "emily",			"qWalkToCounter"									},
		{ "", 				"sequential"										},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qStartGame" 										}
	}	

	self.sequenceEnd = 
	{
		{ "scene",			"qStartMovie",				1						},
		{ "elvis",			"qSetAppearance",			"HAPPY"					},
		{ "elvis",			"qWalkToXY",				22, 24					},
		{ "emily",			"qWalkToXY",				28, 25					},
		{ "elvis",			"qSay",						"RESTAURANT1_DAY1_10"	},		
		{ "emily",			"qSetAppearance",			"NEUTRAL"				},
		{ "emily",			"qSay",						"RESTAURANT1_DAY1_11"	},
		{ "elvis",			"qSetAppearance",			"SAD"					},
		{ "elvis",			"qSay",						"RESTAURANT1_DAY1_12"	},
		{ "elvis",			"qWalkToXY",				5, 16					},
		{ "elvis",			"qSay",						"RESTAURANT1_DAY1_13"	},
		{ "elvis",			"qSay",						"RESTAURANT1_DAY1_14"	},
		{ "elvis",			"qWalkToXY",				0, 16					},
		{ "elvis",			"qSetVisible",				false					},
		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										}
	}	

	-- play completed sequence
	qSequence(sequenceStart)
	
end

function day1:onLevelInited()

end

function day1:onDayEnd()

	autoAllPeopleWalkOut = false

    elvis = pm:createPerson("npc")
    elvis:setBaseName("INGAME_PERSON_ELVIS")
    elvis:setDefaultSection("characters")
    elvis:setPosition(grid:getNode(0, 16))
	qSequence(self.sequenceEnd)
end


function day1:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS_WINTER")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c:setAppearance("REFUSE")
		c.clean = true
		return c	
	end
end

-- set day
day = day1()