include("scripts/events/brokenobjectstagesevent.lua")

-- set event
event = brokenObjectStagesEvent()
event.targetId = "rest1_event_snowman"
event.targetGridX = -1
event.targetGridY = -1
event.targetWorkX = 45
event.targetWorkY = 12

-- day class
class 'day0' (interface)

day0.originalSnowman = nil
day0.basicSnowman = nil

function day0:__init() super()
end

function day0:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- set initial positions
--	cleaner:setPosition(cleaner:getHomeNode())
	
	self.originalSnowman = nil
	
	self.basicSnowman = createSprite()
	self.basicSnowman:setDefaultSection(player:getCurrentResourceSection())
	self.basicSnowman:animate("DECO_SNOWMAN_BASIC", 0)
	self.basicSnowman:setAlpha(0)
	self.basicSnowman:setX(744)
	self.basicSnowman:setY(156)
	level:getLayer(LAYER_GRID_ELEMENTS):addChild(self.basicSnowman)
	
	-- create francois
    francois = pm:createPerson("francois")
    francois:setBaseName("INGAME_PERSON_FRANCOIS_WINTER")
    francois:setPosition(grid:getNode(0, 16))
    
    emily:setPosition(grid:getNode(0, 13))
    
    -- create boy
    boy = pm:createPerson("npc")
    boy:setBaseName("INGAME_CUSTOMER_MALE_WINTER_CHILD")
    boy:setDefaultSection("customers")
    boy:setPosition(grid:getNode(41, 0))
		
	event.brokenObject.readyAppearance = "DECO_SNOWMAN"
	event.brokenObject.readyTime = 1000
	event.brokenObject:setCurrentFrame(0)
	event.replaceWhenReady = false
	
	-- set event configuration
	event.animFix = "FIX"
	event.soundFix = "SOUND_BUILD_SNOWMAN"
	event.sequenceStart = nil
	event.timeUntilFixed = 1000 * 27
	event.score = 300
	event.overheadY = 20
	event.pbY = -97
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie",				3							},
		{ "", 				"parallel"												},
		{ "francois",		"qSetAppearance",			"THINK"						},
		{ "francois",		"qWalkToXY",				5, 16						},
		{ "emily",			"qWalkToXY",				11, 14						},
		{ "", 				"sequential"											},
		{ "", 				"parallel"												},
		{ "boy",			"qWalkToXY",				45, 5						},
		{ "francois",		"qSay",						"TEXT_RESTAURANT1_DAY0_0"	},
		{ "", 				"sequential"											},
		{ "francois",		"qSetAppearance",			""							},
		{ "emily",			"qSetAppearance",			"OFFENDED"					},
		{ "emily",			"qSay",						"TEXT_RESTAURANT1_DAY0_1"	},
		{ "emily",			"qSetAppearance",			""							},
		{ "", 				"parallel"												},
		{ "boy",			"qWalkToXY",				44, 8						},
		{ "francois",		"qSetAppearance",			"HAPPY"						},
		{ "francois",		"qSay",						"TEXT_RESTAURANT1_DAY0_2"	},
		{ "", 				"sequential"											},
		{ "francois",		"qSetAppearance",			""							},
		{ "francois",		"qSay",						"TEXT_RESTAURANT1_DAY0_3"	},
		{ "", 				"parallel"												},
		{ "boy",			"qWalkToXY",				34, 15						},
		{ "francois",		"qSay",						"TEXT_RESTAURANT1_DAY0_4"	},
		{ "", 				"sequential"											},
		{ "emily",			"qSetAppearance",			"NEUTRAL"					},
		{ "emily",			"qSay",						"TEXT_RESTAURANT1_DAY0_5"	},
		{ "francois",		"qAnimateWait",				"LAUGH", 3					},
		{ "francois",		"qSay",						"TEXT_RESTAURANT1_DAY0_6"	},
		{ "emily",			"qSetAppearance",			""							},
		{ "francois",		"qAnimate",					"IDLE", 0					},
		{ "boy",			"qWalkToXY",				15, 16						},
		{ "boy",			"qSay",						"TEXT_RESTAURANT1_DAY0_7"	},
		{ "boy",			"qSay",						"TEXT_RESTAURANT1_DAY0_8"	},
		{ "emily",			"qSetAppearance",			"CONFUSED"					},
		{ "emily",			"qSay",						"TEXT_RESTAURANT1_DAY0_9"	},
		{ "boy",			"qSay",						"TEXT_RESTAURANT1_DAY0_8"	},
		{ "emily",			"qSetAppearance",			"CURIOUS"					},
		{ "emily",			"qSay",						"TEXT_RESTAURANT1_DAY0_10"	},
		{ "emily",			"qSetAppearance",			""							},
		{ "", 				"parallel"												},
		{ "boy",			"qWalkToXY",				42, 8						},
		{ "francois",		"qWalkToXY",				0, 16						},
		{ "francois",		"qSetVisible",				false						},
		{ "", 				"sequential"											},
		{ "francois", 		"qDestroy"												},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene", 			"qStartGame" 											},
		{ "brokenObject",	"qCreateScreenOverhead",	"INGAME_ARROW"				},
		{ "",				"parallel"											},					
	}	

	event.sequenceWin =
	{
		{ "scene",			"qStartMovie",				3							},
		{ "basicSnowman",	"setAlpha",					1							},
		{ "brokenObject",	"setAlpha",					0							},
		{ "emily",			"qWalkToXY",				44, 11						},
		{ "emily",			"qSay",						"TEXT_RESTAURANT1_DAY0_11"	},
		{ "scene", 			"qNotify", 					"add carrot"				},
		{ "emily",			"qWalkToXY",				42, 12						},
		{ "emily",			"qSay",						"TEXT_RESTAURANT1_DAY0_12"	},
		{ "boy",			"qWalkToXY",				46, 10						},
		{ "boy",			"qAnimateWait",				"JUMP_JOY", 1				},
		{ "boy",			"qAnimate",					"IDLE", 0					},
		{ "boy",			"qSay",						"TEXT_RESTAURANT1_DAY0_13"	},
		{ "boy",			"qSay",						"TEXT_RESTAURANT1_DAY0_14"	},
		{ "boy",			"qWalkToXY",				38, 0						},
		{ "boy", 			"qDestroy"												},
		{ "scene",			"qFinishMovie" 											}
	}
	
end

function day0:onLevelInited()
	self.originalSnowman = getObject("rest1_snowman")
	self.originalSnowman:setVisible(false)
	
	self.basicSnowman:setAnchorBotY(31)
	cout("Snowman anchorboty: " .. self.basicSnowman:getAnchorBotY())
	self.basicSnowman:reposition(self.basicSnowman:getScreenX(), self.basicSnowman:getScreenY())
	
end

function day0:onNotify(notification)
	if (notification == "add carrot") then
		self.basicSnowman:animate("DECO_SNOWMAN", 0)
	end

end

function day0:onDayEnd()
	if (event.completed == false) then
		-- prevent walking out
		autoAllPeopleWalkOut = false
		
		local sequenceCompleted = 
		{
			{ "scene",			"qStartMovie",				2							},
			{ "", 				"parallel"												},
			{ "boy",			"qWalkToXY",				44, 14						},
			{ "emily",			"qWalkToXY",				38, 15						},
			{ "", 				"sequential"											},
			{ "emily",			"qSay",						"TEXT_RESTAURANT1_DAY0_15"	},
			{ "boy",			"qSay",						"TEXT_RESTAURANT1_DAY0_16"	},
			{ "boy",			"qWalkToNode",				"exitNode"					},
			{ "emily",			"qWalkToNode",				"exitNode"					},
			{ "scene",			"qFinishMovie" 											},
			{ "scene",			"qFinishGame" 											}
		}	
			
		-- play completed sequence
		qSequence(sequenceCompleted)
	end

end


-- set day
day = day0()