include("scripts/appliances/pearappliance.lua")
include("scripts/appliances/chestnutgrill.lua")

include("scripts/products/regularproduct.lua")
include("scripts/products/chestnutproduct.lua")
include("scripts/products/pearProduct.lua")

include("scripts/persons/wanderer.lua")
include("scripts/persons/santaChild.lua")

-- global variables and behavior we might need in a specific restaurant

-- entry node
entryX = 0
entryY = 16
entryNode = nil

-- exit node
exitX = 49
exitY = 16
exitNode =  nil

-- movie node
movieX = 32
movieY = 0
movieNode = nil

-- restaurant class
class 'restaurant1' (interface)

-- For our dear leveldesigner:
restaurant1.timeUntilNextChildMin = 40000		-- MIN Time between prev child left scene and new child enters
restaurant1.timeUntilNextChildMax = 50000		-- MAX Time between prev child left scene and new child enters

restaurant1.timeUntilFirstWandererMin = 5000	-- MIN time it takes for the first wanderer(s) to arrive
restaurant1.timeUntilFirstWandererMax = 10000	-- MAX time it takes for the first wanderer(s) to arrive
restaurant1.timeUntilCheckWanderersMin = 15000	-- Lower value means more wanderers (dont make this higher than the MAX value)
restaurant1.timeUntilCheckWanderersMax = 30000	-- Lower value means more wanderers (dont make this lower than the MIN value)


-- Don't touch the stuff below unless you know what you are doing:
restaurant1.snowFine = nil
restaurant1.snowNormal = nil

restaurant1.wandererTimer = 0
restaurant1.santaPresent = false
restaurant1.santaIsAvailable = false

restaurant1.nextChildTimer = 0
restaurant1.chairNode = nil
restaurant1.santaNodeX = 23
restaurant1.santaNodeY = 12

restaurant1.wandererInfo =	{	{"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",		"SOUND_SINGING_CHILD_LOOP"},
								{"INGAME_CUSTOMER_MALE_WINTER_CHILD",		"SOUND_SINGING_CHILD_LOOP"},
								{"INGAME_CUSTOMER_FEMALE_WINTER_REGULAR",	"SOUND_SINGING_FEMALE_LOOP"},
								{"INGAME_CUSTOMER_MALE_WINTER_REGULAR",		"SOUND_SINGING_MALE_LOOP"},
							}

restaurant1.santaChildInfo ={	{"INGAME_CUSTOMER_FEMALE_WINTER_CHILD"},
								{"INGAME_CUSTOMER_MALE_WINTER_CHILD"},
							}

function restaurant1:__init() super()
end

function restaurant1:onLevelGlobals()
	
	if (entertainer ~= nil) then
		if (player:getCurrentDayIndex() == 9) then -- hack to make sure we see Francois from the back
			entertainer:setAppearance("BACK_ELF")
		else
			entertainer:setAppearance("ELF")
		end
	end
	
	local table = nil
	for tableIdx = 1, 2 do
		table = om:getTable(tableIdx)
		if (table ~= nil) then
			table:setOverheadY( table:getOverheadY() - 85 )
			
		end

	end
	
	self.chairNode = grid:getNode(self.santaNodeX, self.santaNodeY)

end

function restaurant1:onLevelInited()
	
	local dayIndex = player:getCurrentDayIndex()
	
	if (dayIndex ~= 1) then
		self.snowFine = level:getLayer(3):addParticleEffectAfter("PARTICLE_SNOW_FINE") 
		self.snowFine:play()
		self.snowFine:addInitialTime(15000)
		
		self.snowNormal = level:getLayer(3):addParticleEffectAfter("PARTICLE_SNOW_NORMAL") 
		self.snowNormal:play()
		self.snowNormal:addInitialTime(15000)
	end
	
	if ((dayIndex > 2) and (dayIndex ~= 9) and (dayIndex ~= 6)) then
		-- create santa
	    santa = pm:createPerson("npc")
	    santa:setBaseName("INGAME_PERSON_SANTA")
	    santa:setDefaultSection("characters")
	    santa:setPosition(grid:getNode(0, 16))
	end
	
	if ((dayIndex > 2) and (dayIndex ~= 9)) then

	    self.santaPresent = true
	    self.santaIsAvailable = true
	    
	else
	    self.santaPresent = false
	    self.santaIsAvailable = false
	end
	
	om:getCounter():setYPos(-63)

	local chestnutApp = getAppliance("rest1_chestnut_grill")
	if (chestnutApp ~= nil) then
		chestnutApp:setupPlates()
	end
	
	self.wandererTimer = getRandomRange(self.timeUntilFirstWandererMin, self.timeUntilFirstWandererMax)
end

function restaurant1:onDayBegin()

	local dayIndex = player:getCurrentDayIndex()
	
	if ((dayIndex > 2) and (dayIndex ~= 9) and (dayIndex ~= 6)) then
		santa:qWalkToNode(grid:getNode(23, 12))
		santa:qAnimate("SIT_FRONT", 0)
	end
	
	if (self.santaPresent) then
		self.nextChildTimer = getRandomRange(self.timeUntilNextChildMin, self.timeUntilNextChildMax)
	else
		self.nextChildTimer = 0
	end

end

function restaurant1:createPerson(class)

	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_BULLY")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c

	elseif (class == "chicken") then
		c = chickenPerson("INGAME_PERSON_CHICKEN")
		c:setType("chicken")
		c:animate("IDLE", 0)
		return c
					
	elseif (class == "charles") then
		c = npc("INGAME_PERSON_CHARLES")
		c:setType("charles")
		c:animate("IDLE", 0)
		c:setButtX(20)
		return c
		
	elseif (class == "wanderer") then
		local random = getRandom(table.getn(self.wandererInfo)) + 1
		c = wanderer(self.wandererInfo[random][1])
		c.singSound = self.wandererInfo[random][2]
		c:setType(class)
		c:animate("IDLE", 0)
		return c
	
	elseif (class == "santaChild") then
		local random = getRandom(table.getn(self.santaChildInfo)) + 1
		c = santaChild(self.santaChildInfo[random][1])
		c:setType(class)
		c:animate("IDLE", 0)
		return c
	
	end
	
	return nil

end

function restaurant1:createProduct(base)

	bubblePretzelX = 73
	bubblePretzelY = 132
	bubblePretzelS = true
	
	bubbleCandleX = 347
	bubbleCandleY = 427
	bubbleCandleS = true
	
	if (type(base) == "string")	then
	

		if (base == "CARROT") then
			p = regularProduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_BROCOLLI")
			p:setWorkOffsetX(-4)
			return p
			
		elseif (base == "FIG") then
			p = regularProduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_BROCOLLI")
			p:setWorkOffsetX(-2)
			return p
			
		elseif (base == "PUMPKIN") then
			p = regularProduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_BROCOLLI")
			p:setWorkOffsetX(1)
			return p
			
		elseif (base == "BERRIES") then
			p = regularProduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GRAB_BROCOLLI")
			p:setWorkOffsetX(3)
			return p
			
		elseif (base == "POSTCARD_1") then
			p = regularProduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_PICKUP_POST_CARD")
			return p
			
		elseif (base == "POSTCARD_2") then
			p = regularProduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_PICKUP_POST_CARD")
			return p
			
		elseif (base == "SOUP_ONION") then
			p = pearProduct(base)
			p.applianceName = "rest1_onion_soup"
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GET_SOUP")
			return p
			
		elseif (base == "SOUP_VEGGY") then
			p = pearProduct(base)
			p.applianceName = "rest1_veg_soup"
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GET_SOUP")
			return p
			
		elseif (base == "PRETZEL") then
			p = regularProduct(base)
			p:setBubbleX(bubblePretzelX)
			p:setBubbleY(bubblePretzelY)
			p:setBubbleSmall(bubblePretzelS)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_GETCOOKIE")
			return p
	
		elseif (base == "MUSTARD") then
			p = regularProduct(base)
			p:setBubbleX(bubblePretzelX)
			p:setBubbleY(bubblePretzelY)
			p:setBubbleSmall(bubblePretzelS)
			p:setWorkOffsetX(1)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_SQUIRT_SAUCE_ON_RIBS")
			return p

		elseif (base == "CHOCO") then
			p = regularProduct(base)
			p:setBubbleX(bubblePretzelX)
			p:setBubbleY(bubblePretzelY)
			p:setBubbleSmall(bubblePretzelS)
			p:setWorkOffsetX(2)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_SQUIRT_SAUCE_ON_RIBS")
			return p
			
		elseif (base == "WAX_GREEN") then
			p = regularProduct(base)
			p:setBubbleX(bubbleCandleX)
			p:setBubbleY(bubbleCandleY)
			p:setBubbleSmall(bubbleCandleS)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_CREATE_CANDLE")
			return p

		elseif (base == "WAX_RED") then
			p = regularProduct(base)
			p:setBubbleX(bubbleCandleX)
			p:setBubbleY(bubbleCandleY)
			p:setBubbleSmall(bubbleCandleS)
			p:setWorkOffsetX(-2)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_CREATE_CANDLE")
			return p
		
		elseif (base == "WAX_WHITE") then
			p = regularProduct(base)
			p:setBubbleX(bubbleCandleX)
			p:setBubbleY(bubbleCandleY)
			p:setBubbleSmall(bubbleCandleS)
			p:setWorkOffsetX(2)
			p:setWorkTime(0)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_CREATE_CANDLE")
			return p
			
		elseif (base == "ROPE") then
			p = regularProduct(base)
			p:setBubbleX(bubbleCandleX)
			p:setBubbleY(bubbleCandleY)
			p:setBubbleSmall(bubbleCandleS)
			p:setWorkOffsetX(4)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_CREATE_CANDLE")
			return p
		
		elseif (base == "CHESTNUT") then
			p = chestnutProduct(base)
			p.appliance = "rest1_chestnut_grill"
			p:setWorkTime(500)  
			p:setWorkSound("SOUND_PICKUP_CHESTNUT")
			p:setWorkAnimation("WORK_BACK")
			return p
			
		elseif (base == "STOCKED_CHESTNUT") then
			p = regularProduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK")
			p:setWorkSound("SOUND_PICKUP_CHESTNUT")
			p:setStock(2)
			p:setMaxStock(8)
			return p
			
		end
		
	elseif (type(base) == "userdata") then
		--
		-- attempting to create a copy!
		if (base:getBase() == "CHESTNUT") then
			p = chestnutProduct(base)
			p.appliance = "rest1_chestnut_grill"
			return p
		end

	end
		
	return nil
	
end

function restaurant1:createObject(desc)

	if (desc:getObjectId() == "rest1_onion_soup") then
		result = pearappliance()
		result:setType(desc:getType())
		result.productName = "SOUP_ONION"
		result.stirAnim = "ANIM_ONIONSOUP_STIR_SPOON"
		result.spillAnim = "ANIM_ONIONSOUP_OVERCOOK"
		result.hintID = "HINT_STIR_SOUP"
		result.workAnim = "WORK_FRONT"
		result.overheadAnimation = "INGAME_ONION_SOUP_STIR"
		result.toSturDuration = 85000
		result.sturDuration = 2000
		result.cleanDuration = 8000
		result.dirtyTimer = result.toSturDuration
		return result
		
	elseif (desc:getObjectId() == "rest1_veg_soup") then
		result = pearappliance()
		result:setType(desc:getType())
		result.productName = "SOUP_VEGGY"
		result.stirAnim = "ANIM_VEGGYSOUP_STIR_SPOON"
		result.spillAnim = "ANIM_VEGGYSOUP_OVERCOOK"
		result.hintID = "HINT_STIR_SOUP"
		result.workAnim = "WORK_FRONT"
		result.overheadAnimation = "INGAME_VEGGY_SOUP_STIR"
		result.toSturDuration = 90000
		result.sturDuration = 2000
		result.cleanDuration = 8000
		result.dirtyTimer = result.toSturDuration
		return result
		
	elseif (desc:getObjectId() == "rest1_chestnut_grill") then
		result = chestnutGrill()
		result:setType(desc:getType())
		result:setupPlates()
		return result
	elseif (desc:getObjectId() == "rest1_package") then
		result = trophyPackage()
		result:setType(desc:getType())
		return result
		
	end
	return nil
	
end


function restaurant1:onTick(time)

	if (scene:isClosed()) then
		return
		
	end
	
	if (scene:isPlayingMovie() or scene:isStartingMovie()) then
		return
	end
	
	if (self.wandererTimer > 0) then
		self.wandererTimer = self.wandererTimer - time
		if (self.wandererTimer <= 0) then
			if (wandererPersonsCount < 3) then
				pm:createPerson("wanderer")
				
			end
			
			self.wandererTimer = getRandomRange(self.timeUntilCheckWanderersMin, self.timeUntilCheckWanderersMax)
		end
	end
	
	if ((self.santaPresent) and (self.nextChildTimer > 0) and (santaChildPersonsCount == 0)) then
		
		self.nextChildTimer = self.nextChildTimer - time
		
		if (self.nextChildTimer <= 0) then
			self.nextChildTimer = getRandomRange(self.timeUntilNextChildMin, self.timeUntilNextChildMax)
			
			if (self.santaIsAvailable) then
				-- Santa is available, lets add a new child:
				pm:createPerson("santaChild")
				
			end
			
		end
			
	end
	
end
-- set restaurant
restaurant = restaurant1()

class 'trophyPackage' (D2Object)

-- internal variables
-- don't change unless you know what you're doing

function trophyPackage:__init() super()
end

function trophyPackage:onCreate()
	self:setDefaultSection(player:getCurrentResourceSection())
	self:animate(self:getBaseName(), 0)
	self:createHighlight()
end

function trophyPackage:onClick()
	self:animate("ANIM_TROPHY_PACKAGE", 1, false, 15, true)
	self:removeHighlight()
	tm:checkSantasSecret()
end
