include("scripts/events/attentionevent.lua")

-- set event
event = attentionEvent()

-- day class
class 'day9' (interface)

function day9:__init() super()
end

function day9:onLevelGlobals()
	autoStartGame = false
	autoAllPeopleWalkIn = false

	francois = pm:createPerson("npc")
    francois:setBaseName("INGAME_PERSON_FRANCOIS")
    francois:setDefaultSection("characters")
    francois:setPosition(grid:getNode(0, 0))

    emily:setPosition(grid:getCounterNode())
   	table2 = om:getTable(2)
   	table2:setReserved(true)

	event.baseName1 = "INGAME_PERSON_RICHARD"	-- appearance of the attentionPerson
	event.baseName2 = "INGAME_PERSON_PAUL"
	event.timeUntilEnterMin = 20000			-- minimum time the attentionPerson waits outside
	event.timeUntilEnterMax = 60000			-- maximum time the attentionPerson waits outside
	event.p1barEmptyDuration = 75000
	event.p2barEmptyDuration = 25000
	event.scoreGotOne = 50					-- score for finding one item
	event.scoreGotAll = 150					-- bonus for finding all items
	event.p1WorkX = 6
	event.p1WorkY = 27
	event.p2WorkX = 14
	event.p2WorkY = 12	
	event.p2TalkX = 11
	event.p2TalkY = 12	
	event.p1PBY = 45
	event.p2PBY = 12
	event.p1Appearance = "SMUG"
	event.p2Appearance = "HAPPY"	
	event.p1WalkAwayPerson = false
	event.p2WalkAwayPerson = true	
	event.p1TextLines = 
	{
	    "TEXT_RESTAURANT0_DAY9_12",
	    "TEXT_RESTAURANT0_DAY9_13",
	    "TEXT_RESTAURANT0_DAY9_14",
	    "TEXT_RESTAURANT0_DAY9_15",
	    "TEXT_RESTAURANT0_DAY9_16",
	    "TEXT_RESTAURANT0_DAY9_17",
	    "TEXT_RESTAURANT0_DAY9_18",
	    "TEXT_RESTAURANT0_DAY9_19",
	    "TEXT_RESTAURANT0_DAY9_20",
	    "TEXT_RESTAURANT0_DAY9_21",
	}
	event.p2TextLines = 
	{
	    "TEXT_RESTAURANT0_DAY9_22",
	    "TEXT_RESTAURANT0_DAY9_23",
	    "TEXT_RESTAURANT0_DAY9_24",
	    "TEXT_RESTAURANT0_DAY9_25",
	    "TEXT_RESTAURANT0_DAY9_26",
	    "TEXT_RESTAURANT0_DAY9_27",
	    "TEXT_RESTAURANT0_DAY9_28",
	    "TEXT_RESTAURANT0_DAY9_29",
	    "TEXT_RESTAURANT0_DAY9_30",
	}
	event.sequenceDayStart = 
	{
		{ "scene",		"qStartMovie",		2								},
		{ "francois",	"qWalkToXY",		25, 23							},
		{ "person1",	"qWalkToXY",		16, 15		                    },
		{ "person1",	"qSetAppearance",	"HAPPY"		                    },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_0"       },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_1"       },
		{ "emily",		"qSetAppearance",	"HAPPY"		                    },
		{ "francois",	"qSetAppearance",	"HAPPY"		                    },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_2"       },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_3"       },
		{ "francois",	"qSay",				"TEXT_RESTAURANT0_DAY9_4"       },
		{ "francois",	"qSay",				"TEXT_RESTAURANT0_DAY9_5"       },
		{ "person1",	"qSetAppearance",	"SMUG"		                    },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_6"       },
		{ "person1",	"qSetAppearance",	""								},
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_7"       },
		{ "person1",	"qSitAt",			table2, 1				        },
		{ "francois",	"qSitAt",			table2, 0				        },
		{ "person1",	"qSetAppearance",	"SMUG"		                    },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_8"       },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_9"       },
		{ "emily",		"qSetAppearance",	"THINKING"	                    },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_10"      },
		{ "emily",		"qSetAppearance",	""					            },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_11"      },
		{ "person1",	"qSetAppearance",	""								},
		{ "scene", 		"qFinishMovie" 										},
		{ "person2",	"qWalkToXY",		event.p2TalkX, event.p2TalkY    },
		{ "person1",	"qCallback",		event, function(e) e.person1:setActive(true) end },
		{ "person2",	"qCallback",		event, function(e) e.person2:setActive(true) end },
		{ "scene", 		"qStartGame" 										},				
		{ "",			"parallel"											},			
	}
	event.sequenceDayEnd = 
	{
		{ "scene",		"qStartMovie",		3								},
		{ "person1",	"qSetAppearance",	""								},
		{ "person2",	"qSetAppearance",	""								},
		{ "emily",		"qSetAppearance",	""					            },
		{ "francois",	"qSetAppearance",	""					            },
		{ "francois",	"qWalkToXY",		33, 0		                    },
		{ "francois",	"qSetVisible",		false							},
		
		{ "person1",	"qWalkToXY",		18, 15		                    },
		{ "person2",	"qSetVisible",		true		                    },
		{ "person2",	"qWalkToXY",		15, 15		                    },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_31"      },
		{ "emily",		"qWalkToXY",		3, 1		                    },
		{ "person1",	"qSetAppearance",	""								},
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_32"      },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_33"      },

		{ "person2",	"qSetAppearance",	"ANGRY"							},
		{ "person2",	"qSay",				"TEXT_RESTAURANT0_DAY9_34"      },
		
		{ "person1",	"qSetAppearance",	"SURPRISED"						},
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_35"      },
		{ "person1",	"qSetAppearance",	""								},
		{ "person2",	"qSay",				"TEXT_RESTAURANT0_DAY9_36"      },
		{ "person1",	"qSetAppearance",	"SMUG"							},
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_37"      },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_38"      },
		{ "person2",	"qSay",				"TEXT_RESTAURANT0_DAY9_39"      },
		{ "person2",	"qSetAppearance",	"ROLLEYES"	                    },
		{ "person2",	"qSay",				"TEXT_RESTAURANT0_DAY9_40"      },
		{ "person1",	"qSetAppearance",	"ROLLEYES"	                    },
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_41"      },
		
		{ "emily",		"qWalkToXY",		12, 15		                    },
		{ "person2",	"qSetAppearance",	"SURPRISED"						},
		{ "person1",	"qSetAppearance",	"SORRY"							},
		{ "emily",		"qSetAppearance",	"OFFENDED"			            },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_42"      },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_43"      },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_44"      },
		
		{ "person1",	"qSetAppearance",	"SMUG"							},
		{ "person1",	"qSay",				"TEXT_RESTAURANT0_DAY9_45"      },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_46"      },
		{ "emily",		"qSetAppearance",	""								},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_47"      },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_48"      },
		{ "emily",		"qSetAppearance",	"OFFENDED"			            },
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY9_49"      },
		{ "emily",		"qWalkToXY",		0, 0		                    },
		{ "scene", 		"qFinishMovie" 										},
		{ "scene",		"qFinishGame" 										},				
	}
end

function day9:onDayBegin()
	local p = event.person1
	hm:openHint(getHintIndex("HINT_ATTENTION"), p:getTable():getScreenX(), p:getScreenY() - (p:getHeight() / 2))
end

function day9:onLevelInited()
end

function day9:onDayEnd()
	autoAllPeopleWalkOut = false
end

function day9:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_FRANCOIS")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day9()