-- day class
class 'day8' (interface)

day8.sequenceStart = nil
day8.danceMoves =
{
	{1},
	{2},
	{3},
	{4},
}
day8.dancerLostPositions = 
{
	{x=18, y=15},
	{x=15, y=15},
	{x=12, y=15},
}
day8.dancerLostIdx = 0

day8.danceSteps = nil
day8.scoreGotOne = 25
day8.scoreGotAll = 100

day8.timer = 0
day8.indexDance = 0
day8.indexMove = 0
day8.clicked = {}
day8.right = 0
day8.dancers = {}
day8.emilyOut = false
day8.wrongIdx = 0
day8.choicesButtonSound = nil
day8.choicesDanceSound = nil

function day8:__init() super()

	local choices =
	{
		"STEP",
		"TWIRL",
		"DIP",
	}
	self.choicesButtonSound =
	{
		["STEP"] = "SOUND_DANCE_BUTTON_1",
		["TWIRL"] = "SOUND_DANCE_BUTTON_2",
		["DIP"] = "SOUND_DANCE_BUTTON_3",
	}	
	self.choicesDanceSound =
	{
		["STEP"] = "SOUND_DANCE_STEP_1",
		["TWIRL"] = "SOUND_DANCE_STEP_2",
		["DIP"] = "SOUND_DANCE_STEP_3",
	}	
		
	local choicesCount =
	{
		0,
		0,
		0,
	}
	local picked =
	{
	}
	
	for i = 1,6 do
		local random = getRandom(table.getn(choicesCount)) + 1
		while (choicesCount[random] >= 3) do
			random = getRandom(table.getn(choicesCount)) + 1			
		end
		
		table.insert(picked, choices[random])	
		choicesCount[random] = choicesCount[random] + 1
		-- cout(choices[random] .. "\n")
	end
	
	self.danceSteps =
	{
		{ picked[1], picked[2], picked[3] },
		{ picked[2], picked[6], picked[5], picked[1] },
		{ picked[6], picked[1], picked[2], picked[5], picked[4] },
		{ picked[4], picked[3], picked[6], picked[1], picked[2], picked[5] },
	}

end

function day8:onLevelGlobals()

	if (self.danceSteps == nil) then
		return
		
	end

	autoStartGame = false
	autoAllPeopleWalkIn = false

	emily:setPosition(grid:getCounterNode())
	cleaner:setPosition(cleaner:getHomeNode())
	
	richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setDefaultSection("characters")
    richard:setPosition(grid:getNode(0, 0))

	angela = pm:createPerson("npc")
    angela:setBaseName("INGAME_PERSON_ANGELA")
    angela:setDefaultSection("characters")
    angela:setPosition(grid:getNode(0, 0))
    angela:setVisible(false)

	edward = pm:createPerson("npc")
    edward:setBaseName("INGAME_PERSON_EDWARD")
    edward:setDefaultSection("characters")
    edward:setPosition(grid:getNode(0, 0))
    edward:setVisible(false)

	francois = pm:createPerson("npc")
    francois:setBaseName("INGAME_PERSON_FRANCOIS")
    francois:setDefaultSection("characters")
    francois:setPosition(grid:getNode(0, 0))
    francois:setVisible(false)

	p1 = pm:createPerson("npc")
    p1:setBaseName("INGAME_PERSON_ELVIS")
    p1:setDefaultSection("characters")
    p1:setPosition(grid:getNode(49, 3))
    p1:setVisible(false)

	p2 = pm:createPerson("npc")
    p2:setBaseName("INGAME_PERSON_BETTY")
    p2:setDefaultSection("characters")
    p2:setPosition(grid:getNode(49, 3))
    p2:setVisible(false)

	p3 = pm:createPerson("npc")
    p3:setBaseName("INGAME_PERSON_CHARLES")
    p3:setDefaultSection("characters")
    p3:setPosition(grid:getNode(49, 3))
    p3:setVisible(false)

	p4 = pm:createPerson("npc")
    p4:setBaseName("INGAME_PERSON_ANTONIO")
    p4:setDefaultSection("characters")
    p4:setPosition(grid:getNode(49, 3))
    p4:setVisible(false)

	p5 = pm:createPerson("npc")
    p5:setBaseName("INGAME_PERSON_EVELYN")
    p5:setDefaultSection("characters")
    p5:setPosition(grid:getNode(49, 3))
    p5:setVisible(false)

	p6 = pm:createPerson("npc")
    p6:setBaseName("INGAME_CUSTOMER_FEMALE_REGULAR")
    p6:setDefaultSection("customers")
    p6:setPosition(grid:getNode(49, 3))
    p6:setVisible(false)

	p7 = pm:createPerson("npc")
    p7:setBaseName("INGAME_CUSTOMER_MALE_DESIGNER")
    p7:setDefaultSection("customers")
    p7:setPosition(grid:getNode(49, 3))
    p7:setVisible(false)

	p8 = pm:createPerson("npc")
    p8:setBaseName("INGAME_CUSTOMER_MALE_YUPPIES")
    p8:setDefaultSection("customers")
    p8:setPosition(grid:getNode(49, 3))
    p8:setVisible(false)

	self.dancers[1] = francois
	self.dancers[2] = edward
	self.dancers[3] = richard
	self.dancers[4] = angela

	self.sequenceStart = 
	{
		{ "scene",			"qStartMovie",		3									},
		
		{ "richard",		"qWalkToXY",				17, 15						},
		{ "richard",		"qSetAppearance",			"WORRIED"					},
		{ "richard",		"qSay",						"TEXT_RESTAURANT0_DAY8_0"	},
		{ "richard",		"qSay",						"TEXT_RESTAURANT0_DAY8_1"	},
		{ "richard",		"qSay",						"TEXT_RESTAURANT0_DAY8_2"	},		
		{ "emily",			"qSetAppearance",			"SAD"						},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_3"	},
		{ "emily",			"qSetAppearance",			""							},
		{ "francois",		"qSetVisible",				true						},
		{ "francois",		"qSetAppearance",			"ECSTATIC"					},
		{ "francois",		"qWalkToXY",				28, 19						},
		{ "francois",		"qSetAppearance",			"HAPPY"						},
		{ "francois",		"qSay",						"TEXT_RESTAURANT0_DAY8_4"	},
		{ "francois",		"qSay",						"TEXT_RESTAURANT0_DAY8_5"	},
		{ "francois",		"qSay",						"TEXT_RESTAURANT0_DAY8_6"	},
		{ "richard",		"qSetAppearance",			"THINKING"					},
		{ "richard",		"qSay",						"TEXT_RESTAURANT0_DAY8_7"	},
		{ "richard",		"qSay",						"TEXT_RESTAURANT0_DAY8_8"	},
		{ "francois",		"qSay",						"TEXT_RESTAURANT0_DAY8_9"	},
		{ "richard",		"qSetAppearance",			"HAPPY"						},
		{ "richard",		"qSay",						"TEXT_RESTAURANT0_DAY8_10"	},
		{ "richard",		"qWalkToXY",				0, 0						},
		{ "richard",		"qSetVisible",				false						},
		{ "emily",			"qSetAppearance",			"OFFENDED"					},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_11"	},
		{ "francois",		"qSay",						"TEXT_RESTAURANT0_DAY8_12"	},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_13"	},
		{ "francois",		"qWalkToXY",				0, 0						},
		{ "francois",		"qSetVisible",				false						},
		
		{ "emily",			"qSetAppearance",			""							},
		{ "scene", 			"qFinishMovie" 											},		
		{ "scene", 			"qStartGame" 											},
	}
	
	self.sequenceWin =
	{
		{ "emily",			"qSetAppearance",			"LAUGH"						},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_32"	},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_14"	},
		{ "richard",		"qSetAppearance",			"HAPPY"						},
		{ "richard",		"qSay",						"TEXT_RESTAURANT0_DAY8_15"	},
		{ "scene", 			"qFinishMovie" 											},
		{ "scene",			"qFinishGame" 										},		
	}
	
	self.sequenceLose =
	{
		{ "emily",			"qSetAppearance",			"SAD"						},
		{ "emily",			"qWalkToXY",				25, 15						},
		{ "emily",			"qWait",					500							},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_16"	},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_17"	},	
		{ "angela",			"qSetAppearance",			"ENTHUSIASTIC"				},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_19"	},				
		{ "emily",			"qSetAppearance",			""							},
		{ "angela",			"qSay",						"TEXT_RESTAURANT0_DAY8_20"	},
		{ "emily",			"qSetAppearance",			"CONFUSED"					},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_21"	},
		{ "angela",			"qSay",						"TEXT_RESTAURANT0_DAY8_22"	},
		{ "emily",			"qSetAppearance",			"LAUGH"						},
		{ "emily",			"qSay",						"TEXT_RESTAURANT0_DAY8_23"	},
		{ "angela",			"qSetAppearance",			""							},
		{ "angela",			"qSay",						"TEXT_RESTAURANT0_DAY8_24"	},
		{ "angela",			"qSay",						"TEXT_RESTAURANT0_DAY8_25"	},
		{ "angela",			"qSay",						"TEXT_RESTAURANT0_DAY8_26"	},
		{ "emily",			"qSetAppearance",			""							},	
		{ "emily",			"qAnimateWait",				"LAUGH", 3					},		
		{ "scene", 			"qFinishMovie" 											},
		{ "scene",			"qFinishGame" 										},		
	}
	
	self.sequenceGotoPosition =
	{
		{ "scene",		"qStartMovie",				true, 3						},

		{ "",			"parallel"												},
		
		{ "cleaner",	"qWalkToXY",				5, 16						},

		{ "p1",			"qSetVisible",				true						},	
		{ "p1",			"qWalkToXY",				37, 12						},

		{ "p2",			"qWait",					300							},	
		{ "p2",			"qSetVisible",				true						},	
		{ "p2",			"qWalkToXY",				47, 14						},

		{ "p3",			"qWait",					500							},	
		{ "p3",			"qSetVisible",				true						},	
		{ "p3",			"qWalkToXY",				47, 19						},

		{ "p4",			"qWait",					700							},	
		{ "p4",			"qSetVisible",				true						},	
		{ "p4",			"qWalkToXY",				40, 29						},

		{ "p5",			"qWait",					900							},	
		{ "p5",			"qSetVisible",				true						},	
		{ "p5",			"qWalkToXY",				14, 12						},

		{ "p6",			"qWait",					1000						},	
		{ "p6",			"qSetVisible",				true						},	
		{ "p6",			"qWalkToXY",				1, 29						},

		{ "p7",			"qWait",					1100						},	
		{ "p7",			"qSetVisible",				true						},	
		{ "p7",			"qWalkToXY",				11, 28						},

		{ "p8",			"qWait",					1200						},	
		{ "p8",			"qSetVisible",				true						},	
		{ "p8",			"qWalkToXY",				10, 12						},
		
		{ "angela",		"qSetVisible",				true						},	
		{ "angela",		"qWalkToXY",				23, 17						},

		{ "richard",	"qWait",					300							},	
		{ "richard",	"qSetVisible",				true						},	
		{ "richard",	"qWalkToXY",				28, 13						},

		{ "francois",	"qWait",					600							},	
		{ "francois",	"qSetVisible",				true						},	
		{ "francois",	"qWalkToXY",				33, 17						},

		{ "edward",		"qWait",					900							},	
		{ "edward",		"qSetVisible",				true						},	
		{ "edward",		"qWalkToXY",				31, 23						},
		
		{ "emily",		"qWalkToXY",				26, 24						},
		{ "",			"sequential"											},
		{ "angela",		"qNotify",					"arrived"					},
		{ "angela",		"qButtonAction",			"new", "DIP", 41, -60		},
		{ "angela",		"qButtonAction",			"popin", "DIP"				},
		{ "angela",		"qWait",					500							},
		{ "angela",		"qButtonAction",			"new", "TWIRL", 85, -19		},
		{ "angela",		"qButtonAction",			"popin", "TWIRL"			},
		{ "angela",		"qWait",					500							},
		{ "angela",		"qButtonAction",			"new", "STEP", 120, -60		},
		{ "angela",		"qButtonAction",			"popin", "STEP"				},		
		{ "angela",		"qWait",					1000						},
	}		

	self.sequenceDance =
	{
		{ "angela",		"qNotify",					"next move"					},	
	}
	
end

function day8:onLevelInited()
	qSequence(self.sequenceStart)
end

function day8:onDayBegin()
	--self.indexDance = self.indexDance + 1
	--self.indexMove = 0
	--qSequence(self.sequenceGotoPosition)
	--qSequence(self.sequenceDance)
end

function day8:onDayEnd()
	self.indexDance = self.indexDance + 1
	self.indexMove = 0
	qSequence(self.sequenceGotoPosition)
	qSequence(self.sequenceDance)

	autoAllPeopleWalkOut = false
end

function day8:onNotify(notification)

	if (notification == "next dance") then
		self:gotoNextDance()	
	
	elseif (notification == "next move") then
		self:gotoNextMove()

	elseif (notification == "enable buttons") then
		angela:buttonAction("enable", "DIP")
		angela:buttonAction("enable", "TWIRL")
		angela:buttonAction("enable", "STEP")
	
	elseif (notification == "disable buttons") then
		angela:buttonAction("disable", "DIP")
		angela:buttonAction("disable", "TWIRL")
		angela:buttonAction("disable", "STEP")	
	
	elseif (notification == "delete buttons") then
		angela:buttonAction("popout", "DIP")
		angela:buttonAction("popout", "TWIRL")
		angela:buttonAction("popout", "STEP")
	
	elseif (notification == "inc score") then
		incScore(self.scoreGotOne, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, 0)	
		emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
	
	elseif (notification == "inc score bonus") then
		incScore(self.scoreGotAll, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")		
		emily:playSound("SOUND_EVENT_COMPLETE_ALL")
	
	elseif (notification == "arrived") then
		if (self.indexDance == 1) then
			insert()
			angela:qAnimate("IDLE", 0)
			francois:qSay("TEXT_RESTAURANT0_DAY8_27")
			francois:qSay("TEXT_RESTAURANT0_DAY8_28")
			francois:qSay("TEXT_RESTAURANT0_DAY8_29")
			francois:qSay("TEXT_RESTAURANT0_DAY8_30")
			francois:qSay("TEXT_RESTAURANT0_DAY8_31")		
			append()	
		end	
	end

end

function day8:animateDancers(curIdx, doCheck)
	local dmoves = self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]
	local psound = false
	-- animate all the dancers still in the race	
	for i2 = self.indexDance, table.getn(self.dancers) do
		local dmove = dmoves[curIdx]
		local dmoveo = dmoves[curIdx]
		local dancer = self.dancers[i2]												
		if (((not doCheck) or self.indexDance < table.getn(self.dancers)) and i2 == self.indexDance and curIdx == self.wrongIdx) then
			if (dmove == "DIP") then
				dmove = "TWIRL"
			else
				dmove = "DIP"
			end	
			
			self.dancerLostIdx = self.dancerLostIdx + 1	
			dancer:qWait(300)
			if (not psound) then
				assert(self.choicesDanceSound)
				assert(self.choicesDanceSound[dmoveo])
				dancer:qPlaySound(self.choicesDanceSound[dmoveo])
				psound = true
			end
			dancer:qAnimateWait(dmove, 1, false, -1, true)
				
			dancer:qWait(250)
			if (self.dancerLostIdx <= table.getn(self.dancerLostPositions)) then
				dancer:qAnimateWait("LAUGH", 3)
				dancer:qAnimate("IDLE", 0)
				dancer:qWalkToXY(self.dancerLostPositions[self.dancerLostIdx].x, self.dancerLostPositions[self.dancerLostIdx].y)
			end
		else
			if (not psound) then
				assert(self.choicesDanceSound)
				assert(self.choicesDanceSound[dmoveo])
				dancer:qPlaySound(self.choicesDanceSound[dmoveo])
				psound = true
			end		
			dancer:qAnimateWait(dmove, 1, false, -1, true)
			dancer:qWait(160)
			dancer:qAnimate("IDLE", 0)
		end
	end				
	p1:qAnimateWait("ENTERTAIN", 1)
	p1:qAnimateWait("IDLE", 0)		
end

function day8:gotoNextDance()
	
	if (self.indexDance == table.getn(self.danceMoves) or (self.emilyOut and self.indexDance + 1 == table.getn(self.danceMoves))) then
		angela:qNotify("delete buttons")
		if (self.emilyOut) then
			-- we did the final dance wrong: lose
			qSequence(self.sequenceLose)	
		else
			-- we did the final dance right: win + bonus
			angela:qNotify("inc score bonus")
			emily:qAnimate("IDLE", 0)
			qSequence(self.sequenceWin)
		end
		return
	end
	
	self.indexDance = self.indexDance + 1
	self.indexMove = 0
	self:onNotify("disable buttons")
	
	if (self.danceMoves[self.indexDance]) then
		qSequence(self.sequenceDance)
	end
end

function day8:gotoNextMove()
	self:onNotify("disable buttons")

	self.indexMove = self.indexMove + 1
	self.clicked = {}
	
	if (self.danceMoves[self.indexDance][self.indexMove]) then
		-- francois shows next move
		self.wrongIdx = table.getn(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]])		
		
		hm:placeArrow(getArrowIndex("ARROW_HINT_DANCE"), angela, 82, 80)
		
		for index, value in ipairs(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]) do			
			angela:qButtonAction("highlight", value)
			angela:qPlaySound(self.choicesButtonSound[value])
			angela:qButtonAction("pop", value)
			angela:qWait(800)
		end
		
		if (self.emilyOut) then
			for index, value in ipairs(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]) do	
				-- animate all the dancers still in the race	
				parallel()
				self:animateDancers(index, false)
				sequential()
			end
		end
		
		if (self.emilyOut) then
			for idx, dancer in ipairs(self.dancers) do
				dancer:qAnimate("IDLE", 0)
			end			
			scene:qWait(350)
			scene:qNotify("next dance")
		else
			angela:qNotify("enable buttons")		
		end
	
	else
		-- we did all moves correct
		
		-- eventbar
		self.right = self.right + 1		
		if (self.indexDance ~= table.getn(self.danceMoves)) then
			-- there's dances left
			angela:qNotify("disable buttons")
			angela:qWait(800)
			scene:qNotify("next dance")	
		end
	end

end

function day8:onClickButton(button)
	if (emily.emilyOut) then
		warn("onClickButton while emilyOut \n")
	end

	table.insert(self.clicked, button)
	
	assert(self.choicesButtonSound)
	assert(self.choicesButtonSound[button])
	emily:playSound(self.choicesButtonSound[button])
	
	angela:clearOverhead()
	
	parallel()
	for index, value in ipairs(self.clicked) do
		if (self.clicked[index] ~= self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]][index]) then
			-- clicked wrong
			self:onNotify("disable buttons")
            emily:qPlaySound("SOUND_EVENT_BAD")
			assert(self.choicesDanceSound)
			assert(self.choicesDanceSound[button])
			emily:qPlaySound(self.choicesDanceSound[button])
			emily:qAnimateWait(button, 1, false, -1, true)
			emily:qAnimate("IDLE", 0)
			emily:qSetAppearance("SAD")			
			emily:qWait(450)
			self.emilyOut = true
			self.dancerLostIdx = self.dancerLostIdx + 1
			
			if (self.dancerLostIdx <= table.getn(self.dancerLostPositions)) then
				emily:qWalkToXY(self.dancerLostPositions[self.dancerLostIdx].x, self.dancerLostPositions[self.dancerLostIdx].y)
			end
			emily:qSetAppearance("")
			
			--continue the rest
			-- animate all the dancers still in the race	
			local dmoves = self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]]
			for i1 = index, table.getn(dmoves) do
				self:animateDancers(i1, true)
			end
			sequential()
			
			for idx, dancer in ipairs(self.dancers) do
				dancer:qAnimate("IDLE", 0)
			end

			scene:qNotify("next dance")
			return			
		end	
	end

	-- animate all the dancers still in the race
	self:animateDancers(table.getn(self.clicked), false)
		
	-- clicked right
	assert(self.choicesDanceSound)
	assert(self.choicesDanceSound[button])
	emily:qPlaySound(self.choicesDanceSound[button])	
	emily:qAnimateWait(button, 1, false, -1, true)
	emily:qWait(160)
	emily:qAnimate("IDLE", 0)
	sequential()
	
	if (table.getn(self.clicked) == table.getn(self.danceSteps[self.danceMoves[self.indexDance][self.indexMove]])) then
		-- all good
		-- immediate effect
		-- queue next
		
		for idx, dancer in ipairs(self.dancers) do
			dancer:qAnimate("IDLE", 0)
		end		

		onNotify("disable buttons")		
		emily:qAnimate("IDLE", 0)
		emily:qNotify("inc score")		
		emily:qWait(350)		
		scene:qNotify("next dance")	

		--emily:qNotify("next move")
	
	end
end

function day8:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day8()
