include("scripts/events/interviewevent.lua")

-- set event
event = interviewEvent()

-- day class
class 'day7' (interface)

function day7:__init() super()
end

function day7:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	emily:setPosition(grid:getNode(17, 15))
	cleaner:setPosition(grid:getNode(14, 15))
	
	event.timeUntilInterviewMin = 40000
	event.timeUntilInterviewMax = 60000
	event.interviewPerson = cleaner
	event.interviewPosX = 17
	event.interviewPosY = 15
	event.nrInterviews = 4

	event.sequenceDayStart = 
	{	
		{ "scene",			"qStartMovie",		1								},

		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_0"		},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY7_1"		},				
		{ "cleaner",		"qSetAppearance",	"BLUSH"							},				
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_2"		},				
		{ "cleaner",		"qSetAppearance",	""								},				
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_3"		},				
		{ "scene", 			"qFinishMovie" 										},
		{ "scene", 			"qStartGame" 										},
	}

	event.interviewSequences[0] =
	{	
		{ "scene",			"qStartMovie",		1								},
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},						
		{ "cleaner",		"qSayAsk",			"TEXT_RESTAURANT0_DAY7_4"		},				
		{ "emily",			"qSetAppearance",	""								},						
		{ "cleaner",		"qSetAppearance",	""								},						
		{ "scene", 			"qFinishMovie" 										},
	}

	event.interviewSequences[1] =
	{	
		{ "scene",			"qStartMovie",		1								},
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},						
		{ "cleaner",		"qSayAsk",			"TEXT_RESTAURANT0_DAY7_5"		},				
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_6"		},				
		{ "emily",			"qSetAppearance",	""								},						
		{ "cleaner",		"qSetAppearance",	""								},						
		{ "scene", 			"qFinishMovie" 										},
	}

	event.interviewSequences[2] =
	{	
		{ "scene",			"qStartMovie",		1								},
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},						
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_7"		},
		{ "emily",			"qSetAppearance",	"SURPRISED"						},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY7_8"		},					
		{ "cleaner",		"qSetAppearance",	"BLUSH"							},						
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_9"		},		
		{ "emily",			"qSetAppearance",	""								},				
		{ "cleaner",		"qSetAppearance",	""								},						
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_10"		},		
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},						
		{ "cleaner",		"qSayAsk",			"TEXT_RESTAURANT0_DAY7_7"		},				
		{ "emily",			"qSetAppearance",	""								},						
		{ "cleaner",		"qSetAppearance",	""								},						
		{ "scene", 			"qFinishMovie" 										},
	}

	event.interviewSequences[3] =
	{	
		{ "scene",			"qStartMovie",		1								},
		{ "cleaner",		"qSetAppearance",	"HAPPY"							},						
		{ "cleaner",		"qSayYesNo",		"TEXT_RESTAURANT0_DAY7_19"		},
	}

	event.sequenceDayEnd =
	{	
		{ "scene",			"qStartMovie",		1								},
		
		{ "",				"parallel"											},
		{ "emily",			"qWalkToXY",		14, 15							},						
		{ "cleaner",		"qWalkToXY",		17, 15							},						
		{ "",				"sequential"										},

		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_23"		},		
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_24"		},		
		{ "emily",			"qSetAppearance",	"CONFUSED"						},						
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY7_25"		},		
		{ "cleaner",		"qSetAppearance",	"BLUSH"							},						
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_26"		},		
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY7_27"		},		
		{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_30"		},		
		
		{ "emily",			"qSetAppearance",	""								},						
		{ "cleaner",		"qSetAppearance",	""								},								
		
		{ "",				"parallel"											},
		{ "emily",			"qWalkToXY",		0, 0							},						
		{ "cleaner",		"qWait",			400								},						
		{ "cleaner",		"qWalkToXY",		0, 0							},						
		{ "",				"sequential"										},

		{ "scene",			"qFinishMovie" 										},
		{ "scene",			"qFinishGame" 										},	
	}

end

function day7:onLevelInited()

end

function day7:onClickMessage(text, result)

	if (text == "TEXT_RESTAURANT0_DAY7_4") then
		choose("food", result)
	end
	
	if (text == "TEXT_RESTAURANT0_DAY7_5") then
		choose("flower", result)
	end

	if (text == "TEXT_RESTAURANT0_DAY7_7") then
		choose("date", result)
	end

	if (text == "TEXT_RESTAURANT0_DAY7_19") then
		choose("marry", result)
		
		if (result == "yes") then
			local sequence = 
			{		
				{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY7_20"		},				
				{ "emily",			"qSetAppearance",	""								},						
				{ "cleaner",		"qSetAppearance",	""								},						
				{ "scene", 			"qFinishMovie" 										},				
			}
			insert()
			qSequence(sequence)
			append()
		else
			local sequence = 
			{
				{ "emily",			"qSetAppearance",	""								},						
				{ "emily",			"qAnimateWait",		"LAUGH", 3						},
				{ "emily",			"qSetAppearance",	"LAUGH"							},						
				{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY7_21"		},		
				{ "cleaner",		"qSetAppearance",	"BLUSH"							},						
				{ "cleaner",		"qSay",				"TEXT_RESTAURANT0_DAY7_22"		},						
				{ "emily",			"qSetAppearance",	""								},						
				{ "cleaner",		"qSetAppearance",	""								},						
				{ "scene", 			"qFinishMovie" 										},				
			}
			insert()
			qSequence(sequence)
			append()
		end		
		return true
	end

end

function day7:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day7()