include("scripts/events/npcchaseevent.lua")

-- set event
event = npcChaseEvent()

-- day class
class 'day6' (interface)

day6.richard = nil
day6.bell = nil

function day6:__init() super()
end

function day6:onLevelGlobals()
	self.bell = nil
	self.richard = pm:createPerson("chaseRichard")
    self.richard.coordinates = 
	{
		{ 27, 12,  27, 12, "" },
		{ 11, 11, 11, 11, "" },
		{ 7, 29, 7, 29, "" },
		{ 39, 11, 39, 11, "" },
		{ 15, 16, 15, 16, "" },
		{ 28, 23, 25, 23, "" },
	}
	
	self.richard.arrivalAnim = "IDLE"
	self.richard.visibleWhenCaught = true
	
	event:addChaseNpc(self.richard)
	
	event.timeUntilEnterMin = 40 * 1000
	event.timeUntilEnterMax = 70 * 1000
	
	event.scoreGotOne = 25
	event.scoreGotAll = 150
	event.actionDuration = 0
	event.timerReturn = 1000 * 10
	--event.caughtSounds = {"SOUND_GIRL_GIGGLE0", "SOUND_GIRL_GIGGLE1"}
	event.shoutText = { "TEXT_RESTAURANT0_DAY6_22", "TEXT_RESTAURANT0_DAY6_23", "TEXT_RESTAURANT0_DAY6_24", "TEXT_RESTAURANT0_DAY6_25" }
	
	event.sequenceStart = 
	{
		{ "scene",		"qStartMovie",		3							},

    	{ "richard",	"qWalkToXY",		11, 14 },
    	{ "emily",		"qWalkToXY",		14, 14 },
    	{ "richard",	"qSetAppearance",	"HAPPY"						},
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_0"	},
    	{ "emily",		"qSetAppearance",	"OFFENDED"					},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY6_1"	},
    	{ "richard",	"qSetAppearance",	"SMUG"						},
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_2"	},
    	{ "emily",		"qSetAppearance",	"BLUSH"						},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY6_3"	},
    	{ "emily",		"qSetAppearance",	""							},    	
    	{ "richard",	"qWalkToXY",		32, 28						},
		{ "richard",	"qCallback",		self, function(self) bell:setVisible(false) end },
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_4"	},		
    	{ "richard",	"qWalkToXY",		17, 23 },
    	{ "emily",		"qSetAppearance",	"OFFENDED"					},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY6_5"	},		
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_6"	},		
    	{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY6_7"	},		
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_8"	},		
    	{ "richard",	"qSetAppearance",	""							},
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_9"	},		
    	{ "emily",		"qSetAppearance",	""							},  	
    	{ "scene",		"qFinishMovie" 									},
    	{ "scene",		"qNotify",			"chase start"				},
		{ "",			"parallel"										},			
	}
	
	event.sequenceWin = 
	{
		{ "scene",		"qStartMovie",		3							},

    	{ "emily",		"qAnimateWait",		"LAUGH", 1					},
    	{ "emily",		"qAnimate",			"IDLE", 0					},
    	{ "emily",		"qSetAppearance",	"LAUGH"						},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY6_10"	},
    	{ "richard",	"qSetAppearance",	"SMUG"						},
		{ "cleaner",	"qSetAppearance",	"ANGRY"						},   	
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_11"	},

    	{ "emily",		"qSetAppearance",	"OFFENDED"					},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY6_12"	},
		{ "cleaner",	"qSetAppearance",	""							},   	
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_13"	},

    	{ "richard",	"qSetAppearance",	""							},
		{ "richard",	"qCallback",		self, function(self) bell:setVisible(true) end },
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_15"	},
    	{ "emily",		"qSetAppearance",	""							},
    	{ "richard",	"qSetAppearance",	"HAPPY"						},    	
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_16"	},
    	{ "emily",		"qSetAppearance",	"OFFENDED"					},
    	{ "richard",	"qSetAppearance",	""							},    	
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_17"	},		
		{ "scene",		"qHideBars",		true						},
		{ "richard",	"qWalkToXY",		28, 10						},
    	{ "richard",	"qSetAppearance",	"SMUG"						},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_18"	},
    	{ "richard",	"qAnimateWait",		"LAUGH", 1					},
		{ "richard",	"qWalkToXY",		49, 3						},
		{ "richard",	"qDestroy"										},
    	{ "emily",		"qSetAppearance",	""							},  	
    	{ "scene",		"qFinishMovie" 									},
	}
	
	event.sequenceLose = 
	{
		{ "scene",		"qStartMovie",		3							},

    	{ "richard",	"qClearOverhead"								},

		{ "",			"parallel"										},
    	{ "richard",	"qWalkToXY",		28, 19						},
    	{ "emily",		"qWalkToXY",		25, 19						},
		{ "",			"sequential"									},			

    	{ "richard",	"qSetAppearance",	"ROLLEYES"					},
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_19"	},
    	{ "richard",	"qSetAppearance",	"SMUG"						},
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_20"	},
		
    	{ "emily",		"qSetAppearance",	"OFFENDED"					},
    	{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY6_12"	},
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_13"	},

    	{ "richard",	"qSetAppearance",	""							},
		{ "richard",	"qCallback",		self, function(self) bell:setVisible(true) end },
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_15"	},
    	{ "emily",		"qSetAppearance",	""							},
    	{ "richard",	"qSetAppearance",	"HAPPY"						},    	
    	{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_16"	},
    	{ "emily",		"qSetAppearance",	"OFFENDED"					},
    	{ "richard",	"qSetAppearance",	""							},    	
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_17"	},		
		{ "scene",		"qHideBars",		true						},
		{ "richard",	"qWalkToXY",		28, 10						},
    	{ "richard",	"qSetAppearance",	"SMUG"						},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY6_18"	},
    	{ "richard",	"qAnimateWait",		"LAUGH", 1					},
		{ "richard",	"qWalkToXY",		49, 3						},
		{ "richard",	"qDestroy"										},
    	{ "emily",		"qSetAppearance",	""							},  	
    	{ "scene",		"qFinishMovie" 									},
	}	
	

end

function day6:onLevelInited()
	bell = getObject("rest0_bel")
end

function day6:onNotify(notification)
end

function day6:createPerson(class)

	local result = nil
	if (class == "chaseRichard") then
		result = chaseNpc("INGAME_PERSON_RICHARD")
		result:setType(class)
		result:setDefaultSection("characters")
		--result:setAppearance("RUN")
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c			
	end
	
	return result
end

-- set day
day = day6()