-- set event

-- day class
class 'day5' (interface)

function day5:__init() super()
end

function day5:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	table2 = om:getTable(2)

	emily:setPosition(grid:getNode(17, 25))
	
	cleaner:setPosition(grid:getNode(25, 25))

	richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setPosition(grid:getNode(21, 25))
    richard:animate("IDLE", 0)

    francois = pm:createPerson("npc")
    francois:setBaseName("INGAME_PERSON_FRANCOIS")
    table2:sitDown(francois, 0)
    
	antonio = pm:createPerson("npc")
    antonio:setBaseName("INGAME_PERSON_ANTONIO")
    antonio:setPosition(grid:getNode(0, 0))
    antonio:setVisible(false)

	self.sequenceStart = 
	{	
		{ "scene",			"qStartMovie",		1								},
		
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_0"		},				
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_1"		},				
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_2"		},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY5_3"		},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY5_4"		},				
		{ "richard",		"qSetAppearance",	"SORRY"							},				
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_5"		},				
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_6"		},				
		{ "richard",		"qSetAppearance",	"SMUG"							},				
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_7"		},				
		{ "antonio",		"qSetVisible",		true							},
		{ "antonio",		"qSitAt",			table2, 1						},
		{ "richard",		"qSetAppearance",	""								},				
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY5_8"		},				
		{ "francois",		"qSay",				"TEXT_RESTAURANT0_DAY5_9"		},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY5_10"		},				
		{ "antonio",		"qSetAppearance",	"HAPPY"							},				
		{ "antonio",		"qSay",				"TEXT_RESTAURANT0_DAY5_11"		},				
		{ "antonio",		"qSetAppearance",	""								},				
		{ "antonio",		"qSay",				"TEXT_RESTAURANT0_DAY5_12"		},				
		{ "antonio",		"qSay",				"TEXT_RESTAURANT0_DAY5_13"		},						
		{ "antonio",		"qWalkToXY",		0, 0							},				
		{ "antonio",		"qDestroy"											},				
		{ "francois",		"qWalkToXY",		0, 0							},				
		{ "francois",		"qDestroy"											},				
		{ "richard",		"qWalkToXY",		0, 0							},				
		{ "richard",		"qDestroy"											},				
		
		{ "scene", 			"qFinishMovie" 										},
		{ "scene", 			"qStartGame" 										},
	}

	-- Betty
	betty = pm:createPerson("story_character")
    betty:setBaseName("INGAME_PERSON_BETTY")
    betty:setAppearance("SAD")
    betty:setPosition(grid:getNode(49, 2))
    betty:initTimer(40000, 60000)
   	betty.destX = 14
	betty.destY = 15
	betty.talkPositionX = 11
	betty.talkPositionY = 15
    betty.sequence =
	{	
		{ "scene",		"qStartMovie",		1									},
			
		{ "betty",		"qSetAppearance",	"SAD"								},					
		{ "betty",		"qSay",				"TEXT_RESTAURANT0_DAY5_14"			},						
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY5_15"			},						
		{ "betty",		"qSay",				"TEXT_RESTAURANT0_DAY5_16"			},						
		{ "betty",		"qSetAppearance",	""									},					
		{ "betty",		"qSay",				"TEXT_RESTAURANT0_DAY5_17"			},						
		{ "betty",		"qSay",				"TEXT_RESTAURANT0_DAY5_18"			},						
		{ "betty",		"qSetAppearance",	"SAD"								},					
		{ "betty",		"qSay",				"TEXT_RESTAURANT0_DAY5_19"			},						
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY5_38"			},						
		{ "emily",		"qSetAppearance",	"LAUGH"								},					
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY5_39"			},						
		{ "betty",		"qSetAppearance",	"LOVE"								},					
		{ "betty",		"qSay",				"TEXT_RESTAURANT0_DAY5_40"			},
		{ "betty",		"qSetAppearance",	""									},					
		{ "emily",		"qWait",		200										},				
		{ "scene", 		"qFinishMovie" 											},
	}
    betty.sequenceEnd =
	{
		{ "emily",		"qSetAppearance",	""									},					
		{ "betty",		"qSetAppearance",	""									},					
		{ "betty",		"qWalkToXY",		49, 2								},
		{ "betty",		"qDestroy"												},
	}
		
	-- mom and dad
	evelyn = pm:createPerson("story_character")
    evelyn:initTimer(35000, 60000)
    evelyn:setBaseName("INGAME_PERSON_EVELYN")
    evelyn:setPosition(grid:getNode(0, 0))
	evelyn.destX = 14
	evelyn.destY = 15
	evelyn.talkPositionX = 11
	evelyn.talkPositionY = 15
    evelyn.sequence =
  	{	
		{ "scene",		"qStartMovie",		1									},

		{ "edward",		"qSay",				"TEXT_RESTAURANT0_DAY5_20"			},						
		{ "evelyn",		"qSetAppearance",	"STOIC"								},					
		{ "evelyn",		"qSay",				"TEXT_RESTAURANT0_DAY5_21"			},						
		{ "edward",		"qSay",				"TEXT_RESTAURANT0_DAY5_22"			},						
		{ "evelyn",		"qSetAppearance",	""									},					
		{ "evelyn",		"qSay",				"TEXT_RESTAURANT0_DAY5_23"			},						
		{ "edward",		"qSay",				"TEXT_RESTAURANT0_DAY5_24"			},						
		{ "evelyn",		"qSetAppearance",	"STOIC"								},					
		{ "evelyn",		"qSay",				"TEXT_RESTAURANT0_DAY5_25"			},						
		{ "edward",		"qAnimateWait",		"FACEPALM", 1						},						
		{ "edward",		"qWait",			200									},						
		{ "edward",		"qAnimate",			"IDLE", 0							},						
		{ "evelyn",		"qSetAppearance",	""									},
		{ "evelyn",		"qSay",				"TEXT_RESTAURANT0_DAY5_26"			},						
		{ "evelyn",		"qSay",				"TEXT_RESTAURANT0_DAY5_27"			},						
		{ "edward",		"qAnimateWait",		"LAUGH", 2							},						
		{ "edward",		"qAnimate",			"IDLE", 0							},						
		{ "edward",		"qSetAppearance",	"LAUGH"								},
		{ "edward",		"qSay",				"TEXT_RESTAURANT0_DAY5_28"			},						
		{ "evelyn",		"qSay",				"TEXT_RESTAURANT0_DAY5_29"			},						
		{ "evelyn",		"qSay",				"TEXT_RESTAURANT0_DAY5_30"			},						
		
		{ "emily",		"qWait",			200									},				
		{ "scene", 		"qFinishMovie" 											},
	}
    evelyn.sequenceEnd =
	{	
		{ "emily",		"qSetAppearance",	""									},					
		{ "evelyn",		"qSetAppearance",	""									},					
		{ "evelyn",		"qWalkToXY",		0, 0								},
		{ "evelyn",		"qDestroy"												},
		{ "edward",		"qSetAppearance",	""									},					
		{ "edward",		"qWalkToXY",		0, 0								},
		{ "edward",		"qDestroy"												},
	}

	edward = pm:createPerson("story_character")
    edward:setBaseName("INGAME_PERSON_EDWARD")
    edward:setPosition(grid:getNode(0, 0))
	edward.destX = 10
	edward.destY = 15
	edward.talkPositionX = 11
	edward.talkPositionY = 15
	edward:setExtraCharacter(evelyn)
    edward.sequence = evelyn.sequence
    edward.sequenceEnd = evelyn.sequenceEnd	

	-- Angela
	angela = pm:createPerson("story_character")
    angela:setBaseName("INGAME_PERSON_ANGELA")
    angela:setPosition(grid:getNode(0, 0))
    angela:initTimer(45000, 70000)  
	angela.destX = 14
	angela.destY = 15
	angela.talkPositionX = 11
	evelyn.talkPositionY = 15  
    angela.sequence =
	{	
		{ "scene",		"qStartMovie",		1									},
			
		{ "angela",		"qSetAppearance",	"SAD"								},					
		{ "angela",		"qSay",				"TEXT_RESTAURANT0_DAY5_31"			},						
		{ "angela",		"qSay",				"TEXT_RESTAURANT0_DAY5_32"			},						
		{ "angela",		"qSay",				"TEXT_RESTAURANT0_DAY5_33"			},						
		{ "angela",		"qSay",				"TEXT_RESTAURANT0_DAY5_34"			},						
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY5_35"			},						
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY5_36"			},						
		{ "angela",		"qSetAppearance",	"ENTHUSIASTIC"						},					
		{ "angela",		"qSay",				"TEXT_RESTAURANT0_DAY5_37"			},						
		{ "emily",		"qSetAppearance",	"OFFENDED"							},						
					
		{ "emily",		"qWait",			500									},				
		{ "scene", 		"qFinishMovie" 											},
	}
    angela.sequenceEnd =
	{	
		{ "emily",		"qSetAppearance",	""									},					
		{ "angela",		"qSetAppearance",	""									},					
		{ "angela",		"qWalkToXY",		0, 0								},
		{ "angela",		"qDestroy"												},
	}
		
	betty:setActive()
	betty:setNextCharacter(evelyn)
	evelyn:setNextCharacter(angela)
end

function day5:onLevelInited()
	qSequence(self.sequenceStart)
end

function day5:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day5()