include("scripts/events/brokenobjectspecialevent.lua")

-- set event
event = brokenObjectSpecialEvent()
event.targetId = "rest0_Table_16"
event.nrTargets = 1

-- day class
class 'day4' (interface)

function day4:__init() super()
end

function day4:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false

	emily:setPosition(grid:getNode(49, 3))
	cleaner:setPosition(grid:getNode(49, 3))

    francois = pm:createPerson("npc")
    francois:setBaseName("INGAME_PERSON_FRANCOIS")
    francois:setDefaultSection("characters")
    francois:setPosition(grid:getNode(49, 3))

	richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setPosition(grid:getNode(49, 3))

	aldo = pm:createPerson("npc")
    aldo:setBaseName("INGAME_PERSON_ALDO")
    aldo:setPosition(grid:getNode(49, 3))
    aldo:setVisible(false)

	event.animFix = "CLEAN"
	event.soundFix = "SOUND_CLEAN_LOOP"
	event.overheadY = 33
	event.pbY = -150
	event.timeUntilFixed = 1000 * 60
	event.scoreGotAll = 200
	event.score = 100
	event.sequenceStart = 
	{
		{ "scene",		"qStartMovie",		1							},
		
		{ "",			"parallel"										},
		{ "emily",		"qWalkToXY",		19, 25						},
		{ "francois",	"qWait",			600							},
		{ "francois",	"qWalkToXY",		22, 25						},
		{ "richard",	"qWait",			1200						},
		{ "richard",	"qWalkToXY",		25, 25						},
		{ "cleaner",	"qWait",			1800						},
		{ "cleaner",	"qWalkToXY",		28, 25						},

		{ "",			"sequential"									},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_0"	},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_1"	},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_2"	},

		{ "emily",		"qWalkToNode",		event.brokenObjects[1]:getWorkNode() },		
		{ "emily",		"qSetAppearance",	"SURPRISED"					},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_3"	},
		{ "emily",		"qSetAppearance",	""	},
	
		{ "francois",	"qSetAppearance",	"DIRTY_SHOE"				},
		{ "francois",	"qSayTimed",		"TEXT_RESTAURANT0_DAY4_4_1", 1000 },
		{ "francois",	"qSetAppearance",	""							},
		{ "emily",		"qSetDirection",	2							},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "richard",	"qSetDirection",	2							},
		{ "richard",	"qAnimate",			"IDLE", 0					},
		{ "cleaner",	"qSetDirection",	2							},
		{ "cleaner",	"qAnimate",			"IDLE", 0					},
		{ "francois",	"qWait",			1000						},
		{ "francois",	"qSay",				"TEXT_RESTAURANT0_DAY4_4_2"	},

		{ "emily",		"qSetDirection",	1							},
		{ "emily",		"qAnimate",			"IDLE", 0					},
		{ "richard",	"qSetDirection",	1							},
		{ "richard",	"qAnimate",			"IDLE", 0					},
		{ "cleaner",	"qSetDirection",	1							},
		{ "cleaner",	"qAnimate",			"IDLE", 0					},
		
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_5"	},
		{ "richard",	"qWalkToXY",		49, 2						},
		{ "richard",	"qSetVisible",		false						},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT0_DAY4_6"	},

		{ "emily",		"qSetAppearance",	"LAUGH"						},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_7"	},
		{ "emily",		"qSetAppearance",	""							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_8"	},
				
		{ "francois",	"qWalkToXY",		49, 2						},
		{ "francois",	"qSetVisible",		false						},
		
		{ "scene",		"qFinishMovie" 									},		
		{ "scene",		"qStartGame" 									},
	}
	
	event.sequenceWin = 
	{
		{ "scene",		"qStartMovie",		1							},
		
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_14"	},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT0_DAY4_15"	},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_16"	},
				
		{ "scene",		"qFinishMovie" 									},		
	}	
	
	self.sequenceLose = 
	{
		{ "emily",		"qSetAppearance",	"SLEEPY"					},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_9"	},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT0_DAY4_10"	},
		{ "cleaner",	"qSetAppearance",	"HAPPY"						},
		{ "cleaner",	"qSay",				"TEXT_RESTAURANT0_DAY4_11"	},
		{ "cleaner",	"qSetAppearance",	""							},
		{ "emily",		"qSetAppearance",	""							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_12"	},		
	}
	
	self.sequenceCompleted = 
	{
		{ "aldo",		"qSetVisible",		true						},
		{ "aldo",		"qWalkToXY",		25, 17						},
		{ "aldo",		"qSetAppearance",	"SURPRISED"					},
		{ "aldo",		"qSay",				"TEXT_RESTAURANT0_DAY4_18"	},
		{ "emily",		"qSetAppearance",	"SURPRISED"					},
		{ "aldo",		"qSetAppearance",	""							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_19"	},
		{ "emily",		"qSetAppearance",	""							},
		{ "aldo",		"qSetAppearance",	"THINKING"					},
		{ "aldo",		"qSay",				"TEXT_RESTAURANT0_DAY4_20"	},
		
		{ "richard",	"qSetVisible",		true						},
		-- should run here
		{ "richard",	"qWalkToXY",		22, 17						},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_21"	},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_22"	},
		{ "aldo",		"qSay",				"TEXT_RESTAURANT0_DAY4_23"	},
		{ "richard",	"qSetAppearance",	"SMUG"						},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_24"	},
		{ "richard",	"qSetAppearance",	""							},
		{ "aldo",		"qSay",				"TEXT_RESTAURANT0_DAY4_25"	},
		{ "aldo",		"qWalkToXY",		49, 3						},
		{ "aldo",		"qDestroy"										},
		{ "emily",		"qSetAppearance",	"OFFENDED"					},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY4_26"	},

		{ "richard",	"qSetAppearance",	"SORRY"						},
		{ "richard",	"qSay",				"TEXT_RESTAURANT0_DAY4_27"	},
		{ "richard",	"qSetAppearance",	""							},

		{ "scene",		"qFinishMovie" 									},		
		{ "scene",		"qFinishGame" 									},				
	}
	
	event.brokenObjects[1]:setPosition(grid:getNode(44, 29))
end

function day4:onLevelInited()
end

function day4:onDayEnd()
	autoAllPeopleWalkOut = false

	local mood = 3
	if (not event.completed) then
		mood = 1
	end
		
	scene:qStartMovie(mood)
	if (not event.completed) then
		qSequence(self.sequenceLose)
	end
	
	qSequence(self.sequenceCompleted)
end

function day4:onNotify(notification)
	if (notification == "swap1") then
		local table = om:getTable(3)
		table:setReserved(true)
	end
end

function day4:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day4()