include("scripts/events/ordertableevent.lua")

-- set event
event = orderTableEvent()

-- day class
class 'day3' (interface)

day3.sequenceStart = nil
day3.sequenceFinish = nil

day3.state = "entering"
day3.person = {}
day3.personCount = 11

day3.exclamationPerson = {}
day3.exclamationDuration = 0
day3.exclamationPersonCount = 0
day3.personsToTalkTo = -1
day3.activeExclamationPerson = nil
day3.exclamationTimer = 0
day3.exclamationState = 0

day3.eventDone = false
day3.exclamationsDone = false

function day3:__init() super()
end

function day3:onLevelGlobals()

	self.personsToTalkTo = 12

	autoStartGame = false
	autoAllPeopleWalkIn = false
	restaurant.mailSpecial.doMailmanEvent = false

	emily:setPosition(grid:getNode(24, 32))

	table16 = om:getTable(3)
	table16:setReserved(true)

    francois = pm:createPerson("story_character")
    francois:setBaseName("INGAME_PERSON_FRANCOIS")
    francois:setDefaultSection("characters")
    francois:setPosition(grid:getNode(49, 3))
    francois:setVisible(false)
	francois.charState = "sitting"
	francois.sequenceExclamation = 
	{
		{ "scene",			"qStartMovie",		3								},				
		{ "francois",		"qSetAppearance",	"SAD"							},		
		{ "francois",		"qSay",				"TEXT_RESTAURANT0_DAY3_50_F"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_51_E"	},							
		{ "scene", 			"qFinishMovie" 										},
		{ "francois",		"qSetAppearance",	""								},		
	}
    self.person[0] = francois

    angela = pm:createPerson("story_character")
    angela:setVisible(true)
    angela:setBaseName("INGAME_PERSON_ANGELA")
    angela:setDefaultSection("characters")
    angela:setPosition(grid:getNode(0, 0))
	angela:setVisible(true)
	angela.charState = "sitting"
	angela.sequenceExclamation = 
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "angela",			"qSetAppearance",	"TALK"							},		
		{ "angela",			"qSay",				"TEXT_RESTAURANT0_DAY3_47_A"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_48_E"	},							
		{ "elvis",			"qSetAppearance",	"TALK"							},				
		{ "angela",			"qSetAppearance",	"SMIRK"							},		
		{ "betty",			"qSetAppearance",	"ANGRY"							},		
		{ "angela",			"qSay",				"TEXT_RESTAURANT0_DAY3_49_A"	},						
		{ "scene", 			"qFinishMovie" 										},
		{ "elvis",			"qSetAppearance",	""								},				
		{ "angela",			"qSetAppearance",	""								},		
		{ "betty",			"qSetAppearance",	""								},	
		{ "",				"parallel"											},			
	}    
    self.person[1] = angela

	self.sequenceStart = 
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "angela",			"qWalkToXY",		15, 15							},				
		{ "angela",			"qSay",				"TEXT_RESTAURANT0_DAY3_0_A"		},				
		{ "angela",			"qSay",				"TEXT_RESTAURANT0_DAY3_1_A"		},				
		{ "emily",			"qSetAppearance",	"LAUGH"							},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_2_E"		},					
		{ "emily",			"qSetAppearance",	""								},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_3_E"		},				
		{ "angela",			"qWait",			200								},
		{ "angela",			"qWalkToXY",		0, 0							},
		{ "angela",			"qSetVisible",		false							},
		{ "scene", 			"qFinishMovie" 										},
		{ "scene", 			"qStartGame" 										},
	}
		
	-- Antonio
	antonio = pm:createPerson("story_character")
    antonio:setBaseName("INGAME_PERSON_ANTONIO")
    antonio:setPosition(grid:getNode(49, 2))
    antonio:initTimer(40000, 60000)
    self.person[2] = antonio
    antonio.sequence =
	{	
		{ "scene",			"qStartMovie",		1								},		
		{ "antonio",		"qSetAppearance",	"PROUD"							},				
		{ "antonio",		"qSay",				"TEXT_RESTAURANT0_DAY3_4_AN"	},				
		{ "antonio",		"qSetAppearance",	""							},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_5_E"		},					
		{ "antonio",		"qSetAppearance",	"SAD"							},				
		{ "antonio",		"qSay",				"TEXT_RESTAURANT0_DAY3_6_AN"	},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_7_E"		},					
		{ "antonio",		"qSay",				"TEXT_RESTAURANT0_DAY3_8_AN"	},				
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_9_E"		},					
		{ "antonio",		"qSetAppearance",	""								},				
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    antonio.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "antonio",		"qSetAppearance",	""								},					
		{ "antonio",		"qWalkToXY",		0, 0							},
		{ "antonio",		"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}

	-- Mom and Dad
	edward = pm:createPerson("story_character")
    edward:setBaseName("INGAME_PERSON_EDWARD")
    edward:setPosition(grid:getNode(49, 2))
    edward:initTimer(40000, 60000)
    edward.optional = false
	edward.destX = 17
	edward.destY = 15
	edward.talkPositionX = 13
	edward.talkPositionY = 15
    self.person[3] = edward
    edward.sequence =
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "edward",			"qSetAppearance",	"HAPPY"							},
		{ "edward",			"qAnimateWait",		"SIGH", 1						},
		{ "edward",			"qAnimate",			"IDLE", 0						},
		{ "edward",			"qSay",				"TEXT_RESTAURANT0_DAY3_10_D"	},				
		{ "emily",			"qSetAppearance",	"LAUGH"							},					
		
		{ "",				"parallel"											},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_11_E"	},					
		{ "emily",			"qSetAppearance",	""								},					
		{ "evelyn",			"qSetAppearance",	"ANGRY_BACK"					},
		{ "evelyn",			"qWalkToXY",		27, 11							},
		{ "edward",			"qSetAppearance",	""								},

		{ "",				"sequential"										},			
		{ "evelyn",			"qSay",				"TEXT_RESTAURANT0_DAY3_12_M"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_13_E"	},		
		{ "evelyn",			"qSay",				"TEXT_RESTAURANT0_DAY3_14_M"	},
		{ "evelyn",			"qSetAppearance",	"DISAPPROVAL"					},						
		{ "evelyn",			"qWalkToXY",		10, 15							},
		{ "evelyn",			"qSay",				"TEXT_RESTAURANT0_DAY3_15_M"	},							
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_16_E"	},							
		{ "evelyn",			"qSay",				"TEXT_RESTAURANT0_DAY3_17_M"	},					
		{ "emily",			"qSetAppearance",	"OFFENDED"						},						
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_18_E"	},							
		{ "edward",			"qSay",				"TEXT_RESTAURANT0_DAY3_19_D"	},					
		{ "emily",			"qSetAppearance",	""								},	
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    edward.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "evelyn",			"qWalkToXY",		0, 0							},
		{ "evelyn",			"qSetVisible",		false							},
		{ "evelyn",			"qSetAppearance",	""								},	
		{ "edward",			"qWalkToXY",		0, 0							},
		{ "edward",			"qSetVisible",		false							},
		{ "edward",			"qSetAppearance",	""								},	
		{ "",				"parallel"											},			
	}

	evelyn = pm:createPerson("story_character")
    evelyn:setBaseName("INGAME_PERSON_EVELYN")
    evelyn:setPosition(grid:getNode(49, 2))
	evelyn.destX = 16
	evelyn.destY = 15
	evelyn.talkPositionX = 13
	evelyn.talkPositionY = 15
	evelyn:setVisible(true)
	evelyn.charState = "sitting"
	evelyn.sequenceExclamation = 
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "evelyn",			"qSetAppearance",	"DISAPPROVAL"					},
		{ "evelyn",			"qSay",				"TEXT_RESTAURANT0_DAY3_41_M"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_42_E"	},							
		{ "evelyn",			"qSay",				"TEXT_RESTAURANT0_DAY3_43_M"	},						
		{ "scene", 			"qFinishMovie" 										},
		{ "evelyn",			"qSetAppearance",	""								},		
		{ "",				"parallel"											},			
	}
    self.person[4] = evelyn

	-- Betty and Elvis
	betty = pm:createPerson("story_character")
    betty:setBaseName("INGAME_PERSON_BETTY")
    betty:setPosition(grid:getNode(49, 2))
    betty:initTimer(40000, 60000)  
	betty.destX = 17
	betty.destY = 15
	betty.talkPositionX = 11
	betty.talkPositionY = 15
    self.person[5] = betty
    betty.sequence =
  	{	
		{ "scene",			"qStartMovie",		2								},

		{ "emily",			"qSetAppearance",	"LAUGH"							},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_20_E"	},					
		{ "betty",			"qSay",				"TEXT_RESTAURANT0_DAY3_21_B"	},					
		{ "betty",			"qSay",				"TEXT_RESTAURANT0_DAY3_21_B2"	},					
		{ "emily",			"qSetAppearance",	""								},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_22_E"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_23_E"	},							
		{ "elvis",			"qSetAppearance",	"HAPPY"							},
		{ "elvis",			"qSay",				"TEXT_RESTAURANT0_DAY3_24_EL"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_25_E"	},					
		{ "elvis",			"qSetAppearance",	"SAD"							},
		{ "elvis",			"qSay",				"TEXT_RESTAURANT0_DAY3_26_EL"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_27_E"	},					
		{ "elvis",			"qSay",				"TEXT_RESTAURANT0_DAY3_28_EL"	},					
		{ "betty",			"qSay",				"TEXT_RESTAURANT0_DAY3_29_B"	},					
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    betty.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "betty",			"qSitAt",			table16, 0						},
		{ "betty",			"qSetAppearance",	""								},	
		{ "elvis",			"qSitAt",			table16, 1						},
		{ "elvis",			"qSetAppearance",	""								},	
		{ "elvis",			"qAnimate",			"CONVERSATION", 2				},
		{ "betty",			"qAnimate",			"CONVERSATION", 2				},
		{ "",				"parallel"											},			
	}

	elvis = pm:createPerson("story_character")
    elvis:setBaseName("INGAME_PERSON_ELVIS")
    elvis:setPosition(grid:getNode(49, 2))
    elvis:initTimer(40000, 60000)  
	elvis.destX = 14
	elvis.destY = 15
	elvis.talkPositionX = 11
	elvis.talkPositionY = 15
	elvis:setExtraCharacter(betty)
    elvis.sequence = betty.sequence
    elvis.sequenceEnd = betty.sequenceEnd
    self.person[6] = elvis

	-- Mo and tashi
	mo = pm:createPerson("story_character")
    mo:setBaseName("INGAME_PERSON_MO")
    mo:setPosition(grid:getNode(49, 2))
    mo:initTimer(40000, 60000)  
	mo.destX = 17
	mo.destY = 15
	mo.talkPositionX = 11
	mo.talkPositionY = 15
    self.person[7] = mo
    mo.sequence =
  	{	
		{ "scene",			"qStartMovie",		2								},

		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_30_E"	},					
		{ "emily",			"qSetAppearance",	"LAUGH"							},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_31_E"	},					
		{ "tashi",			"qSetAppearance",	"HAPPY"							},					
		{ "tashi",			"qSay",				"TEXT_RESTAURANT0_DAY3_32_T"	},					
		{ "emily",			"qSetAppearance",	"OFFENDED"						},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_33_E"	},							
		{ "tashi",			"qSetAppearance",	""								},					
		{ "emily",			"qSetAppearance",	"LAUGH"							},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_34_E"	},					
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    mo.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "mo",				"qSitAt",			table16, 2						},
		{ "mo",				"qSetAppearance",	""								},
		{ "tashi",			"qSitAt",			table16, 3						},
		{ "tashi",			"qSetAppearance",	""								},
		{ "tashi",			"qAnimate",			"CONVERSATION", 2				},
		{ "mo",				"qAnimate",			"CONVERSATION", 2				},
		{ "",				"parallel"											},			
	}
	mo.sequenceExclamation = 
	{	
		{ "scene",			"qStartMovie",		3								},
		{ "mo",				"qSetAppearance",	"HAPPY"							},
		{ "mo",				"qSay",				"TEXT_RESTAURANT0_DAY3_44_MO"	},					
		{ "mo",				"qSetAppearance",	""								},
		{ "tashi",			"qSetAppearance",	"ANGRY"							},
		{ "tashi",			"qSay",				"TEXT_RESTAURANT0_DAY3_45_T"	},							
		{ "mo",				"qSetAppearance",	"SAD"							},
		{ "mo",				"qSay",				"TEXT_RESTAURANT0_DAY3_46_MO"	},						
		{ "scene", 			"qFinishMovie" 										},
		{ "mo",				"qSetAppearance",	""								},		
		{ "tashi",			"qSetAppearance",	""								},
		{ "",				"parallel"											},			
		
	}
	tashi = pm:createPerson("story_character")
    tashi:setBaseName("INGAME_PERSON_TASHI")
    tashi:setPosition(grid:getNode(49, 2))
    tashi:initTimer(40000, 60000)     
	tashi.destX = 14
	tashi.destY = 15
	tashi.talkPositionX = 11
	tashi.talkPositionY = 15
	tashi:setExtraCharacter(mo)
    tashi.sequence = mo.sequence
    tashi.sequenceEnd = mo.sequenceEnd
    self.person[8] = tashi

	-- Maggie and Bill
	bill = pm:createPerson("story_character")
    bill:setBaseName("INGAME_PERSON_BILL")
    bill:setPosition(grid:getNode(49, 2))
    bill:initTimer(7000, 7001)        
	bill.destX = 17
	bill.destY = 15
	bill.talkPositionX = 11
	bill.talkPositionY = 15
    self.person[9] = bill
    bill.sequence =
  	{	
		{ "scene",			"qStartMovie",		3								},
		{ "maggie",			"qSay",				"TEXT_RESTAURANT0_DAY3_52_MA"	},					
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    bill.sequenceEnd =
	{	
		{ "emily",			"qSetAppearance",	""								},					
		{ "bill",			"qSitAt",			table16, 15						},
		{ "bill",			"qSetAppearance",	""								},					
		{ "maggie",			"qSitAt",			table16, 14						},
		{ "maggie",			"qSetAppearance",	""								},					
		{ "",				"parallel"											},			
	}

	maggie = pm:createPerson("story_character")
    maggie:setBaseName("INGAME_PERSON_MAGGIE")
    maggie:setPosition(grid:getNode(49, 2))
    maggie:initTimer(10000, 15000)           
	maggie.destX = 14
	maggie.destY = 15
	maggie.talkPositionX = 11
	maggie.talkPositionY = 15
	maggie:setExtraCharacter(bill)
    maggie.sequence = bill.sequence
    maggie.sequenceEnd = bill.sequenceEnd
    self.person[10] = maggie

	-- Paul
	paul = pm:createPerson("story_character")
    paul:setBaseName("INGAME_PERSON_PAUL")
    paul:setPosition(grid:getNode(0, 0))
	paul:initTimer(10000, 10001)
	paul.destX = 15
	paul.destY = 15
	paul.talkPositionX = 12
	paul.talkPositionY = 15
    paul.sequence =
  	{	
		{ "scene",			"qStartMovie",		3								},
		{ "paul",			"qSay",				"TEXT_RESTAURANT0_DAY3_53_P"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_54_E"	},					
		{ "paul",			"qSay",				"TEXT_RESTAURANT0_DAY3_55_P"	},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_56_E"	},					
		{ "emily",			"qWait",			200								},				
		{ "scene", 			"qFinishMovie" 										},
	}
    paul.sequenceEnd =
	{	
		{ "paul",			"qWalkToXY",		0, 0							},
		{ "paul",			"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}

	-- Richard
	richard = pm:createPerson("story_character")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setPosition(grid:getNode(0, 0))
	richard:initTimer(40000, 40001)
	richard.destX = 15
	richard.destY = 15
	richard.talkPositionX = 12
	richard.talkPositionY = 15
    richard.sequence =
  	{	
		{ "scene",			"qStartMovie",		3								},
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY3_57_R"	},
		{ "richard",		"qWalkToCounter"									},
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY3_58_R"	},
		{ "richard",		"qWalkToXY",		17, 15							},
		{ "richard",		"qSetAppearance",	"SURPRISED"						},					
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY3_59_R"	},
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_60_E"	},
		{ "richard",		"qSetAppearance",	"SMUG"							},					
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY3_61_R"	},
		{ "richard",		"qSay",				"TEXT_RESTAURANT0_DAY3_62_R"	},
		{ "emily",			"qSetAppearance",	"OFFENDED"						},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_63_E"	},					
		{ "richard",		"qWalkToXY",		0, 0							},
		{ "emily",			"qSetAppearance",	""								},					
		{ "richard",		"qSetVisible",		false							},
		{ "evelyn",			"qSetAppearance",	"HAPPY"							},					
		{ "evelyn",			"qSay",				"TEXT_RESTAURANT0_DAY3_64_M"	},					
		{ "emily",			"qSetAppearance",	"OFFENDED"						},					
		{ "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_65_E"	},										
		{ "emily",			"qWait",			200								},						
		{ "scene", 			"qFinishMovie" 										},
		{ "evelyn",			"qSetAppearance",	""								},					
		{ "emily",			"qSetAppearance",	""						        },					
		{ "",				"parallel"											},			
	}
    richard.sequenceEnd =
	{	
		{ "richard",		"qWalkToXY",		0, 0							},
		{ "richard",		"qSetVisible",		false							},
		{ "",				"parallel"											},			
	}

	-- Set the order of the characters entering
	antonio:setActive()
	antonio:setNextCharacter(edward)
	edward:setNextCharacter(betty)
	betty:setNextCharacter(mo)
		
	aldo = pm:createPerson("npc")
    aldo:setBaseName("INGAME_PERSON_ALDO")
    aldo:setPosition(grid:getNode(49, 2))
    aldo:setVisible(false)
			
	-- Event initializatie
	-- set event configuration
	event.pool = 										-- product pool
	{
		"TURKEY_PART",
		"SAUSAGE_READY",	
		"POACHED_PEAR",
		"BROCCOLI",
		"BROWN_CAKE",
		"ORANGE_JUICE" 
	}
	event.chances = 									-- product chances
	{
		100, 
		100,
		100,
		100,
		100,
		100
	}
	event.timeUntilEnterMin = -1
	event.timeUntilEnterMax = -1		
	event.timeUntilNextOrder = 5000						-- interval at which the orders come
	event.timeUntilEnd = 190000							-- time allowed to make all products
	event.timeTransfer = 400							-- time it takes to transfer the order	
	event.numProductsPerOrder = 2						-- number of products ordered each order
	event.numOrders = 20								-- total number of orders
	event.endScore = 200
	event.maxBalloonSize = 8
	event.maxBalloonWidth = 2
	event.pbX = 0
	event.table = table16
	event.subjectImage = "OBJECT_PARTY_BAR"
	event.sequenceStart = 
	{
		{ "scene",		"qNotify",			"start"							},	
		{ "scene",		"qStartMovie",		3								},
		{ "emily",		"qWalkToXY",		10, 16							},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY3_35_E"	},

		{ "",			"parallel"											},
		{ "edward",		"qWait",			300								},
		{ "edward",		"qSetVisible",		true							},
		{ "edward",		"qSitAt",			table16, 6						},

		{ "evelyn",		"qWait",			800								},
		{ "evelyn",		"qSetVisible",		true							},
		{ "evelyn",		"qSitAt",			table16, 7						},

		{ "angela",		"qWait",			1300							},
		{ "angela",		"qSetVisible",		true							},
		{ "angela",		"qSitAt",			table16, 8						},

		{ "antonio",	"qWait",			1800							},
		{ "antonio",	"qSetVisible",		true							},
		{ "antonio",	"qSitAt",			table16, 12						},	

		{ "",			"sequential"										},
		{ "francois",	"qSetVisible",		true							},
		{ "francois",	"qWalkToXY",		23, 23							},		
		{ "francois",	"qSay",				"TEXT_RESTAURANT0_DAY3_36_F"	},		
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY3_37_E"	},
		
		{ "",			"parallel"											},
		{ "francois",	"qSitAt",			table16, 11						},	
		{ "emily",		"qWalkTo",			"table16"						},
		
		{ "",			"sequential"										},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY3_38_E"	},
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY3_39_E"	},
		{ "emily",		"qSetAppearance",	"LAUGH"							},						
		{ "emily",		"qSay",				"TEXT_RESTAURANT0_DAY3_40_E"	},

		{ "scene",		"qFinishMovie" 										},		
		{ "emily",		"qSetAppearance",	""								},						
		{ "scene",		"qCallback",		table16, function(t) t:setTableTopImage("OBJECT_PARTY_TABLE_PLATES_FULL") end	},	
		{ "scene",		"qNotify",			"start ordering"				}
	}

    for i = 0,self.personCount - 1  do    
        self.person[i].eatState = ""
        self.person[i].eatTimer = 1		
    end		
	elvis.eatState = "CONVERSATION"
	betty.eatState = "CONVERSATION"
	tashi.eatState = "CONVERSATION"
	mo.eatState = "CONVERSATION"

	self.sequenceFinish =
	{
		{ "scene",		"qStartMovie",				true, 3							},

		{ "emily",		"qWalkToXY",				44, 30							},
		{ "tashi",		"qSetAppearance",			""								},		
		
		{ "aldo",		"qSetVisible",				true							},
		{ "aldo",		"qSetAppearance",			"ANNOYED"						},
		{ "aldo",		"qWalkToXY",				17, 15							},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_68_AL"	},
		
		{ "betty",		"qSetAppearance",			"ANGRY"							},
		{ "betty",		"qSay",						"TEXT_RESTAURANT0_DAY3_69_B"	},
		{ "angela",		"qSetAppearance",			"SMIRK"							},
		{ "angela",		"qSay",						"TEXT_RESTAURANT0_DAY3_70_A"	},

		{ "elvis",		"qSetAppearance",			"TALK"							},
		
		{ "emily",		"qSay",						"TEXT_RESTAURANT0_DAY3_71_E"	},
		{ "angela",		"qStand"													},
		{ "angela",		"qWalkToXY",				37, 13							},
		{ "angela",		"qSetAppearance",			"ANGRY"							},
		{ "angela",		"qSay",						"TEXT_RESTAURANT0_DAY3_72_A"	},
		{ "angela",		"qWalkToXY",				49, 2							},
		{ "angela",		"qDestroy"													},
		
		{ "aldo",		"qAnimate",					"ATTENTION", -1, 8				},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_68_AL"	},
		{ "aldo",		"qAnimate",					"IDLE", 0						},
		
		{ "tashi",		"qStand",													},
		{ "tashi",		"qSetAppearance",			"ANGRY"							},
		{ "tashi",		"qWalkToXY",				37, 13							},
		{ "tashi",		"qSay",						"TEXT_RESTAURANT0_DAY3_74_T"	},
		{ "mo",			"qSay",						"TEXT_RESTAURANT0_DAY3_75_MO"	},
		{ "tashi",		"qSay",						"TEXT_RESTAURANT0_DAY3_76_T"	},
		
		{ "",			"parallel"													},

		{ "mo",			"qStand"													},
		{ "mo",			"qWalkToXY",				49, 2							},		
		{ "mo",			"qDestroy"													},

		{ "tashi",		"qWalkToXY",				49, 2							},
		{ "tashi",		"qDestroy"													},
		{ "",			"sequential"												},			
		
		{ "aldo",		"qAnimate",					"ATTENTION", -1, 8				},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_68_AL"	},
		{ "aldo",		"qAnimate",					"IDLE", 0						},

		{ "evelyn",		"qStand"													},
		{ "evelyn",		"qWalkToXY",				41, 30,							},
		{ "evelyn",		"qSetAppearance",			"SUPRISED"						},
		{ "evelyn",		"qSay",						"TEXT_RESTAURANT0_DAY3_78_M"	},
		{ "emily",		"qSetAppearance",			"OFFENDED"						},
		{ "emily",		"qSay",						"TEXT_RESTAURANT0_DAY3_79_E"	},
		{ "evelyn",		"qSetAppearance",			"DISAPPROVAL"					},
		{ "evelyn",		"qSay",						"TEXT_RESTAURANT0_DAY3_80_M"	},
		{ "emily",		"qSetAppearance",			"SAD"							},
		{ "emily",		"qSay",						"TEXT_RESTAURANT0_DAY3_81_E"	},
		
		{ "aldo",		"qAnimate",					"ATTENTION", -1, 8				},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_82_AL"	},
		{ "aldo",		"qAnimate",					"IDLE", 0						},
		
		{ "betty",		"qStand"													},
		{ "betty",		"qSetAppearance",			"ANGRY"							},	
		{ "betty",		"qSay",						"TEXT_RESTAURANT0_DAY3_83_B"	},
		{ "emily",		"qSay",						"TEXT_RESTAURANT0_DAY3_84_E"	},
		
		{ "aldo",		"qAnimate",					"ATTENTION", -1, 8				},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_85_AL"	},
		{ "aldo",		"qAnimate",					"IDLE", 0						},

		{ "",			"parallel"													},
		{ "emily",		"qSetAppearance",			""								},
		{ "emily",		"qWalkToXY",				22, 16							},
		{ "evelyn",		"qWalkToXY",				23, 10							},
		{ "betty",		"qWalkToXY",				24, 12							},		
		{ "elvis",		"qWalkToXY",				23, 14							},
		{ "antonio",	"qWalkToXY",				24, 18							},
		{ "edward",		"qWalkToXY",				23, 20							},
		{ "bill",		"qWalkToXY",				26, 16							},
		{ "maggie",		"qWalkToXY",				25, 19							},
		{ "",			"sequential"												},			

		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_86_AL"	},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_87_AL"	},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_88_AL"	},
		{ "emily",		"qSay",						"TEXT_RESTAURANT0_DAY3_89_E"	},
		{ "aldo",		"qSay",						"TEXT_RESTAURANT0_DAY3_90_AL"	},
				
		{ "",			"parallel"													},
			
		{ "emily",		"qWalkToXY",				49, 2							},		
		{ "emily",		"qDestroy"													},

		{ "evelyn",		"qWalkToXY",				49, 2							},		
		{ "evelyn",		"qDestroy"													},

		{ "edward",		"qWalkToXY",				49, 2							},		
		{ "edward",		"qDestroy"													},
		
		{ "antonio",	"qWalkToXY",				49, 2							},
		{ "antonio",	"qDestroy"													},

		{ "betty",		"qWalkToXY",				49, 2							},
		{ "betty",		"qDestroy"													},
		
		{ "elvis",		"qWalkToXY",				49, 2							},
		{ "elvis",		"qDestroy"													},

		{ "bill",		"qWalkToXY",				49, 2							},
		{ "bill",		"qDestroy"													},

		{ "maggie",		"qWalkToXY",				49, 2							},
		{ "maggie",		"qDestroy"													},

		{ "aldo",		"qWalkToXY",				49, 2							},
		{ "aldo",		"qDestroy"													},
	
		{ "richard",	"qWalkToXY",				0, 0							},
		{ "richard",	"qDestroy",													},		
		
		{ "",			"sequential"												},			
		
		{ "francois",	"qSetVisible",				true							},
		{ "francois",	"qWalkToXY",				23, 23							},			
		
		{ "francois",	"qSay",						"TEXT_RESTAURANT0_DAY3_91_F"	},
		{ "francois",	"qAnimateWait",				"LOOK_AROUND", 2				},
		{ "francois",	"qSayTimed",				"TEXT_RESTAURANT0_DAY3_92_F", 1000	},

		{ "francois",	"qWalkToXY",				35, 32							},			
		{ "francois",	"qWait",					600								},			
		
		{ "francois",	"qSitAt",					table16, 10						},	
		{ "francois",	"qAnimate",					"EAT", -1, 8					},	
		{ "francois",	"qWait",					1000							},	
		
		{ "scene",		"qFadeToBlack"												},
		{ "scene",		"qFinishMovie" 												},
		{ "scene",		"qFinishGame" 												},
	}
	
end

function day3:onLevelInited()
	qSequence(self.sequenceStart)
end

function day3:onDayEnd()
	autoAllPeopleWalkOut = false
	qSequence(self.sequenceFinish)
end

function day3:onEventBegin()
	bill:setActive()
	bill:setNextCharacter(paul)
	paul:setNextCharacter(richard)

	self.exclamationDuration = 4000
	self.exclamationPersonCount = 0

	-- configure all the exclamation characters
	for i = 0,self.personCount - 1  do    
		if (self.person[i].sequenceExclamation) then
			table.insert(self.exclamationPerson, self.person[i])
			self.exclamationPersonCount = self.exclamationPersonCount + 1
			self.person[i].talkPositionX = 44
			self.person[i].talkPositionY = 30
			self.person[i].extraCharacter = nil
		end
	end	
end

function day3:onAllCharactersIn()
	event.active = true	
end

function day3:createPerson(class)
	if (class == "story_character") then
		m = storyCharacter("")
		m:setType(class)
		return m				
	elseif (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end		
	
	return nil		
end

function day3:onNotify(notification)
	if (notification == "all characters in") then
		if (self.state == "entering") then
			self:onAllCharactersIn()
			self.state = "characters in"
		end
	elseif (notification == "start") then
		self:onEventBegin()
		for i = 0,self.personCount - 1  do   
			self.person[i]:animate("IDLE", 0)		
		end		
	elseif (notification == "start ordering") then
		for i = 0,self.personCount - 1  do    
			self.person[i].eatState = "ORDER"		
		end		
	elseif (notification == "start eating") then
		for i = 0,self.personCount - 1  do    
			if (getRandom(2) == 0) then	self.person[i].eatState = "DRINK"
			else						self.person[i].eatState = "EAT"
			end		
		end		
	elseif (notification == "stop eating") then
		for i = 0,self.personCount - 1  do    
			self.person[i].eatState = "ORDER"	
			self.person[i]:animate("IDLE", 0)
		end		
	elseif (notification == "event done") then
		self.eventDone = true

		elvis.eatState = "CONVERSATION"
		betty.eatState = "CONVERSATION"
		tashi.eatState = "CONVERSATION"
		mo.eatState = "CONVERSATION"
		elvis.eatTimer = 1
		betty.eatTimer = 1
		tashi.eatTimer = 1
		mo.eatTimer = 1

		self:handleEndDay()
	end	
end


function day3:handleEndDay()
	if (self.eventDone and self.exclamationsDone) then
		cout("handleLastCustomerGone\n")
		level:handleLastCustomerGone()	
	end
end

function day3:onTick(time)
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end
	
	-- the group customers have to do other stuff
	if (event.started == true) then
	
		if (self.state == "exclamation") then			
			self.exclamationTimer = self.exclamationTimer - time
			if (self.exclamationTimer <= 0) then
			
				if (self.exclamationState == 1) then
		            self.activeExclamationPerson:qWalkToXY(0, 0)
		            self.activeExclamationPerson:qSetVisible(false)
				end

				self.activeExclamationPerson:setSelected(false)
				self.activeExclamationPerson:removeHighlight()
				self.activeExclamationPerson:removeOverhead()
				self.activeExclamationPerson:qSetAppearance("")
				self.activeExclamationPerson = nil
				
				if (self.exclamationPersonCount == 0) then
					self.exclamationsDone = true
					self:handleEndDay()
				end
				
				self.state = "characters in"
			end		
		elseif (self.exclamationPersonCount > 0 and self.state == "characters in") then	
			self.exclamationDuration = self.exclamationDuration - time
			if (self.exclamationDuration <= 0) then
				self.state = "exclamation"
				self.exclamationDuration = 15000
				self.exclamationTimer = 10000
				self.activeExclamationPerson = table.remove(self.exclamationPerson, getRandom(self.exclamationPersonCount) + 1) 
				local person = self.activeExclamationPerson
				person.eatState = "ORDER"
				person:animate("IDLE", 0)						
				person:createHighlight()
				person:setAppearance("WAVE")				
				person:setClickable(true)
				person:createOverhead("INGAME_EXCLAMATION_SIGN")
				person:playSound("SOUND_EVENT_ATTENTION")
				self.exclamationPersonCount = self.exclamationPersonCount - 1
				
				if (self.exclamationPersonCount == 0 and self.exclamationState == 0) then
				    self.exclamationPersonCount = -1
				    self.exclamationDuration = 1000
				end
			end			
		elseif (self.exclamationPersonCount == -1 and self.state == "characters in") then
		    self.exclamationState = self.exclamationState + 1		    
            francois.sequenceExclamation = 
            {	
                { "scene",			"qStartMovie",		3								},
                { "francois",		"qSay",				"TEXT_RESTAURANT0_DAY3_66_F"	},
                { "emily",			"qSetAppearance",	"LAUGH"							},							
                { "emily",			"qSay",				"TEXT_RESTAURANT0_DAY3_67_E"	},							
                { "francois",		"qWalkToXY",		0, 0							},
                { "francois",		"qSetVisible",		false							},
                { "scene", 			"qFinishMovie" 										},
                { "emily",			"qSetAppearance",	""								},							
                { "francois",		"qSetAppearance",	""								},		
                { "francois",		"qCallback",		self, function(s) s.exclamationsDone = true s:handleEndDay() end },		
				{ "",				"parallel"											},			
            }
            self.exclamationDuration = 20000
            table.insert(self.exclamationPerson, francois)
            self.exclamationPersonCount = 1            
		end
			
		for i = 1,self.personCount - 1  do    
			local child = self.person[i]
			if (child and child:isSitting() and child:getAppearance() == "") then
				if (child.eatState == "DRINK" or child.eatState == "EAT") then
					if (child.eatTimer > 0) then
						child.eatTimer  = child.eatTimer  - time
						if (child.eatTimer  <= 0) then
							child:animate(child.eatState, 1)
							child.eatTimer  = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
						
							if (getRandom(2) == 0) then	child.eatState = "DRINK"
							else						child.eatState = "EAT"
							end					
						
						end
					end				
				elseif (child and child:isSitting() and child:getAppearance() == "") then
					if (child.eatState == "CONVERSATION") then
						if (child.eatTimer > 0) then
							child.eatTimer  = child.eatTimer  - time
							if (child.eatTimer  <= 0) then
								child:animate(child.eatState, 1, 10)
								child.eatTimer  = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)						
								child.eatState = "CONVERSATION"
							end
						end				
					end
				end
			end
		end
	else
		for i = 1,self.personCount - 1  do    
			local child = self.person[i]
			if (child and child:isSitting() and child:getAppearance() == "") then
				if (child.eatState == "CONVERSATION") then
					if (child.eatTimer > 0) then
						child.eatTimer  = child.eatTimer  - time
						if (child.eatTimer  <= 0) then
							child:animate(child.eatState, 1, 10)
							child.eatTimer  = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)						
							child.eatState = "CONVERSATION"
						end
					end				
				end
			end
		end		
	end	
end

function day3:onAllTasksFinished()
	event:onNotify("trigger start ordertable")
	return false
end

-- set day
day = day3()
