include("scripts/events/cardplacingevent.lua")

-- set event
event = cardPlacingEvent()

-- day class
class 'day2' (interface)

function day2:__init() super()
end

function day2:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	emily:setPosition(getAppliance("rest0_pear"):getWorkNode())
	emily:animate("WORK_FRONT", -1, 10)

	event.baseName = "INGAME_PERSON_ANGELA"
	event.entryX = 0
	event.entryY = 0
	event.workX = 14
	event.workY = 13
	event.minDuration = 3000
    event.maxDuration = 10000
	event.scoreOneCard	= 10
	event.scoreAllCards	= 140	
	event.workAnimEmily = "WORK_UP"
	event.sequenceStart	= 								-- text when event starts
	{	
		{ "scene",		"qStartMovie",		2							},			
		{ "person",		"qWalkToXY",		14, 12						},
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_0"	    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY2_1"	    },
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_2"	    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY2_3"	    },
		{ "person",		"qSetAppearance",	"THINKING"                  },			
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_4"	    },
		{ "person",		"qSetAppearance",	""                          },			
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_5"	    },
		{ "emily",		"qSetAppearance",	"LAUGH"						},			
		{ "emily",		"qSay",		        "RESTAURANT0_DAY2_6"	    },
		{ "emily",		"qSetAppearance",	""							},			
		{ "emily",		"qAnimate",			"IDLE", 0					},			
		{ "emily",		"qWalkToNode",		grid:getCounterNode()		},
        { "scene",		"qFinishMovie" 									},
		{ "scene", 		"qStartGame" 									},
	}
	event.sequenceDone	= 								-- text when event starts
	{	
		{ "scene",		"qStartMovie", 		2							},			
		{ "person",		"qSetAppearance",	"ENTHUSIASTIC"	            },
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_7"	    },
		{ "emily",		"qSetAppearance",	"LAUGH"	                    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY2_8"	    },
		{ "emily",		"qSetAppearance",	""	                        },
		{ "person",		"qSetAppearance",	""	                        },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY2_9"	    },
		{ "person",		"qSetAppearance",	"THINKING"	                },
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_10"	    },
		{ "person",		"qSetAppearance",	""	                        },
		{ "emily",		"qSetAppearance",	"LAUGH"						},
		{ "emily",		"qSay",		        "RESTAURANT0_DAY2_11"	    },
		{ "emily",		"qSetAppearance",	""							},			
		{ "person",		"qWalkToXY",		0, 0						},
		{ "person",		"qDestroy"                                      },
        { "scene",		"qFinishMovie" 									},
	}
	event.sequenceFail	= 								-- text when event starts
	{	
		{ "scene",		"qStartMovie",		2							},			
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_12"	    },
		{ "emily",		"qSetAppearance",	"SLEEPY"                    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY2_13"	    },
		{ "person",		"qSetAppearance",	"ENTHUSIASTIC"	            },	
		{ "person",		"qSay",		        "RESTAURANT0_DAY2_14"	    },
		{ "person",		"qWalkToXY",		0, 0						},
		{ "person",		"qDestroy"                                      },
        { "scene",		"qFinishMovie" 									},
	}
end


function day2:onLevelInited()
end

function day2:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day2()