include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Spider"
}

-- day class
class 'day1' (interface)

day1.firstSpiderId = 4

function day1:__init() super()
end

function day1:onLevelGlobals()

	-- create francois
    francois = pm:createPerson("francois")
    francois:setBaseName("INGAME_PERSON_FRANCOIS_WINTER")
    francois:setPosition(grid:getNode(45, 3))
    francois:setVisible(false)

	-- set event configuration
	event.baseName = "INGAME_PERSON_ANGELA"
	event.entryX = 49
	event.entryY = 3
	event.highlightX = 31
	event.highlightY = 12
	event.timeUntilEnterMin = 1
	event.timeUntilEnterMax = 2
	event.scoreFoundOne	= 10
	event.scoreFoundAll	= 30
	event.showItemsFromStart = false
	event.sequenceStart	= 								-- text when event starts
	{	
		{ "",			"sequential"									},		
		{ "scene",		"qStartMovie",		3							},		
		{ "person",		"qWalkToXY",		23, 23						},
		{ "person",		"qSetAppearance",	"ENTHUSIASTIC"	            },
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_0"	    },
		{ "emily",		"qSetAppearance",	"LAUGH"	                    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_1"	    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_2"	    },
		{ "person",		"qSetAppearance",	""	                        },
		{ "emily",		"qSetAppearance",	""	                        },
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_3"	    },
		{ "emily",		"qSetAppearance",	"PANIC"	                    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_4"	    },
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_5"	    },
		{ "scene",		"qNotify",			"trigger first spider"		},
		{ "emily",		"qSetAppearance",	""                          },
		{ "person",		"qSetAppearance",	"PANIC"	                    },
		
		{ "",			"parallel"									    },		
		{ "person",		"qSayTimed",		 "RESTAURANT0_DAY1_6", 1000 },		
		{ "person",		"qWalkToXY",		 23, 6	                    },

		{ "",			"sequential"									},		
		{ "emily",		"qSetAppearance",	"CONFUSED"                  },		
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_7"	    },
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_8"	    },
		{ "emily",		"qAnimateWait",		"LAUGH", 2	                },
		{ "emily",	    "qAnimate",			"IDLE", 0					},
		{ "emily",		"qSetAppearance",	"LAUGH"                     },		
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_9"	    },
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_10"	    },
		{ "person",		"qSetAppearance",	"OFFENDED"                  },		
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_11"	    },
		{ "person",		"qSetAppearance",	"ANGRY"                     },		
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_12"	    },
		{ "emily",		"qSetAppearance",	"ROLL_EYES"                 },		
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_13"	    },
		{ "person",		"qSetAppearance",	""                          },		
		{ "emily",		"qSetAppearance",	""                          },		
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qNotify",			"show bar"					},
		{ "",			"parallel"										},			
	}
	
	event.sequenceThanks = 
	{	
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie",		3							},	
		{ "person",		"qSetAppearance",	"PANIC"                     },		
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_14"	    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_15"	    },
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_16"	    },
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_17"	    },
		{ "scene",		"qNotify",			"trigger other spiders"		},
		{ "scene",		"qFinishMovie" 									},
	}

	event.sequenceDone = 
	{	
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie",		2							},	

		{ "emily",		"qSetAppearance",	"LAUGH"                     },		
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_18"	    },
		{ "person",		"qSetAppearance",	"THINKING"                  },		
		{ "person",		"qWalkToXY",		23, 23						},
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_19"	    },
		{ "emily",		"qSetAppearance",	""                          },		
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_20"	    },
		{ "person",		"qSetAppearance",	""                  },		
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_21"	    },
		{ "person",		"qSetAppearance",	"THINKING"                  },		
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_22"	    },
		{ "emily",		"qSetAppearance",	"LAUGH"                     },		
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_23"	    },
		{ "person",		"qSetAppearance",	""                          },		
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_24"	    },
		{ "emily",		"qSay",		        "RESTAURANT0_DAY1_25"	    },
		{ "person",		"qSetAppearance",	"DISGUSTED"                 },		
		{ "person",		"qSay",		        "RESTAURANT0_DAY1_26"	    },
		{ "person",		"qWalkToXY",		0, 0						},
		{ "emily",		"qSetAppearance",	""                          },		
		{ "person",		"qSetVisible",		false						},
		{ "scene",		"qFinishMovie" 									},
	}
	
	event.sequenceFail = 
	{	
		{ "",			"sequential"									},
		{ "scene",		"qStartMovie",		3							},
		{ "emily",		"qSetAppearance",	"SAD"                       },		
		{ "emily",		"qSay",		        "TEXT_RESTAURANT0_DAY1_27"	},
		{ "person",		"qSetAppearance",	"PANIC"                     },			
		{ "person",		"qSay",		        "TEXT_RESTAURANT0_DAY1_28"	},
		{ "emily",		"qSetAppearance",	""                          },		
		{ "emily",		"qSay",		        "TEXT_RESTAURANT0_DAY1_29"	},
		{ "person",		"qSay",		        "TEXT_RESTAURANT0_DAY1_30"	},
		{ "person",		"qWalkToXY",		0, 0						},
		{ "person",		"qSetVisible",		false						},
		{ "emily",		"qSetAppearance",	"OFFENDED"                  },		
		{ "emily",		"qSay",		        "TEXT_RESTAURANT0_DAY1_31"	},	
	}
		
	self.sequenceEnd = 
	{
		{ "",			"sequential"									},
		{ "francois",	"qSetVisible",		true						},		
		{ "francois",	"qSetAppearance",	"HAPPY"                     },		
		{ "francois",	"qWalkToXY",		20, 25						},
		{ "emily",		"qSetAppearance",	""							},		
		{ "emily",		"qSay",		        "TEXT_RESTAURANT0_DAY1_32"	},	
		{ "francois",	"qSay",		        "TEXT_RESTAURANT0_DAY1_33"	},	
		{ "emily",		"qSay",		        "TEXT_RESTAURANT0_DAY1_34"	},	
	}
end

function day1:onLevelInited()
end

function day1:onDayEnd()
	if (event.completed) then
		scene:qStartMovie(3)
	end	
	if (self.sequenceEnd ~= nil) then
		qSequence(self.sequenceEnd)		
	end		
	scene:qFinishMovie()
end

function day1:onNotify(notification)

	if (notification == "trigger first spider") then
		event:showObjectAtIndex(self.firstSpiderId)
		
	elseif (notification == "trigger other spiders") then
		local numSpiders = event:getNumberOfObjects()
		if (numSpiders > 0) then
			insert()
			local spiderAdded = 1
			for i = 1, numSpiders do
				if (i ~= self.firstSpiderId) then
					local spider = event:getObjectAtIndex(i)
					
					if (spider ~= nil) then
						spider:qWait(spiderAdded * 150)
						spider:qSetVisible(true)
						spider:qSetClickable(true)
						
						spiderAdded = spiderAdded + 1
					end
				end
			end
			append()	
		end
	end
end

function day1:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day1()