include("scripts/events/spiderwebevent.lua")

-- set event
event = spiderwebevent()
event.itemsProps = 
{
    {type="spiderWeb1", anchorY=0, image="OBJECT_DIRTY_OVEN_R", x=48, y=8},
    {type="spiderWeb2", anchorY=0, image="OBJECT_DIRTY_RECEPTION", x=30, y=28},
    {type="spiderWeb3", anchorY=0, image="OBJECT_DIRTY_RESEPTION_L", x=12, y=29},
    {type="spiderWeb4", anchorY=20, image="OBJECT_DIRTY_STAIRS_C", x=18, y=17},
    {type="spiderWeb5", anchorY=0, image="OBJECT_DIRTY_STAIRS_L", x=0, y=10},
    {type="spiderWeb6", anchorY=0, image="OBJECT_DIRTY_STAIRS_T", x=12, y=0},
}
event.pixelsToClean = 700

-- day class
class 'day0' (interface)

day0.tutorial = false
day0.vaseType = "vaseObject"
day0.fallVaseType = "fallVaseObject"
day0.vase = nil
day0.fallVase = nil
day0.productCounter = 0

function day0:__init() super()
end

function day0:createObject(desc)

  	result = nil
  	
  	if (desc:getType() == self.vaseType) then
  		result = D2Object()
  		result:setType(desc:getType())
		result:anchorY(-56)
		result:animate("ANIM_VASE_WOBBLE", 0)
  		self.vase = result 		
  	elseif (desc:getType() == self.fallVaseType) then
  		result = D2Object()
  		result:setType(desc:getType())
		result:anchorY(10)
		result:animate("ANIM_VASE_FALL", 0)
  		self.fallVase = result
  		self.fallVase:setVisible(false)
  	end
  
  	return result	
	
end

function day0:onLevelGlobals()
    -- the event
	event.baseName = "INGAME_PERSON_PAUL"                   -- appearance of the person
	event.eventBarImage = "OBJECT_CLEAN_BAR"
	event.entryX = 0									    -- position person enters from
	event.entryY = 2
	event.highlightX = 17
	event.highlightY = 15
	event.timeUntilEnterMin = 500							-- minimum time the person waits outside
	event.timeUntilEnterMax = 1000							-- maximum time the person waits outside
	event.scoreFoundOne	= 10								-- score for finding one item
	event.scoreFoundAll	= 40								-- bonus for finding all items		
	event.sequenceStart	= 									-- text when event starts
	{
		{ "scene",		"qNotify",			"show bar"					},
	}
	event.sequenceDone = 									-- text when you find all items
	{
		{ "person",		"qSetAppearance",	""							},
		{ "scene",		"qStartMovie",		2 							}, -- NORMAL
		{ "person",		"qWalkToXY",		26, 19					    },
		{ "person", 	"qSay",				"RESTAURANT0_DAY0_2"		},
		{ "emily",		"qSay",			    "RESTAURANT0_DAY0_3"		},
		{ "person",		"qWalkToXY",		0, 1					    },
		{ "person",		"qSetVisible",		false						},
		{ "scene",		"qFinishMovie" 									},
	}	

	autoStartGame = false
	autoAllPeopleWalkIn = false

	-- disable all the products for the tutorial
	restaurant.keySpecial.doKeyCustomers = false
	restaurant.mailSpecial.doMailmanEvent = false

	products = {}
	
	local p = nil
	p = getProduct("SAUSAGE")		if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("KEBAB")			if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("ORANGE_JUICE")	if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("BROCCOLI")		if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("BROWN_CAKE")	if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("TURKEY_PART")	if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("POACHED_PEAR")	if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("TURKEY")		if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end
	p = getProduct("BASTER")		if (p ~= nil) then self.productCounter = self.productCounter + 1 products[self.productCounter] = p end

	for i = 1, self.productCounter do
		products[i]:setClickable(false)	
		products[i]:setAcceptingTasks(true)
	end

	for i = 0,2 do
		om:getTable(i):setClickable(false)	
	end

	register:setClickable(false)

    -- create fake customers group   
    counterCustomer = pm:createPerson("fakecustomer")
    counterCustomer:setBaseName("INGAME_CUSTOMER_FEMALE_REGULAR")
    counterCustomer:setAcceptingTasks(true)
    counterCustomer:setPosition(grid:getNode(49, 2))
    counterCustomer:createHighlight()
    
    groupCustomers = {}
    groupCustomers[1] = pm:createPerson("fakecustomer")
    groupCustomers[1]:setBaseName("INGAME_CUSTOMER_MALE_REGULAR")
    groupCustomers[1]:setAcceptingTasks(true)
    groupCustomers[1]:setPosition(entryNode)
    groupCustomers[1]:createHighlight()
    groupCustomers[2] = pm:createPerson("fakecustomer")
    groupCustomers[2]:setBaseName("INGAME_CUSTOMER_FEMALE_CHILD")
    groupCustomers[2]:setAcceptingTasks(true)
    groupCustomers[2]:setPosition(entryNode)
    groupCustomers[2]:createHighlight()
    
    order = nil
    groupTable = om:getTable(1)
    
    buffet = getAppliance("rest0_buffet")
    buffet:setAcceptingTasks(true)
      
    -- This var will tell us where in the script we are:
    tutorialProgress = "START"
      
    overheadFrameTime = 200
    counterCustomer:setOverheadFrameTime(overheadFrameTime)
    groupCustomers[1]:setOverheadFrameTime(overheadFrameTime)
    groupCustomers[2]:setOverheadFrameTime(overheadFrameTime)
    getProduct("BROCCOLI"):setOverheadFrameTime(overheadFrameTime)
    getProduct("ORANGE_JUICE"):setOverheadFrameTime(overheadFrameTime)
    getProduct("BROWN_CAKE"):setOverheadFrameTime(overheadFrameTime)   
    groupTable:setOverheadFrameTime(overheadFrameTime)

	---- create vase
	createDummyObject(self.vaseType, 17, 23)

	---- create falling vase
	createDummyObject(self.fallVaseType, 17, 24)

	-- create francois
    francois = pm:createPerson("francois")
        
    richard = pm:createPerson("npc")
    richard:setBaseName("INGAME_PERSON_RICHARD")
    richard:setDefaultSection("characters")
    richard:setPosition(grid:getNode(49, 4))

    paul = pm:createPerson("npc")
    paul:setBaseName("INGAME_PERSON_PAUL")
    paul:setDefaultSection("characters")
    paul:setPosition(grid:getNode(4, 2))

    -- position at an entry point
    emily:setPosition(grid:getNode(entryX, entryY))
    francois:setPosition(grid:getNode(entryX, entryY))
   
    -- show the movie bar non-animated
	scene:showBars(false)

    -- start movie sequence
    -- ... this disables input
    -- ... this suspends the people manager so no customers enter
    scene:qStartMovie(2) -- NORMAL

    -- first part: emily and francois walk in
    -- we want them to walk in together, so this part needs
    -- to be parallel
    parallel()
    emily:qWait(500)
    emily:qWalkToXY(24, 27)
    
    francois:qWalkToXY(18, 27)
    
	-- second part: first conversation
	-- we don't want them to talk through eachother, so this part
	-- needs to be sequential
    sequential()  
    francois:qSay("INTRO_1")
    emily:qSay("INTRO_2")
    francois:qSetAppearance("THINKING")
    francois:qSay("INTRO_3")
    francois:qSetAppearance("")
    emily:qWalkToXY(31, 28)
    emily:qAnimateWait("RING_BELL", 1)
    emily:qWait(500)
    paul:qSay("INTRO_4")
    francois:qAnimateWait("SNEEZE", 1, 9)
    francois:qAnimate("IDLE", 0)
    francois:qSetAppearance("SURPRISED")
    self.vase:qAnimateWait("ANIM_VASE_WOBBLE", 1, false, 8, true)   
    francois:qWait(200)
    francois:qSetAppearance("")
    francois:qWait(300)
    self.vase:qDestroy()
    self.fallVase:qSetVisible(true)
    self.fallVase:qAnimateWait("ANIM_VASE_FALL", 1, false, 10, true)
    emily:qCallback(self, function(self) self.vase = nil end)
    emily:qWait(300)    
    emily:qSetAppearance("PANIC")
    emily:qSayTimed("INTRO_6", 1500)
    francois:qSetAppearance("BLUSH")
    emily:qSetAppearance("IDLE")    
    francois:qSay("INTRO_7")
    emily:qWalkToXY(19, 34)
    francois:qSetAppearance("")
    emily:qAnimate("FIX", -1)
    emily:qWait(2000)
    richard:qSetAppearance("SERIOUS")
    richard:qWalkToXY(11, 32)
    richard:qSay("INTRO_8")
    richard:qSay("INTRO_9")
    self.fallVase:qDestroy()
    emily:qAnimate("IDLE", 0)
    emily:qSetAppearance("CONFUSED")
    emily:qSay("INTRO_10")
    richard:qSetAppearance("SMUG")
    richard:qSay("INTRO_11")
    richard:qSetAppearance("")
    richard:qAnimateWait("LAUGH", 2)
    richard:qAnimate("IDLE", 0)
    richard:qSay("INTRO_12")
    emily:qSetAppearance("CONFUSED")  
    emily:qSay("INTRO_10")
    emily:qSetAppearance("")   
    richard:qSetAppearance("SERIOUS")
    richard:qSay("INTRO_13")
    emily:qSay("INTRO_14")
    richard:qSetAppearance("SMUG")
    richard:qSay("INTRO_15")
    richard:qSetAppearance("")
    richard:qSay("INTRO_16")
    francois:qAnimateWait("LAUGH", 2)
    francois:qAnimate("IDLE", 0)
    francois:qSay("INTRO_17")
    richard:qSay("INTRO_18")
    richard:qSetAppearance("SERIOUS")
    richard:qSay("INTRO_19")
    richard:qWalkToXY(49, 4)
    richard:qDestroy()
    paul:qWalkToXY(11, 32)
    paul:qWait(500)
    paul:qSetAppearance("BLUSH")
    paul:qSay("INTRO_20")
    emily:qSetAppearance("CONFUSED")
    emily:qSay("INTRO_21")
    emily:qSay("INTRO_22")
    emily:qSetAppearance("")
    paul:qSetAppearance("ROLLEYES")
    paul:qSay("INTRO_23")
    paul:qSetAppearance("")
    paul:qSay("INTRO_24")
    paul:qSayYesNo("INTRO_WANTHELP")
end

function interface:onDayBegin()
end

function day0:EndTutorial()

	-- remove all the tutorial customers
	counterCustomer:qDestroy()
    groupCustomers[1]:qDestroy()
    groupCustomers[2]:qDestroy()

	-- Rounding up the conversation and
	-- let actors walk to correct starting 
	-- positions simultaniously
	sequential()
	emily:qWalkToCounter()
	emily:qWait(500)
	paul:qSay("RESTAURANT0_DAY0_0")
	
	if (self.tutorial) then
		paul:qSetAppearance("BLUSH")
		paul:qSay("RESTAURANT0_DAY0_4")
		emily:qSay("RESTAURANT0_DAY0_5")
	else
		emily:qSay("RESTAURANT0_DAY0_1")
	end
	
    parallel()
	paul:qWalkToXY(0, 0)
	paul:qDestroy()

	sequential()
	if (not self.tutorial) then
		scene:qFinishMovie()
	end
	scene:qStartGame()		
	scene:qNotify("end tutorial")
    parallel()

end


function day0:onClickMessage(text, result)
	
	if (text == "INTRO_WANTHELP") then
		francois:qWalkToXY(49, 3)
		francois:qDestroy()	

		if (result == "yes") then
			self.tutorial = true
		
			scene:qFinishMovie()
			scene:qNotify("start tutorial")
			
			emily:qSetWalkTimePerNode(35)
			paul:qSetWalkTimePerNode(35)

			paul:qWait(500)
			paul:qSayTimed("TEXT_OKLISTEN", 2000)

			-- First customer walks in while the rest walks to 
			-- their position in the kitchen:
			parallel()
			counterCustomer:qWalkToXY(27, 29)
			emily:qWalkToCounter()
			paul:qWalkToXY(18,32)

			-- Customers thinks and orders after which betty 
			-- explains how to serve the customer:
			counterCustomer:qCreateOverhead("INGAME_THINK_ICON")
    		counterCustomer:qWait(4000)
    		counterCustomer:qClearOverhead()
			counterCustomer:qWait(500)
    		counterCustomer:qNotify("create order")
			parallel()    		
		else
			self:EndTutorial()
		end
			
		return true
	end

end

function day0:onClickPerson(person)
	
	if (not self.tutorial) then
		return
		
	end	
	
	-- Handle orange juice click for the first tutorial customer:
	if (person:getBaseName() == "INGAME_CUSTOMER_FEMALE_REGULAR" and tutorialProgress == "CLICKED_ORANGE_JUICE" and (not tray:isEmpty())) then
		tutorialProgress = "NULL"
		counterCustomer:qClearOverhead()
		emily:qWalkToCounter()
		emily:qWait(200)
		scene:qNotify("distribute product")
	end
	return false
	
end

function day0:onClickProduct(product)

	if (not self.tutorial) then
		return		
	end

	if (product:getName() == "BROCCOLI") then
		getProduct("BROCCOLI"):setClickable(false)
		getProduct("BROCCOLI"):clearOverhead()
	
	elseif (product:getName() == "ORANGE_JUICE") then
		getProduct("ORANGE_JUICE"):setClickable(false)
		getProduct("ORANGE_JUICE"):clearOverhead()
		
	elseif (product:getName() == "BROWN_CAKE") then
		getProduct("BROWN_CAKE"):setClickable(false)
		getProduct("BROWN_CAKE"):clearOverhead()

	end
	
	return false

end

function day0:onClickRegister(register)

	if (not self.tutorial) then
		return
		
	end

	register:setClickable(false)
	register:clearOverhead()	
	return false

end

function day0:onClickTable(table)

	if (not self.tutorial) then
		return
		
	end

	groupTable:setClickable(false)
	groupTable:clearOverhead()
	return false

end

function day0:onTaskStart(actorType, taskType, p0, p1)

	if (not self.tutorial) then
		return
		
	end

	if (taskType == "RegisterTask" and tutorialProgress == "CLICK_REGISTER") then
		-- Remove arrow over register and order balloon over customer1:
		self.order:setObsolete(true)
		self.order = nil
		
		-- Customer1 walks out of the restaurant
		counterCustomer:qWait(500)
		counterCustomer:qWalkToNode(exitNode)
		paul:qSetAppearance("HAPPY")
		paul:qSayTimed("TEXT_QUICKLEARNER", 3000)
		paul:qSetAppearance("")
		
		-- Customer 2 and 3 walk in and sit down at a table
		parallel()
		paul:qSayClickable("TEXT_PREFERTABLE")		
		
		groupCustomers[1]:qSitAt(groupTable, 0)
		groupCustomers[2]:qWait(200)
		groupCustomers[2]:qSitAt(groupTable, 1)
		groupCustomers[2]:qNotify("table read")
    	
    elseif (taskType == "RegisterTask" and tutorialProgress == "CLICK_REGISTER_TABLE") then
    	-- Remove arrow over register and order balloon over customer2:
		self.order:setObsolete(true)
		self.order = nil

		-- Customer2 and 3 walk out of the restaurant
		groupCustomers[1]:qWait(500)
		groupCustomers[1]:qWalkToXY(24, 24)
		groupCustomers[2]:qStand()
		groupCustomers[2]:qWalkToXY(25, 25)
		parallel()
		groupCustomers[1]:qWait(400)
		groupCustomers[2]:qWait(400)
		groupCustomers[1]:qWalkToNode(exitNode)
		groupCustomers[2]:qWait(200)
		groupCustomers[2]:qWalkToNode(exitNode)
		sequential()
		paul:qSay("TEXT_MESSYCUSTOMERS")
		groupTable:qCreateOverhead("INGAME_ARROW")
		groupTable:qSetClickable(true)
		tutorialProgress = "CLICK_CLEAN_TABLE"

	elseif (taskType == "TableTask" and tutorialProgress == "CLICK_CLEAN_TABLE" and p0:getOverheadY() == -100) then
		tutorialProgress = "CLEANING_TABLE"
		
	end
	return false
	
end


function day0:onTaskComplete(actorType, taskType, p0, p1)

	if (not self.tutorial) then
		return
		
	end

	if (taskType == "ProductTask" and p0:getName() == "ORANGE_JUICE" and tutorialProgress == "CLICK_ORANGE_JUICE") then
		tutorialProgress = "CLICKED_ORANGE_JUICE"
		counterCustomer:setOverheadY(-30)
		counterCustomer:qCreateOverhead("INGAME_ARROW")
		paul:qSayClickable("TEXT_GIVECUSTOMER")
	
	elseif (taskType == "ProductTask" and p0:getName() == "BROCCOLI" and tutorialProgress == "CLICK_BROCCOLI") then
		tutorialProgress = "CLICK_BROWN_CAKE"
		getProduct("BROWN_CAKE"):setOverheadY(0)
		getProduct("BROWN_CAKE"):setOverheadX(18)
		getProduct("BROWN_CAKE"):qCreateOverhead("INGAME_ARROW")
		getProduct("BROWN_CAKE"):qSetClickable(true)
			
	elseif (taskType == "ProductTask" and p0:getName() == "BROWN_CAKE" and tutorialProgress == "CLICK_BROWN_CAKE") then
		tutorialProgress = "CLICKED_BROWN_CAKE"
		groupTable:setAcceptingTasks(true)
		groupTable:setOverheadY(-100)
		groupTable:qCreateOverhead("INGAME_ARROW")
		groupTable:qSetClickable(true)

	elseif (taskType == "TableTask" and tutorialProgress == "CLICKED_BROWN_CAKE") then
		tutorialProgress = "SERVE_TABLE"
		scene:qNotify("table serve")

	elseif (taskType == "TableTask" and tutorialProgress == "CLEANING_TABLE" and p0:getOverheadY() == -100) then 
		tutorialProgress = "CLEANED_TABLE"
		paul:qSetAppearance("HAPPY")
		paul:qSay("TEXT_SPOTCLEAN")
		paul:qSay("TEXT_SEVERALBONUSSES")
		paul:qSetAppearance("")
		
		self:EndTutorial()

	elseif (taskType == "RegisterTask") then
		register:playSound("SOUND_REGISTER_END", "sound")
	
	end
	return false

end


function day0:onNotify(notification)

	if (notification == "create order") then
		self.order = createOrder()
		self.order:setPivotPointType(BOTTOMCENTER)
		
		-- calculate order position
		x = -counterCustomer:getAnchorX() + counterCustomer:getWidth() / 2
		y = -counterCustomer:getAnchorY()
		
		-- place order
		self.order:setX(x)
		self.order:setY(y)
		self.order:setAnchorPointType(BOTTOMCENTER)		
		counterCustomer:addChild(self.order)
		self.order:addProduct("ORANGE_JUICE")
		self.order:popIn()
		
		paul:qWait(500)
		getProduct("ORANGE_JUICE"):setOverheadY(0)
		getProduct("ORANGE_JUICE"):setOverheadX(17)
		getProduct("ORANGE_JUICE"):qCreateOverhead("INGAME_ARROW")
		getProduct("ORANGE_JUICE"):qSetClickable(true)
		paul:qSayClickable("TEXT_MAKEPRODUCTS")
		tutorialProgress = "CLICK_ORANGE_JUICE"

	elseif (notification == "distribute product") then
		tray:distributeProducts(self.order)
		self.order:draw()
		register:setAcceptingTasks(true)
		register:setOverheadY(0)
		register:qCreateOverhead("INGAME_ARROW")
		register:qSetClickable(true)
		paul:qSayClickable("TEXT_HANDLEPAYMENT")
		scene:qNotify("handle payment")
		
	elseif (notification == "handle payment") then
		tutorialProgress = "CLICK_REGISTER"
		
	elseif (notification == "table read") then
		-- animate customers
		groupCustomers[1].timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)		
		groupCustomers[1].state = "READ"
		groupCustomers[1]:animate("READ", 1)	
		groupCustomers[2].timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)		
		groupCustomers[2].state = "READ"
		groupCustomers[2]:animate("READ", 1)	
		
    	scene:qWait(6000)
    	scene:qNotify("table order")			

	elseif (notification == "table order") then
		-- animate customers
		groupCustomers[1].timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)		
		groupCustomers[1].state = "ORDER"
		groupCustomers[1]:animate("ORDER", 1)	
		groupCustomers[2].timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)		
		groupCustomers[2].state = "ORDER"
		groupCustomers[2]:animate("ORDER", 1)		
		groupTable:updateLegs(groupCustomers[1], 0)
		groupTable:updateLegs(groupCustomers[2], 1)
	
    	-- Create an order for the table group
    	self.order = createOrder()
    	self.order:setPivotPointType(BOTTOMCENTER)

		-- place order
		self.order:setX(2)
		self.order:setY(-47)
		self.order:setAnchorPointType(BOTTOMCENTER)
		groupTable:addChild(self.order)
		self.order:addProduct("BROCCOLI")
		self.order:addProduct("BROWN_CAKE")
		self.order:popIn()
		
		getProduct("BROCCOLI"):setOverheadY(0)
		getProduct("BROCCOLI"):setOverheadX(18)
		getProduct("BROCCOLI"):qCreateOverhead("INGAME_ARROW")
		getProduct("BROCCOLI"):qSetClickable(true)
		tutorialProgress = "CLICK_BROCCOLI"
		
	elseif (notification == "table serve") then
		tray:distributeProducts(self.order)
		self.order:draw()
		self.order:setAlpha(0)
		groupTable:setPlateState(PLATES_FULL)

		x = -groupCustomers[1]:getAnchorX() + 47
		y = -groupCustomers[1]:getAnchorY() - 60
		
		self.order:setX(x)
		self.order:setY(y)
		
		-- animate customers
		groupCustomers[1].timer = CUSTOMER_EATING_MIN_INTERVAL + getRandom(CUSTOMER_EATING_RND_INTERVAL)		
		groupCustomers[1].state = "DRINK"
		groupCustomers[1]:animate("DRINK", 1)	
		groupCustomers[2].timer = CUSTOMER_EATING_MIN_INTERVAL + getRandom(CUSTOMER_EATING_RND_INTERVAL)		
		groupCustomers[2].state = "EAT"
		groupCustomers[2]:animate("EAT", 1)		
		groupTable:updateLegs(groupCustomers[1], 0)
		groupTable:updateLegs(groupCustomers[2], 1)			
		groupTable:playSound("SOUND_CUSTOMER_EATING_LOOP_0", true)
		
    	scene:qWait(7000)
    	scene:qNotify("table stand up")
    	
    	tutorialProgress = "NULL"    	
    	
    elseif (notification == "table stand up") then	
    	groupTable:setPlateState(PLATES_EMPTY)
    	groupTable:stopSound("SOUND_CUSTOMER_EATING_LOOP_0")
    	groupTable:playSound("SOUND_CUSTOMER_FINISHED_EATING")
    	
    	groupCustomers[1].state = ""
    	groupCustomers[2].state = ""
    	groupCustomers[1]:addChild(self.order)
    	
    	groupCustomers[1]:qStand()
    	groupCustomers[1]:qWalkToXY(27, 29)
    	groupCustomers[1]:qNotify("handle table payment")

	elseif (notification == "handle table payment") then
		self.order:setAlpha(1)
		self.order:popIn()
		register:qCreateOverhead("INGAME_ARROW")
		register:qSetClickable(true)
		paul:qSayClickable("TEXT_PAYMENTAGAIN")
		tutorialProgress = "CLICK_REGISTER_TABLE"
	
	elseif (notification == "start tutorial") then
		--level:setSuspended(false)
		level:setLevelSuspended(false)
		input:setInputActive(true)
	
	elseif (notification == "end tutorial") then
		self.tutorial = false
		
		for i = 1, self.productCounter do
			products[i]:setClickable(true)	
		end
				
		for i = 0,2 do
			om:getTable(i):setClickable(true)		
		end
		
		register:setClickable(true)	
		
		restaurant.keySpecial.doKeyCustomers = true
		restaurant.mailSpecial.doMailmanEvent = false
	end

end

function day0:onTick(time)

	if (not self.tutorial) then
		return
		
	end

	-- the group customers have to do other stuff
	for index, value in ipairs(groupCustomers) do    
		if (value ~= nil) then
			if (value.state == "READ") then
				if (value.timer > 0) then
					value.timer = value.timer - time
					if (value.timer <= 0) then
						value:animate(value.state, 1)
						value.timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
					
					end
				end			
			
			elseif (value.state == "ORDER") then
				if (value.timer > 0) then
					value.timer = value.timer - time
					if (value.timer <= 0) then
						value:animate(value.state, 1)
						value.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
					
					end
				end	
			
			
			elseif (value.state == "DRINK" or value.state == "EAT") then
				if (value.timer > 0) then
					value.timer = value.timer - time
					if (value.timer <= 0) then
						value:animate(value.state, 1)
						value.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
					
					end
				end
			
			end
		end
	end
end

function day0:createPerson(class)
	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_PAUL")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	
	end
end

-- set day
day = day0()