include("scripts/products/regularproduct.lua")
include("scripts/appliances/pearappliance.lua")
include("scripts/appliances/packageappliance.lua")
include("scripts/appliances/turkeyappliance.lua")

include("scripts/products/oventurkeyproduct.lua")
include("scripts/products/deliverkeyproduct.lua")
include("scripts/products/getkeyproduct.lua")
include("scripts/products/basterproduct.lua")
include("scripts/products/getmailproduct.lua")
include("scripts/products/grillproduct.lua")
include("scripts/products/plateproduct.lua")
include("scripts/products/pearProduct.lua")

include("scripts/specialevents/keyspecial.lua")
include("scripts/specialevents/mailmanspecial.lua")

-- global variables and behavior we might need in a specific restaurant

-- entry node
-- npc's and such will be spawned at this location
entryX = 49
entryY = 2
entryNode = nil

-- exit node
exitX = 0
exitY = 0
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = 45
movieY = 0
movieNode = nil

-- restaurant class
class 'restaurant0' (interface)

-- key special event stuff
restaurant0.keySpecial = keyspecial()

-- mailman special event stuff
restaurant0.mailSpecial = mailmanspecial()
restaurant0.snow = nil

function restaurant0:__init() super()
end

function restaurant0:onLevelInited()

	self.keySpecial:onLevelInited()
	self.mailSpecial:onLevelInited()
	self.mailSpecial.entryNode = grid:getNode(0, 0)
	self.mailSpecial.exitNode = grid:getNode(0, 0)
	
	self.snow = level:getLayer(0):addParticleEffectAfter("PARTICLE_SNOW_RESTAURANT")
	self.snow:play()
	self.snow:addInitialTime(15000)
end

function restaurant0:onTick(time)

	self.keySpecial:onTick(time)
	self.mailSpecial:onTick(time)
	
end

function restaurant0:onNotify(notification)

	self.keySpecial:onNotify(notification)
	self.mailSpecial:onNotify(notification)

end

function restaurant0:createPerson(class)
	if (class == "specialmailman") then
		m = specialmailman("INGAME_PERSON_SPECIAL_MAILMAN")
		m:setType(class)
		return m
	end
	
	return nil
end


function restaurant0:createObject(desc)

	if (desc:getObjectId() == "rest0_pear") then
		result = pearappliance()
		result.overheadAnimation = "INGAME_CRANBERRY_STIR"		
		result:setType(desc:getType())
		return result
	
	elseif (desc:getObjectId() == "rest0_package") then
		result = packageappliance()
		result:setType(desc:getType())
		result:setVisible(false)
		return result

	elseif (desc:getObjectId() == "rest0_oven") then
		result = turkeyAppliance()
		result:setType(desc:getType())
		return result

	end
	return nil
end

function restaurant0:createProduct(base)

	if (type(base) == "string")	then
		if (base == "ORANGE_JUICE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_PICKDRINKANDPOPCAP")
			p:setWorkOffsetX(3)
			return p
		elseif (base == "BROCCOLI") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_BROCOLLI")
			p:setWorkOffsetX(-2)
			return p		
		elseif (base == "BROWN_CAKE") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setWorkOffsetX(1)
			return p		
		elseif (base == "POACHED_PEAR") then
			p = pearProduct(base)
			p.applianceName = "rest0_pear"
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GET_SOUP")
			return p		
		elseif (base == "NEWSPAPER_PINK") then
			p = regularProduct(base)
			p:setShowX(false)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_NEWSPAPER")
			p:setStock(0)
			p:setMaxStock(2)
			return p		
		elseif (base == "NEWSPAPER_GREY") then
			p = regularProduct(base)
			p:setShowX(false)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_NEWSPAPER")
			p:setStock(0)
			p:setMaxStock(8)
			return p		
	
		elseif (base == "KEY_1" or base == "KEY_2" or base == "KEY_3") then
			p = getkeyproduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_KEY")
			p:setStock(0)
			p:setMaxStock(5)
			p:setWorkOffsetX(0)
			p:setVisible(false)
			return p		

		elseif (base == "KEY_1_DROP" or base == "KEY_2_DROP" or base == "KEY_3_DROP") then
			p = deliverkeyproduct(base)
			
			if (base == "KEY_1_DROP") then
				p.keyProduct = "KEY_1"
			elseif (base == "KEY_2_DROP") then
				p.keyProduct = "KEY_2"
			else
				p.keyProduct = "KEY_3"
			end
			
			p:setVisible(false)
			p:setClickable(false)
			p:setWorkTime(200)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_KEY")
			p:setWorkOffsetX(0)
			return p	
			
		elseif (base == "ENVELOP" or base == "MAIL") then
			p = getmailproduct	(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_PICKUP_POST_CARD")
			p:setWorkOffsetX(5)
			return p			
			
		elseif (base == "TURKEY") then
			p = oventurkeyproduct(base)
			p:setBubbleTarget("rest0_oven")
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_BACK")
			p:setWorkSound("SOUND_GRAB_TEA")
			return p		

		elseif (base == "TURKEY_PART") then
			p = regularProduct(base)
			p:setWorkTime(800)
			p:setWorkAnimation("WORK_FRONT")
			p:setWorkSound("SOUND_GRAB_TEA")
			p:setStock(2)
			p:setMaxStock(16)
			p:setWorkOffsetX(-10)
			p:setStockCounterX(p:getStockCounterX() - 24)
			return p					
			
		elseif (base == "BASTER") then
			p = basterproduct(base)
			p:setWorkTime(500)
			p:setWorkAnimation("WORK_RIGHT")
			p:setWorkSound("SOUND_SQUIRT_SAUCE_ON_RIBS")
			p:setWorkOffsetX(-3)
			return p								

		elseif (base == "SAUSAGE" or base == "KEBAB") then
			p = grillProduct(base)
			p:setWorkTime(500)  
			p:setWorkSound("SOUND_PICKUP_HOTDOG")
			return p								
		
		elseif (base == "PLATE0" or base == "PLATE1" or
				base == "PLATE2" or base == "PLATE3" or
				base == "PLATE4" or base == "PLATE5" or
				base == "PLATE6" or base == "PLATE7" or
				base == "PLATE8" or base == "PLATE9" or
				base == "PLATE10" or base == "PLATE11" or
				base == "PLATE12" or base == "PLATE13" or
				base == "PLATE14" or base == "PLATE15") then
			p = plateProduct(base)
			p:setClickable(false)
			self:updatePlateOffset(base, p)
			p:setWorkTime(100)  
			return p
			
		end
		
	elseif (type(base) == "userdata") then
		-- attempting to create a copy!
		-- attempting to create a copy!
		if (base:getBase() == "TURKEY") then
			p = oventurkeyproduct(base)
			return p

		elseif (base:getBase() == "SAUSAGE" or base:getBase() == "KEBAB") then
			p = grillProduct(base)
			return p
			
			
		end
	
	end
		
	return nil

end

function restaurant0:updatePlateOffset(base, product)
	if (base == "PLATE0") then
		p:setWorkOffsetX(-3)
		p:setWorkOffsetY(0)
	elseif(base == "PLATE1") then  
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(0)
	elseif(base == "PLATE2") then  
		p:setWorkOffsetX(-3)	
		p:setWorkOffsetY(-2)
	elseif(base == "PLATE3") then  
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(-2)
	elseif(base == "PLATE4") then  
		p:setWorkOffsetX(-3)
		p:setWorkOffsetY(-4)
	elseif(base == "PLATE5") then  
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(-4)
	elseif(base == "PLATE6") then 
		p:setWorkOffsetX(-3)
		p:setWorkOffsetY(-6)
	elseif(base == "PLATE7") then  
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(-6)
	elseif(base == "PLATE8") then  
		p:setWorkOffsetX(-3)
		p:setWorkOffsetY(-8)
	elseif(base == "PLATE9") then  
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(-8)
	elseif(base == "PLATE10") then  
		p:setWorkOffsetX(-3)
		p:setWorkOffsetY(-10)
	elseif(base == "PLATE11") then  
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(-10)
	elseif(base == "PLATE12") then  
		p:setWorkOffsetX(-3)
		p:setWorkOffsetY(-12)
	elseif(base == "PLATE13") then  
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(-12)
	elseif(base == "PLATE14") then  
		p:setWorkOffsetX(-3)
		p:setWorkOffsetY(-14)
	elseif(base == "PLATE15") then
		p:setWorkOffsetX(4)	
		p:setWorkOffsetY(-14)
	end
end

function restaurant0:onRemoveProductFromTray(product)
	if (product == "KEY_1" or product == "KEY_2" or product == "KEY_3" or
		product == "ENVELOP" or product == "MAIL") then
		
		getProduct(product):setVisible(true)
		if (getProduct(product):isStockProduct()) then
			getProduct(product):incStock(1)
		end
		
	end
end


-- set restaurant
restaurant = restaurant0()