-- These products grow on trees and must fly to their basket when
-- clicked on the tree. The flying to the basket is done in C++
-- (Appliance::OnReceiveProduct()).

class 'treeFruitProduct' (Product)

treeFruitProduct.basketName = "APPLE"

function treeFruitProduct:__init(root) super(root)
	if (type(root) == "userdata") then
		self.basketName = root.basketName
	
	end	

end

function treeFruitProduct:onReceiveComplete()
	-- fruit arrived at the basket:
	local basketProduct = getProduct(self.basketName)
	basketProduct:incStock()

	Product.onReceiveComplete(self)
	self:setDestroyed(true)

end

function treeFruitProduct:setBasketProductName(name)
	self.basketName = name

end