class 'rest4_ovenProduct' (Product)

rest4_ovenProduct.timer1 = 0
rest4_ovenProduct.timerSuspended = false
rest4_ovenProduct.busy = false

function rest4_ovenProduct:__init(root) super(root)

	if (type(root) == "userdata") then
		self.timer1 = root.timer1
		self.timerSuspended = root.timerSuspended
		self.busy = root.busy
	end	
end

function rest4_ovenProduct:onReceiveComplete()

	if (self:getState() == "READY") then
		getProduct(self:getBase() .. "_READY"):setStock(getProduct(self:getBase() .. "_READY"):getMaxStock())
		self:emptyCakemold()
--		cout("rest4_ovenProduct:onReceiveComplete2()\n")		

		-- check trophy '500 grill procucts made'
		tm:checkGrillProductsMade(1)
	else
		-- pie in mold arrived at the oven: start baking:
		self:setState("BAKING")
		
		Product.onReceiveComplete(self)
	end	
end

function rest4_ovenProduct:onTick(time)
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end

	if (self.timerSuspended == false) then
	
		if (self:getState() == "BURNING") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("BURNED")
			end	
		
		elseif (self:getState() == "READY") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("BURNING")
			end	
				
		elseif (self:getState() == "BAKING") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("READY")
				self:blink(1, 0, 3)
			end
		end		
	end
	
	Product.onTick(self, time)

end

function rest4_ovenProduct:onStateEnter(state)

	if (state == "BAKING") then
		self:animate("PROD_BUT_" .. self:getBase(), 0)
		self:setClickable(false)
		self.timer1 = 1500
		self:playSound("SOUND_FIREPLACE_LOOP_OLD", true)
		
	elseif (state == "READY") then
		self:animate("PROD_BUT_" .. self:getBase() .. "_READY", 0)
		self:playSound("SOUND_FRYER_READY")
		self:setClickable(true)
		self.timer1 = 5000
	
	elseif (state == "BURNING") then
		self:playSound("SOUND_BURGER_EGG_BURNS")
		self:setClickable(false)
		self:clearOverhead()
		self.timer1 = 2000
		-- Play burn animation
		self:animate("ANIM_" .. self:getBase() .. "_BURN", 1, 9)
		self:setY(self:getY() - 19)

	elseif (state == "BURNED") then
		self:resetCakemold()
		self:emptyCakemold()
		self:setY(self:getY() + 19)
	
	elseif (state == "FINISH") then
		self:resetCakemold()

	end

	Product.onStateEnter(self, state)

end

function rest4_ovenProduct:onClick()
	if (self:getState() == "READY") then
		if (not self.busy) then	
			self.timerSuspended = true
			self.busy = true
			Product.onClick(self)
		end
	end	
end

function rest4_ovenProduct:onWorkStart(task)

	if (self:getState() == "READY") then
		-- move the product to the stock if there's room on the stock
		bakeNeeded = getProduct(self:getBase() .. "_READY"):getMaxStock() - getProduct(self:getBase() .. "_READY"):getStock()
		
		if (bakeNeeded > 0) then
			task:setDuration(self:getWorkTime())
			task:getPerson():animate(self:getWorkAnimation(), -1, false, -1)
			self:stopSound("SOUND_FIREPLACE_LOOP_OLD")
			self:setClickable(false)				
			return true
		else
			self.timerSuspended = false
		end	
	end
	
	return false
	
end

function rest4_ovenProduct:onWorkComplete(task)
	if (self:getState() == "READY") then
	
		self:setDestroyed(true)
		self:moveToAppliance(getAppliance("rest4_oven_front"))		
		-- changing the state of the waffle here makes sure we can't spam click
		-- it and add multiple waffles to our stack as future tasks won't start
		-- because it's not in the appropriate state
		self:setState("FLYING")			
	end
	self.busy = false
end

function rest4_ovenProduct:resetCakemold()

	self:stopSound("SOUND_FIREPLACE_LOOP_OLD")
	self.timer1 = 0

end

function rest4_ovenProduct:emptyCakemold()
	self:setDestroyed(true)
end