class 'rest2_grillProduct' (Product)

rest2_grillProduct.timer1 = 0
rest2_grillProduct.timerSuspended = false
rest2_grillProduct.busy = false
rest2_grillProduct.soundReady = "SOUND_FRYER_READY"
rest2_grillProduct.soundBurn = "SOUND_BURGER_EGG_BURNS"

function rest2_grillProduct:__init(root) super(root)

	if (type(root) == "userdata") then
		self.timer1 = root.timer1
		self.timerSuspended = root.timerSuspended
		self.busy = root.busy
	end	
end

function rest2_grillProduct:onReceiveComplete()

	-- pie in mold arrived at the oven: start baking:
	self:setState("BAKING")
	
	Product.onReceiveComplete(self)
end

function rest2_grillProduct:onTick(time)
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end

	if (self.timerSuspended == false) then
	
		if (self:getState() == "BURNING") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("BURNED")
			end	
		
		elseif (self:getState() == "READY") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("BURNING")
			end	
				
		elseif (self:getState() == "BAKING") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("READY")
				self:blink(1, 0, 3)
			end

		end
		
	end
	
	Product.onTick(self, time)

end

function rest2_grillProduct:onStateEnter(state)

	if (state == "BAKING") then
		self:animate("PROD_BUT_" .. self:getBase() .. "_RAW", 0)
		self:setClickable(false)
		self.timer1 = 1500
		self:playSound("SOUND_FIREPLACE_LOOP_OLD", true)
		
	elseif (state == "READY") then
		self:animate("PROD_BUT_" .. self:getBase() .. "_READY", 0)
		self:playSound(self.soundReady)
		
		hm:placeArrow(getArrowIndex("ARROW_HINT_SPIES_READY"), self, 15, 15)
		
		self:setClickable(true)
		self.timer1 = 5000
	
	elseif (state == "BURNING") then
		self:setClickable(false)
		self:clearOverhead()
		self.timer1 = 2000
		-- Play burn animation
		self:animate("ANIM_GRILL_BURN", 1, 9)
		self:playSound(self.soundBurn)
		self:setY(self:getY() - 19)

	elseif (state == "BURNED") then
		self:resetCakemold()
		self:emptyCakemold()
		self:setY(self:getY() + 19)
	
	elseif (state == "FINISH") then
		self:resetCakemold()

	end

	Product.onStateEnter(self, state)

end

function rest2_grillProduct:onClick()

	self.timerSuspended = true
	if (self:getState() == "READY") then
		self.timerSuspended = true		
		if (self:isQueuableToTray()) then
			if (not self.busy) then		
				self:queue()	
				self.busy = true;			
				Product.onClick(self)					
			end
		end
	else
		Product.onClick(self)
	end
	
end

function rest2_grillProduct:onWorkStart(task)

	if (self:getState() == "READY") then
		if (self:isQueuedOnTray()) then
    		self:resetCakemold()
			Product.onWorkStart(self, task)		
			return true		
		else
			self.busy = false
			tray:clearInvisible()
			self.timerSuspended = false
			return false
		end
	end
	
	return false
	
end

function rest2_grillProduct:onWorkComplete(task)
	if (self:getState() == "READY") then
		Product.onWorkComplete(self, task)
		self:moveToTray()
		self:setDestroyed(true)
		
		-- check trophy '500 grill procucts made'
		tm:checkGrillProductsMade(1)
	end
	self.busy = false
end

function rest2_grillProduct:resetCakemold()

	self:stopSound("SOUND_FIREPLACE_LOOP_OLD")
	self.timer1 = 0

end

function rest2_grillProduct:emptyCakemold()
	self:setDestroyed(true)
end