--
-- this is a regular Product
-- it is useable for:
-- * simple products like CHIPS, COFFEE
-- * simple stock products 
-- * simple compound products like BUNBOTTOM, LETTUCE, 
-- * simple compound stock products like WAFFLE
--
-- it can be configured by
-- * setWorkTime
-- * setWorkAnimation
-- * setWorkSound
-- * setWorkSoundLooping
-- * setWorkOffsetX
-- * setWorkOffsetY
-- * setStock
-- * setMaxStock

class 'regularProduct' (Product)

function regularProduct:__init(baseName) super(baseName)
end

function regularProduct:onClick()
	
	if (self:isIngredient()) then
		if (self:isQueuableToTray()) then
			self:queue()
			Product.onClick(self)
		
		end
		
	else
		if (self:isQueuableToTray()) then
			self:queue()
		
		end
		
		Product.onClick(self)
		
	end

end

function regularProduct:onWorkStart(task)

	if (self:isStockProduct() and (self:getStock() == 0)) then
		self:playSound("SOUND_NO_STOCK")
		self:unQueue()
		return false		
	
	elseif (self:isQueuedOnTray()) then
		if (self:isIngredient()) then
			if (self:isMovableToBubble()) then
				self:moveToBubble()
				
			else
				self:unQueue()
				return false
			
			end	
		end
		
		Product.onWorkStart(self, task)		
		
		return true		
	
	else
		tray:clearInvisible()
	
	end
	
	return false

end

function regularProduct:onWorkComplete(task)

	Product.onWorkComplete(self, task)

	if (not self:isIngredient()) then
		if (self:isStockProduct()) then
			self:decStock()
		
		end
			
		self:moveToTray()
	
	end

end

-- this event is only raised if it's an ingredient
-- of a compound product
function regularProduct:onBubbleCancel()
	
	self:unQueue()

end

-- this event is only raised if it's an ingredient
-- of a compound product
function regularProduct:onBubbleMerged()

	if (self:isIngredient()) then
		if (self:isStockProduct()) then
			self:decStock(1)	
		end
	end

end
