class 'oventurkeyproduct' (Product)

oventurkeyproduct.timer1 = 0
oventurkeyproduct.timerSuspended = false
oventurkeyproduct.slot = nil
oventurkeyproduct.blinking = false

function oventurkeyproduct:__init(root) super(root)
	
	if (type(root) == "userdata") then
		-- called constructor (const Product&)
		-- this is the copy constructor
		-- copy over all lua values
		self.timer = root.timer
		self.timerSuspended = root.timerSuspended
		self.busy = root.busy
		self.slot = getAppliance("rest0_oven"):getSlot(0)

		local baster = getProduct("BASTER")
		if (baster ~= nil) then
			baster.turkey = self
		end
	end		
end

function oventurkeyproduct:onCreate()
	self:setState("RAW")
end

function oventurkeyproduct:onClick()

    if (self:getState() == "RAW") then
			Product.onClick(self)	
			self:unQueue()
			
    elseif (self:getState() == "READY") then
        if (not self.busy) then
            self.timerSuspended = true
            self.busy = true
	        Product.onClick(self)	    
			self:unQueue()
                
        end    
    end	

end

--
-- called when the product enters a new state
function oventurkeyproduct:onStateEnter(state)
	
	if (self:getState() == "RAW") then
		self:setWorkAnimation("WORK_BACK")
	elseif (self:getState() == "BAKING1" or self:getState() == "BAKING2") then
	
		if (self:getState() == "BAKING1") then
			self:animate("PROD_BUT_" .. self:getBase() .. "_BAKED", 0)
		else 
			self:animate("PROD_BUT_" .. self:getBase() .. "_2_BAKED", 0)		
		end

		self:playSound("SOUND_SKILLETING_LOOP", true)
		self.timer = 8000
		self.timerSuspended = false
		self.slot:setCurrentFrame(1)
		self:setVisible(false)
		self:setClickable(false)
		self:clearOverhead()

	elseif (self:getState() == "BASTER1" or self:getState() == "BASTER2") then
		self:blink()
		--self:playSound("SOUND_SKILLETING_LOOP", true)
		self:stopSound("SOUND_SKILLETING_LOOP")
		self:playSound("SOUND_FRYER_READY")
		self.timer = 10000
		self.timerSuspended = false
		self.slot:setCurrentFrame(0)
		self:setVisible(true)
		self:setOverheadX(15)
		self:createOverhead("INGAME_BASTE_CHICKEN", "ingame")
		if (self:getState() == "BASTER1") then
			hm:placeArrow(getArrowIndex("ARROW_HINT_TURKEY_BASTER_1"), getProduct("BASTER"), 15, 15)
		else
			hm:placeArrow(getArrowIndex("ARROW_HINT_TURKEY_BASTER_2"), getProduct("BASTER"), 15, 15)
		end
		
	elseif (self:getState() == "READY") then
		self:blink()
		self:animate("PROD_BUT_" .. self:getBase() .. "_READY", 0)
		--self:stopSound("SOUND_SKILLETING_LOOP")
		self:playSound("SOUND_FRYER_READY")		
		self:setWorkTime(200)
		self:setWorkAnimation("WORK_BACK")
		self.timer = 10000
		self.timerSuspended = false
		self:setVisible(true)
		self:setClickable(true)
		self:clearOverhead()
		
		hm:placeArrow(getArrowIndex("ARROW_HINT_TURKEY_FINISHED"), self, 20, 0)
		
	elseif (self:getState() == "BURNING") then
		self:setClickable(false)
		self:clearOverhead()
		self:animate("PROD_BUT_" .. self:getBase(), 0) -- Temp
		--self:stopSound("SOUND_SKILLETING_LOOP")
		self:playSound("SOUND_BURGER_EGG_BURNS")
		self:animate("PROD_ANIM_" .. self:getBase() .. "_BURN", 1, 18)
		self:setY(self:getY() - 19)
		self.timer = 1000
		self.timerSuspended = false
		self:clearOverhead()		
	end
end

--
-- called when the product is completely received by an iProductReceiver
function oventurkeyproduct:onReceiveComplete()
	if (self:getState() == "RAW") then
		self:setState("BAKING1")

	elseif (self:getState() == "READY") then
		local stockInc = 6
		local basketProduct = getProduct("TURKEY_PART")
		basketProduct:incStock(stockInc)
		Product.onReceiveComplete(self)
		self:setDestroyed(true)

		-- check trophy '500 grill procucts made'
		tm:checkGrillProductsMade(stockInc)
	end	
end

--
-- called when the worker starts to work on this product
function oventurkeyproduct:onWorkStart(task)

	if (self:isDestroyed()) then
		warn("oventurkeyproduct:onWorkStart - is destroyed")
		return false
		
	elseif (self:getState() == "RAW") then
		if (getAppliance("rest0_oven"):hasSlotsOpen()) then
			return Product.onWorkStart(self, task)
			
		else
			return false
				
		end
	elseif (self:getState() == "READY") then
		cout("oventurkeyproduct:onWorkStart: READY")
		return Product.onWorkStart(self, task)
	end

	warn("oventurkeyproduct:onWorkStart - invalid state: " .. self:getState())
	return false	
	
end

-- called when a person completed work on a product
function oventurkeyproduct:onWorkComplete(task)
	if (self:getState() == "RAW") then
		self:moveToAppliance(getAppliance("rest0_oven"))
		
	elseif (self:getState() == "READY") then
		self:moveToAppliance(getAppliance("rest0_buffet"))
		self:setDestroyed(true)
		self.slot:setCurrentFrame(0)

	end
	
	self.busy = false
end


-- called each tick
-- useful for timers
function oventurkeyproduct:onTick(time)

	if (not scene:isStartingMovie() and not scene:isPlayingMovie()) then
		if (not self.timerSuspended) then
			if (self:getState() == "BAKING1") then
				self.timer = self.timer - time
				if (self.timer <= 0) then
					self:setState("BASTER1")				
				end
			elseif (self:getState() == "BAKING2") then
				self.timer = self.timer - time
				if (self.timer <= 0) then
					self:setState("BASTER2")				
				end
			
			elseif (self:getState() == "BASTER1" or self:getState() == "BASTER2") then
				self.timer = self.timer - time
				if (self.timer <= 1000 and self.blinking == false) then
					self.blinking = true
					self:getOverhead():blink(10)
				elseif (self.timer <= 0) then
					self:getOverhead():removeModifiers()
					self:getOverhead():setAlpha(1.0)
					self.blinking = false
					self:clearOverhead()
					self:setState("BURNING")
				end										
			elseif (self:getState() == "READY") then
				self.timer = self.timer - time
				if (self.timer <= 0) then
					self:setState("BURNING")
				end	
			end	
		end
	end
	
	if (not self.timerSuspended) then
		if (self:getState() == "BURNING") then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.slot:setCurrentFrame(0)
				self:setY(self:getY() + 19)
				self:setDestroyed(true)
				self:setVisible(false)
				
			end	
		end
	end

end
