class 'getmailproduct' (Product)

getmailproduct.movingToTray = false

function getmailproduct:__init(root) super(root)

end

function getmailproduct:onClick()
	if (not self.movingToTray and self:isQueuableToTray()) then
		self:queue(false)
		self.movingToTray = true
	end	
	Product.onClick(self)
end

function getmailproduct:onWorkStart(task)
	if (self:isStockProduct() and (self:getStock() == 0)) then
		self:playSound("SOUND_NO_STOCK")
		self:unQueue()
	elseif (self:isQueuedOnTray()) then		
		Product.onWorkStart(self, task)			
		return true			
	else
		tray:clearInvisible()	
	end

	self.movingToTray = false
	return false
end

function getmailproduct:onWorkComplete(task)
	Product.onWorkComplete(self, task)
	restaurant:onNotify("trigger mailGetHint")
	self:setVisible(false)
	self.movingToTray = false
	self:moveToTray()
end
