class 'getkeyproduct' (Product)

function getkeyproduct:__init(root) super(root)

end

function getkeyproduct:onClick()
	if (self:isQueuableToTray()) then
		self:queue(false)    
	end    
	Product.onClick(self)
end

function getkeyproduct:onWorkStart(task)
	if (self:isStockProduct() and (self:getStock() == 0)) then
		self:playSound("SOUND_NO_STOCK")
		self:unQueue()
		return false		
	elseif (self:isQueuedOnTray()) then
		Product.onWorkStart(self, task)		
		return true		
	else
		tray:clearInvisible()
	end
	return false	
end

function getkeyproduct:onWorkComplete(task)
	Product.onWorkComplete(self, task)

	restaurant:onNotify("trigger keyGetHint")

	self:decStock()
	self:moveToTray()
	if (self:getStock() == 0) then
		self:setVisible(false)
	end
end

