class 'fruitProduct' (regularProduct)

fruitProduct.workList = {}

function fruitProduct:__init(baseName) super(baseName)
end

function fruitProduct:onClick()
	
	if (getProduct("CAKEMOLD") and getProduct("CAKEMOLD"):isQueuedLast()) then
		local combine = true
		if (getProduct("CHERRY")) then
			if (getProduct("CHERRY"):isQueuedLast()) then
				combine = false
			end		
		end
		if (getProduct("APPLE")) then
			if (getProduct("APPLE"):isQueuedLast()) then
				combine = false
			end		
		end
	
		if (combine) then
			-- combine with cakemold
			-- so queue
			table.insert(self.workList, 1)
			self:queue()
			Product.onClick(self)
			return
			
		end		
	end
	
	if (getProduct("JAM") and getProduct("JAM"):isQueuedLast()) then
		local combine = true
		if (getProduct("CHERRY")) then
			if (getProduct("CHERRY"):isQueuedLast()) then
				combine = false
			end		
		end
		if (getProduct("APPLE")) then
			if (getProduct("APPLE"):isQueuedLast()) then
				combine = false
			end		
		end	
	
		if (combine) then
			-- combine with jam
			-- so queue
			table.insert(self.workList, 2)
			self:queue()
			Product.onClick(self)
			return
			
		end		
	end

	-- normal fruit
	table.insert(self.workList, 3)
	self:queue()
	Product.onClick(self)
		
end

function fruitProduct:onWorkStart(task)

	if (self.workList[1] == nil) then
		warn("fruitProduct:onWorkStart - invalid queue")
		return false
	end
	
	local tag = self.workList[1]

	if (tag == 1) then
		-- cakemold
		if (self:isMovableToBubble()) then
			if (self:getStock() >= 3) then
				Product.onWorkStart(self, task)
				self:moveToBubble()
				self:setTag(1)
				return true
				
			else
				createFloater(getText("NOT_ENOUGH_FRUIT"), self:getScreenX(), self:getScreenY(), 500)
				self:playSound("SOUND_NO_STOCK")
				self:unQueue()
				destroyBubble()
			
			end
		else
            self:unQueue()
		
		end
	
	elseif (tag == 2) then
		-- jam
		if (self:isQueuedOnTray()) then
			if (self:getStock() >= 2) then
				if (self:isMovableToBubble()) then			
					Product.onWorkStart(self, task)
					self:moveToBubble()
					self:setTag(2)
					return true
				
				else
					self:unQueue()
					
				end		
			else
				createFloater(getText("NOT_ENOUGH_FRUIT"), self:getScreenX(), self:getScreenY(), 500)
				self:playSound("SOUND_NO_STOCK")
				self:unQueue()
				destroyBubble()
				
			end		
		
		else
			self:unQueue()
			
		end
	
	elseif (tag == 3) then
		-- regular
		if (self:isQueuedOnTray()) then
			if (self:getStock() >= 1) then
				Product.onWorkStart(self, task)
				self:setTag(3)
				return true
			
			else
				self:playSound("SOUND_NO_STOCK")
				self:unQueue()
				
			end				
		else
			self:unQueue()
			
		end	
	else
		warn("fruitProduct:onWorkStart - invalid tag")
	
	end

	-- task got cancelled
	-- remove first
	table.remove(self.workList, 1)
	return false

end

function fruitProduct:onWorkComplete(task)

	if (self.workList[1] == nil) then
		warn("fruitProduct:onWorkComplete - invalid queue")
	end

	local tag = self.workList[1]

	Product.onWorkComplete(self, task)

	if (tag == 0) then
		warn("fruitProduct:onWorkComplete - invalid tag")

	elseif (tag == 1) then
		-- cakemold
		self:unQueue()
		self:decStock(3)
		
	elseif (tag == 2) then
		-- jam
		self:decStock(2)
		
	elseif (tag == 3) then
		-- regular
		self:moveToTray()	
		self:decStock()
	
	end
	
	-- task completed
	-- remove first
	table.remove(self.workList, 1)	

end

function fruitProduct:onBubbleCancel()
end

function fruitProduct:onBubbleMerged()
end
