
class 'firewoodProduct' (Product)

firewoodProduct.applianceName = nil

function firewoodProduct:__init(baseName) super(baseName)
end

function firewoodProduct:onClick()
	local fireplace = getAppliance(self.applianceName)
	if (fireplace ~= nil) then
		Product.onClick(self)
	end
end

function firewoodProduct:onWorkStart(task)
	local fireplace = getAppliance(self.applianceName)
	if (fireplace ~= nil) then
		if (fireplace:isRaging()) then
			return false
		end
		self:setWorkTime(fireplace:getWorkTime())
		fireplace:onWorkStart(task)
	end
	Product.onWorkStart(self, task)
	return true
end

function firewoodProduct:onWorkComplete(task)
	
	local fireplace = getAppliance(self.applianceName)
	if (fireplace ~= nil) then
		fireplace:onWorkComplete(task)
		--fireplace:setState("RAGING")
	end
	Product.onWorkComplete(self, task)
	
end

function firewoodProduct:setApplianceName(name)
	self.applianceName = name
end