include("scripts/products/grillproduct.lua")

class 'chestnutProduct' (grillProduct)

chestnutProduct.timeToOpen = 1000
chestnutProduct.framesToOpen = 11
chestnutProduct.opening = false

chestnutProduct.slot = nil

function chestnutProduct:__init(root) super(root)

	-- C++ product has two constructor:
	-- a const std::string& which is the baseName of the product
	-- a const Product& which is the copy constructor
	-- 
	-- in this Lua constructor, we need to do explicit type checking
	-- on the 'root' parameter (which, as said, can be either a 
	-- string or a source product), so we know when the copy 
	-- constructor gets called. if the copy constructor is called
	-- all lua variables need to be copied over as well

	if (type(root) == "userdata") then
		-- called constructor (const Product&)
		-- this is the copy constructor
		-- copy over all lua values
		self.timer = root.timer
		self.timerSuspended = root.timerSuspended
		self.busy = root.busy
		self.appliance = root.appliance
		self.slot = root.slot
	end	
end

function chestnutProduct:onClick()	
    if (self:getState() == "RAW") then
        self.timerSuspended = true
		Product.onClick(self)	
    elseif (self:getState() == "READY") then
		self.timerSuspended = true		
		if (self:isQueuableToTray()) then
			if (not self.busy) then		
				self.busy = true;			
				Product.onClick(self)					
			end
		end
	end		
end

--
-- called when the worker starts to work on this product
function chestnutProduct:onWorkStart(task)

	if (self:isDestroyed()) then
		warn("grillProduct:onWorkStart - is destroyed")
		return false
		
	elseif (self:getState() == "RAW") then
        self.timerSuspended = false
		if (getAppliance(self.appliance):hasSlotsOpen()) then
			return Product.onWorkStart(self, task)
		else
			return false
		end
	elseif (self:getState() == "READY") then
		cout("self:getWorkTime = " .. self:getWorkTime() .. "\n")
		cout("name = " .. self:getName() .. "\n")
		cout("workanim = " .. self:getWorkAnimation() .. "\n")
		self:setWorkTime(1000)
		Product.onWorkStart(self, task)
		return true		
	end

	warn("chestnutProduct:onWorkStart - invalid state: " .. self:getState())
	return false	
	
end

function chestnutProduct:onStateEnter(state)

	-- cout("on state enter.  state is " .. state .. "\n")
	if (self:getState() == "RAW") then
		self:setWorkAnimation("WORK_BACK")
		self:animate("PROD_BUT_" .. self:getBase() .. "_RAW", 0)
	
	elseif (self:getState() == "BAKING") then

		self:setClickable(false)
		self:playSound("SOUND_SKILLETING_LOOP", true)
		self.timer = 3300
		self.timerSuspended = false
	
	elseif (self:getState() == "READY") then
		self:blink()
		self:setClickable(true)
		self:animate("PROD_BUT_" .. self:getBase(), 0)
		self:stopSound("SOUND_SKILLETING_LOOP")
		self:playSound("SOUND_CHESTNUT_POPS_OPEN")		
--		self:setWorkTime(0)
--		self:setWorkAnimation("WORK_LEFT")	-- BP test
		self.timer = 6000
		self.timerSuspended = false
		
		--hm:openHint(getHintIndex("HINT_KEBAB_FINISHED"), self:getScreenX() + (self:getWidth() / 2), self:getScreenY())
		
	elseif (self:getState() == "BURNING") then
		self:setClickable(false)
		self:clearOverhead()
		self:animate("ANIM_CHESTNUT_BURN", 1, false, 18, true)
		self:playSound("SOUND_BURGER_EGG_BURNS")
		self:setY(self:getY() - 19)
		self.timer = 1000
		self.timerSuspended = false
		
		local app = getAppliance(self.appliance)
		if (app ~= nil) then
			app:stopSlotBaking(self.slot)
		end	
		
	end
end

function chestnutProduct:onTick(time)

	if (not scene:isStartingMovie() and not scene:isPlayingMovie()) then
		if (not self.timerSuspended) then
			if (self:getState() == "BAKING") then
				self.timer = self.timer - time
				if (not self.opening and self.timer <= self.timeToOpen) then
					self:animate("ANIM_CHESTNUT_OPENING", 1, false, self.framesToOpen, true)
					self.opening = true
					
				elseif (self.timer <= 0) then
					self:setState("READY")				
				end
					
			elseif (self:getState() == "READY") then
				self.timer = self.timer - time
				if (self.timer <= 0) then
					self:setState("BURNING")
				end	
			end	
		end
	end
	
	if (not self.timerSuspended) then
		if (self:getState() == "BURNING") then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self:setY(self:getY() + 19)
				self:setDestroyed(true)
				self:setVisible(false)
				
			end	
		end
	end

end

function chestnutProduct:onWorkComplete(task)
	
	if (self:getState() == "READY") then
		local stockInc = 2
		local app = getAppliance(self.appliance)
		if (app ~= nil) then
			Product.onWorkComplete(self, task)
			app:stopSlotBaking(self.slot)
			getProduct("STOCKED_CHESTNUT"):incStock(stockInc)
			self:setDestroyed(true)
			self.busy = false
		end

		-- check trophy '500 grill procucts made'
		tm:checkGrillProductsMade(stockInc)
	else
		grillProduct.onWorkComplete(self, task)
	end
end

function chestnutProduct:onSlotEnter(slot)
	self.slot = slot
	local app = getAppliance(self.appliance)
	if (app ~= nil) then
		app:startSlotBaking(self.slot)
	end	
end

