class 'basterproduct' (Product)

basterproduct.turkey = nil

function basterproduct:__init(root) super(root)
end

function basterproduct:onClick()	
	if (self:isSelected() == false) then		
		Product.onClick(self)	
		self:unQueue()
		self:setSelected(true)
		
		if (self.turkey == nil) then
			return
		end

		if (self.turkey:getState() == "BASTER1" or self.turkey:getState() == "BASTER2") then
			self.turkey.timerSuspended = true
		end
	end
end

--
-- called when the worker starts to work on this product
function basterproduct:onWorkStart(task)
	self:setSelected(false)

	if (self.turkey == nil) then
		return false
	end

	if (self.turkey:getState() == "BASTER1" or self.turkey:getState() == "BASTER2") then
		return Product.onWorkStart(self, task)
	end

	return false		
end

-- called when a person completed work on a product
function basterproduct:onWorkComplete(task)

	if (self.turkey == nil) then
		return
	end

	if (self.turkey:getState() == "BASTER1") then
		self.turkey:setState("BAKING2")
	elseif (self.turkey:getState() == "BASTER2") then
		self.turkey:setState("READY")
	else
		warn("basterproduct:onWorkComplete - invalid state: " .. self:getState())
	end
end
