-- global help values
wandererCounts =
{
	0,
	0,
	0,
	0,
	0,
	0,
}
wandererPoints =
{
	{{33, 15}, {37, 16}},
	{{41, 22}, {47, 26}},
	{{17, 26}, {20, 26}},
	{{11, 18}, { 7, 18}},
	{{ 3, 28}, { 6, 28}},
	{{27, 19}, {23, 20}},
}
wandererTimes =
{
	{3000, 6000},
	{3000, 6000},
	{3000, 6000},
	{3000, 6000},
	{3000, 6000},
	{3000, 6000},
}
wandererDirection =
{
	"UP",
	"RIGHT",
	"DOWN",
	"UP",
	"RIGHT",
	"LEFT",
}
wandererPersons =
{
}
wandererPersonsCount = 0
wandererId = 0

-- class
class 'wanderer' (fakecustomer)

wanderer.location = -1
wanderer.state = "dead"
wanderer.exitChance = 0
wanderer.exitChanceStep = 5
wanderer.targetX = -1
wanderer.targetY = -1
wanderer.timer = 0
wanderer.id = -1
wanderer.buddy = nil
wanderer.elderly = false
wanderer.appliance = "rest1_karaoke"
wanderer.singing = false
wanderer.workAnimEmily = "WORK_UP"
wanderer.workSoundEmily = "SOUND_EMILY_CLAPPING"

wanderer.waitTimeSuspended = false
wanderer.waitTimer = 0
wanderer.bowTime = 10 * 1000
wanderer.perBowTime = 2 * 1000
wanderer.bowAnimTimer = 0
wanderer.applauseTime = 2 * 1000

function wanderer:__init(baseName) super(baseName)
end

function wanderer:onCreate()

	fakecustomer.onCreate(self)
	self:register()
	--self.elderly = self.elderly or (self:getBaseName() == "INGAME_CUSTOMER_FEMALE_ELDERLY")
	--self.elderly = self.elderly or (self:getBaseName() == "INGAME_CUSTOMER_MALE_ELDERLY")

end

function wanderer:onPlace()

	self:createBuddy()
	self:walkAgain()
	
end

function wanderer:createBuddy()

	local baseNames = nil
	if (self:getBaseName() == "INGAME_CUSTOMER_FEMALE_WINTER_ELDERLY") then
		baseNames =
		{
			"INGAME_CUSTOMER_MALE_WINTER_ELDERLY",
			"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",
			"INGAME_CUSTOMER_MALE_WINTER_CHILD",			
		}
	
	elseif (self:getBaseName() == "INGAME_CUSTOMER_MALE_WINTER_ELDERLY") then
		baseNames =
		{
			"INGAME_CUSTOMER_FEMALE_WINTER_ELDERLY",
			"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",
			"INGAME_CUSTOMER_MALE_WINTER_CHILD",			
		}	
	
	elseif (self:getBaseName() == "INGAME_CUSTOMER_FEMALE_WINTER_CHILD") then
		baseNames =
		{
			"INGAME_CUSTOMER_FEMALE_WINTER_ELDERLY",
			"INGAME_CUSTOMER_MALE_WINTER_ELDERLY",
			"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",
			"INGAME_CUSTOMER_MALE_WINTER_CHILD",	
			"INGAME_CUSTOMER_FEMALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_MALE_WINTER_REGULAR",					
		}		
	
	elseif (self:getBaseName() == "INGAME_CUSTOMER_MALE_WINTER_CHILD") then
		baseNames =
		{
			"INGAME_CUSTOMER_FEMALE_WINTER_ELDERLY",
			"INGAME_CUSTOMER_MALE_WINTER_ELDERLY",
			"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",
			"INGAME_CUSTOMER_MALE_WINTER_CHILD",	
			"INGAME_CUSTOMER_FEMALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_MALE_WINTER_REGULAR",					
		}	
	
	elseif (self:getBaseName() == "INGAME_CUSTOMER_FEMALE_WINTER_REGULAR") then
		baseNames =
		{
			"INGAME_CUSTOMER_MALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",
			"INGAME_CUSTOMER_MALE_WINTER_CHILD",			
		}		
	
	elseif (self:getBaseName() == "INGAME_CUSTOMER_MALE_WINTER_REGULAR") then
		baseNames =
		{
			"INGAME_CUSTOMER_FEMALE_WINTER_REGULAR",
			"INGAME_CUSTOMER_FEMALE_WINTER_CHILD",
			"INGAME_CUSTOMER_MALE_WINTER_CHILD",			
		}			
	
	end
	
	if (getRandom(100) < 50) then
		self.buddy = pm:createPerson("npc")
		self.buddy:setBaseName(baseNames[getRandom(table.getn(baseNames)) + 1])
		self.buddy:setDefaultSection(self:getDefaultSection())
		self.buddy:setVisible(false)
		self.buddy:animate("IDLE", 0)
		self.buddy:setPosition(self:getPosition())
		self.buddy:qWait(300)
		self.buddy:qSetVisible(true)
	
	end

end

function wanderer:register()

	wandererId = wandererId + 1
	self.id = wandererId
	
	wandererPersons[wandererId] = self
	wandererPersonsCount = wandererPersonsCount + 1

end

function wanderer:unregister()

	wandererPersons[self.id] = nil
	wandererPersonsCount = wandererPersonsCount - 1

end

function wanderer:onTick(time)

	if (dayEnded) then
		return
		
	end

	if (self.state == "walking to exit") then
		if (self:getPosition():getGridX() == self.targetX) then
			if (self:getPosition():getGridY() == self.targetY) then
				self.targetX = -1
				self.targetY = -1
				self:unregister()
				self:setVisible(false)
				self:qDestroy()
			end
		end
	
	elseif (self.state  == "walking to location") then
		if (self:getPosition():getGridX() == self.targetX) then
			if (self:getPosition():getGridY() == self.targetY) then
				self.targetX = -1
				self.targetY = -1
				self.timer = getRandomRange(wandererTimes[self.location][1], wandererTimes[self.location][2])
				self.state = "waiting at location"
			
			end
		end	
	end
	
	if (scene:isPlayingMovie()) then
		return
	
	end
	
	if (scene:isStartingMovie()) then
		return
		
	end
	
	if (self.state == "waiting at location") then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self:walkAgain()
			
			end
		end
	elseif (self.state == "bowing") then
		self.bowAnimTimer = self.bowAnimTimer - time
		if (not self.waitTimeSuspended) then
			self.waitTimer = self.waitTimer - time
		end
		if (self.waitTimer <= 0) then
			self.waitTimeSuspended = true
			self:leaveStage()
		elseif (self.bowAnimTimer <= 0) then
			self:animate("BOW", 1)
			self.bowAnimTimer = self.perBowTime
		end
	end

end

function wanderer:walkAgain()

	local karaokeAppliance = getAppliance("rest1_karaoke")
		
    if (karaokeAppliance and karaokeAppliance:needsNext()) then
        karaokeAppliance:queueNext(self)    
    
	elseif (location == -1) then
		self:walkToLocation()
		
	else
		-- increase exit chance
		self.exitChance = self.exitChance + self.exitChanceStep
		
		-- see if we're leaving
		local exit = false
		if (self.exitChance >= 15) then
			if (getRandom(100) < self.exitChance) then
				exit = true
			
			end		
		end	

		
		-- walk
		if (exit) then
			self:walkToExit()
		
		else
			self:walkToLocation()
		
		end
	end

end

function wanderer:walkToExit()

	-- decrease weight of current point
	if (self.location ~= -1) then
		wandererCounts[self.location] = wandererCounts[self.location] - 1
		
	end
	
	-- get location of exit
	local gridX = -1
	local gridY = -1
	if (getRandom(2) == 0) then
		gridX = entryX
		gridY = entryY
	
	else
		gridX = exitX
		gridY = exitY
	
	end
	
	-- set state
	self.state = "walking to exit"
	
	-- walk
	self:qWalkToXY(gridX, gridY)
	self.targetX = gridX
	self.targetY = gridY
	
	-- walk buddy
	if (self.buddy) then
		self.buddy:qWalkToXY(gridX, gridY)	
		self.buddy:qSetVisible(false)
		self.buddy:qDestroy()
	
	end	

end

function wanderer:walkToLocation()

	-- decrease weight of current point
	if (self.location ~= -1) then
		wandererCounts[self.location] = wandererCounts[self.location] - 1
		
	end

	-- get index of next point
	self.location = self:getNextLocation(self.location)

	-- increase weight of next point
	wandererCounts[self.location] = wandererCounts[self.location] + 1

	-- set state
	self.state = "walking to location"
	
	-- walk
	local gridX = wandererPoints[self.location][1][1]
	local gridY = wandererPoints[self.location][1][2]
	self:qWalkToXY(gridX, gridY)
    self:qAnimate("IDLE_" .. wandererDirection[self.location], 0)	
	self.targetX = gridX
	self.targetY = gridY	
	
	-- walk buddy
	if (self.buddy) then
		local gridX = wandererPoints[self.location][2][1]
		local gridY = wandererPoints[self.location][2][2]
		self.buddy:qWalkToXY(gridX, gridY)	
		self.buddy:qAnimate("IDLE_" .. wandererDirection[self.location], 0)	
	
	end
	
end

function wanderer:walkToKaraoke()

	local karaokeAppliance = getAppliance(self.appliance)
	if (karaokeAppliance) then
		-- decrease weight of current point
		if (self.location ~= -1) then
			wandererCounts[self.location] = wandererCounts[self.location] - 1
			
		end
	
		self.state = "walking to karaoke"
		self.targetX = -1
		self.targetY = -1
		self.timer = 0
		self.location = -1
		self:qWorkOn(karaokeAppliance)
		
		-- walk buddy
		if (self.buddy) then
			local gridX = 28
			local gridY = 13
			self.buddy:qWalkToXY(gridX, gridY)	
		
		end		
		
	end

end


function wanderer:getNextLocation(ignoreLocation)

	if (ignoreLocation == nil) then
		ignoreLocation = -1
	end

	-- calculate minimum
	local minimum = 100
	for i = 1,table.getn(wandererCounts) do
		if (i ~= ignoreLocation) then
			if (wandererCounts[i] < minimum) then
				minimum = wandererCounts[i]
			
			end
		end	
	end

	-- gather minima
	local minima = {}
	for i = 1,table.getn(wandererCounts) do
		if (i ~= ignoreLocation) then
			if (wandererCounts[i] == minimum) then
				table.insert(minima, i)
		
			end
		end	
	end

	-- get one at random
	local index = getRandom(table.getn(minima)) + 1

	-- return point index
	return minima[index]

end

function wanderer:startSinging()
	self:animate("SING", -1)
	self.singing = true
end

function wanderer:onSingingStopped()
	--self:setClickable(true)
	self.state = "bowing"
	self.waitTimer = self.bowTime
	self.waitTimeSuspended = false
	self.bowAnimTimer = 100
	-- should be "bow" animation
	self:animate("BOW", 1)
	self:createHighlight()
	
	cout("wanderer:onSingingStopped() \n")
	if (gApplauseHintShown ~= true) then
		cout("gApplauseHintShown ~= true \n")
		hm:openHint(getHintIndex("HINT_APPLAUSE"), self:getScreenX(), self:getScreenY() - (self:getHeight() / 2))
		gApplauseHintShown = true
	end
	
	
end

function wanderer:onClick()
	if (self.singing and not self.waitTimeSuspended) then
		emily:qWorkOn(self)
		self.waitTimeSuspended = true
		self:setSelected(true)
	end
end

function wanderer:onWorkStart(task)
	if (self.singing) then
		self:setSelected(false)
		
		-- animate emily
		emily:animate(self.workAnimEmily, -1)
		emily:playSound(self.workSoundEmily, true)
		
		---- time it takes to clap
		task:setDuration(self.applauseTime)
		self.state = "soaking up applause"
		return true
	end
	return false
end

function wanderer:onWorkComplete(task)
	self:animate("IDLE", 0)
	emily:animate("IDLE", 0)
	emily:stopSound(self.workSoundEmily)
	
	day:onNotify("carol_singer_applauded")
	self:leaveStage()
end

function wanderer:leaveStage()
	
	if (self.singing) then
		self.singing = false
		--self:setClickable(false)
		self:walkToExit()
		day:onNotify("carol_singer_left")
		self:removeHighlight()
	end
	
end

function wanderer:getWorkNode()
  
	return grid:getNode(self:getPosition():getGridX(), self:getPosition():getGridY() + 5)
  
end