-- a storyCharacter
class 'storyCharacter' (npc)

-- external variables
storyCharacter.timer = 0
storyCharacter.durationBeforeGo = 15000
storyCharacter.atSpot = false
storyCharacter.destX = 17
storyCharacter.destY = 15
storyCharacter.talkPositionX = 14
storyCharacter.talkPositionY = 15
storyCharacter.extraCharacter = nil
storyCharacter.nextCharacter = nil
storyCharacter.active = false
storyCharacter.charState = "outside"
storyCharacter.sequenceEnd = nil
storyCharacter.sequence = nil
storyCharacter.sequenceExclamation = nil
storyCharacter.optional = true

function storyCharacter:__init(baseName) super(baseName)
end

function storyCharacter:onCreate()
    self:setDefaultSection("characters")
	D2Person.onCreate(self)	
	self:initTimer(10000, 15000)
	self:setVisible(false)
end

function storyCharacter:initTimer(rangeMin, rangeMax)
	self.timer = getRandomRange(rangeMin, rangeMax)
end

function storyCharacter:setExtraCharacter(character)
	self.extraCharacter = character
	character.extraCharacter = self
	self.timer = character.timer
end

function storyCharacter:setNextCharacter(character)
	self.nextCharacter = character
	if (self.extraCharacter) then
		self.extraCharacter.nextCharacter = character
	end
end

function storyCharacter:setActive()
	self.active = true
	if (self.extraCharacter) then
		self.extraCharacter.active = true
	end
end

function storyCharacter:onTick(time)
	if (scene:isStartingMovie() or 
		scene:isPlayingMovie()) then
		return
	end

	if (not self.active or not (self.charState == "outside") or not scene:isPlaying() or day.state == "exclamation") then
		return
	end
	
	self.timer = self.timer - time
	if (self.timer < 0) then
		if (not self.atSpot) then		
			self.atSpot = true
			self.timer = self.durationBeforeGo
			self.active = false
			self:setVisible(true)
			self:qWalkToXY(self.destX, self.destY)		
			self:qCallback(self, function(self) self.active = true end)
			self:qCreateHighlight()
			if (self.optional) then
				self:qPlaySound("SOUND_EVENT_ATTENTION")			
				self:qAnimate("ATTENTION", -1, 8)
			else
				self:qCallback(self, function(self) self:onClick() end)			
			end
			
			if (self.extraCharacter) then				
				self.extraCharacter.active = false
				self.extraCharacter:setVisible(true)
				self.extraCharacter:qWait(200)
				self.extraCharacter:qWalkToXY(self.extraCharacter.destX, self.extraCharacter.destY)
				self.extraCharacter:qCreateHighlight()
				if (self.optional) then
					self.extraCharacter:qAnimate("ATTENTION", -1, 8)
				end
			end
		else
		    self:removeHighlight()
		    self:animate("IDLE", 0)
			self.charState = "to_seat"

			if (self.sequenceEnd) then
			
				qSequence(self.sequenceEnd)
				self:qCallback(self, function(s) s.charState = "sitting" end)

				if (self.nextCharacter) then
					self.nextCharacter:qCallback(self.nextCharacter, function(ch) ch:setActive() end)
				else
					self:qNotify("all characters in")
				end
				
				if (self.extraCharacter) then
					self.extraCharacter:qCallback(self.extraCharacter, function(s) s.charState = "sitting" end)
					self.extraCharacter.charState = "to_seat"
				    self.extraCharacter:animate("IDLE", 0)
					self.extraCharacter:removeHighlight()
					self.extraCharacter.sequenceEnd = nil
				end
				
			end
		end
	end
end

function storyCharacter:onClick()

	--if (self:isSelected() == false) then
		--if (day.personsToTalkTo) then
    		--day.personsToTalkTo = day.personsToTalkTo - 1
    		--cout("p: " .. self:getBaseName() .. " : " .. day.personsToTalkTo .. "\n")
    		--if (day.personsToTalkTo == 0) then
				--tm:checkListenedToEveryone()
			--end
	    --end
	--end

	if (self:isSelected() == false and self.charState == "outside") then
		-- make emily get the the right position
		emily:qWorkOn(self)
		self:setSelected(true)		
		self.charState = "to_seat"
	    self:animate("IDLE", 0)
		
		if (self.extraCharacter) then
		    self.extraCharacter:animate("IDLE", 0)
			self.extraCharacter:setSelected(true)
			self.extraCharacter.charState = "to_seat"
			self.extraCharacter.sequenceEnd = nil
			self.extraCharacter.sequence = nil
		end		
	elseif (self.charState == "sitting") then
		emily:qWorkOn(self)
		self:setSelected(true)		
		self.charState = "to_exclamation_person"
		day.state = "exclamation_active"
		self:qRemoveOverhead()
	    if (event.active == true and event.order) then
            event.order:setVisible(false)
        end
	end
end

function storyCharacter:onWorkStart(task)
	-- disable selection
	self:setSelected(false)
	-- disable highlight so we can't click the angela anymore
    self:removeHighlight()
	task:setDuration(0)
	
	if (self.extraCharacter) then
		self.extraCharacter:removeHighlight()
	end
	
	return true
end

function storyCharacter:onWorkComplete(task)
	
	local doCount = false
	if (self.charState == "to_exclamation_person") then
		if (self.sequenceExclamation) then	        
			insert()
			doCount = true

			qSequence(self.sequenceExclamation)
			self:qCallback(self, function(s) s.charState = "sitting" end)
			self:qCallback(self, function(s) s.sequenceExclamation = nil  end)
	        self:qCallback(self, function(s) incScore(25, 400, 300, 500, "BONUS") end)
	        self:qCallback(self, function(s) day.state = "characters in" day.activeExclamationPerson = nil end)
	        
	        if (event.active == true and event.order) then
                event.order:qSetVisible(true)
            end
            
			append()
		end
	elseif (self.sequence) then -- first state
		insert()
		doCount = true

		qSequence(self.sequence)
        self:qCallback(self, function(self) incScore(25, 400, 300, 500, "BONUS") end)
		qSequence(self.sequenceEnd)
		self:qCallback(self, function(s) s.charState = "sitting" end)
		if (self.extraCharacter) then
			self.extraCharacter:qCallback(self.extraCharacter, function(s) s.charState = "sitting" end)
		end

		if (self.nextCharacter) then
			self.nextCharacter:qCallback(self.nextCharacter, function(ch) ch:setActive() end)
		else
			self:qNotify("all characters in")
		end
		
		append()
	end
	
	if (doCount and day.personsToTalkTo) then
		day.personsToTalkTo = day.personsToTalkTo - 1
		cout("p: " .. self:getBaseName() .. " : " .. day.personsToTalkTo .. "\n")
		if (day.personsToTalkTo == 0) then
			tm:checkListenedToEveryone()
		end
	end	
end

function storyCharacter:getWorkNode()
	return grid:getNode(self.talkPositionX, self.talkPositionY)
end