-- global help values
santaChildPersons =
{
}
santaChildPersonsCount = 0
santaChildId = 0

-- class
class 'santaChild' (fakecustomer)

-- For our dear leveldesigner:
santaChild.workAnimElf 				= "TAKE_PICTURE_ELF"		-- Francois elf 'picture taking' animation
santaChild.workSoundPicture 		= "SOUND_TIP_POPS_IN_AIR"	-- What do we hear when a picture is taken?
santaChild.scorePictureTaken 		= 50						-- Score you get for taking a picture
santaChild.timeTakePicture 			= 1000						-- Time it takes to take a picture (worktime for francois)
santaChild.timeBeforeLeavingMin 	= 5000						-- MIN time a child keeps waiting with santa for a picture
santaChild.timeBeforeLeavingMax 	= 10000						-- MAX time a child keeps waiting with santa for a picture

-- Don't touch the stuff below unless you know what you are doing:
santaChild.state = "dead"
santaChild.targetX = -1
santaChild.targetY = -1
santaChild.timer = 0
santaChild.id = -1
santaChild.sittingWithSanta = false
santaChild.waitTimeSuspended = false
santaChild.waitTimer = 0

function santaChild:__init(baseName) super(baseName)
end

function santaChild:onCreate()

	fakecustomer.onCreate(self)
	self:register()
	
end

function santaChild:onPlace()

	self:walkToSanta()

end


function santaChild:register()

	santaChildId = santaChildId + 1
	self.id = santaChildId
	
	santaChildPersons[santaChildId] = self
	santaChildPersonsCount = santaChildPersonsCount + 1

end

function santaChild:unregister()

	santaChildPersons[self.id] = nil
	santaChildPersonsCount = santaChildPersonsCount - 1

end

function santaChild:onTick(time)

	if (dayEnded) then
		return
		
	end

	if (self.state == "walking to exit") then
		if (self:getPosition():getGridX() == self.targetX) then
			if (self:getPosition():getGridY() == self.targetY) then
				self.targetX = -1
				self.targetY = -1
				self:unregister()
				self:setVisible(false)
				self:qDestroy()
			end
		end
	
	elseif (self.state  == "walking to santa") then
		if (self:getPosition():getGridX() == self.targetX) then
			if (self:getPosition():getGridY() == self.targetY) then
				self.targetX = -1
				self.targetY = -1
				self.timer = getRandomRange(self.timeBeforeLeavingMin, self.timeBeforeLeavingMax)
				self.state = "sitting with santa"
				self:createHighlight()
				self.sittingWithSanta = true
				-- Hint about clicking the child to make picture
				if (gPictureArrowShown ~= true) then
					self:createOverhead("INGAME_ARROW")
					gPictureArrowShown = true
				end
				self:qAnimate("SIT_LAP_WAVE", -1, 3)
			
			end
		end	
	end
	
	if (scene:isPlayingMovie()) then
		return
	
	end
	
	if (scene:isStartingMovie()) then
		return
		
	end
	
	if (self.state == "sitting with santa") then
		if (self.timer > 0) and (not self.waitTimeSuspended) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self:walkToExit()
				self:clearOverhead()
				
			end
		end
	end

end

function santaChild:walkToExit()
	
	-- get location of exit
	local gridX = -1
	local gridY = -1
	if (getRandom(2) == 0) then
		gridX = entryX
		gridY = entryY
	
	else
		gridX = exitX
		gridY = exitY
	
	end
	
	-- set state
	self.state = "walking to exit"
	
	-- walk
	self:qWalkToXY(gridX, gridY)
	self.targetX = gridX
	self.targetY = gridY
	
end

function santaChild:walkToSanta()

	-- set state
	self.state = "walking to santa"
	
	-- walk
	local gridX = restaurant1.santaNodeX
	local gridY = restaurant1.santaNodeY
	self:qWalkToXY(gridX, gridY)
	self:qSetPosition(grid:getNode(gridX - 1, gridY))
	self:qAnimate("SIT_LAP", 0)
	self.targetX = gridX - 1
	self.targetY = gridY
	
end

function santaChild:onClick()
	if (self.sittingWithSanta and not self.waitTimeSuspended) then
		-- animate santa's elf
		if (entertainer ~= nil) then
			entertainer:qWorkOn(self)
		else
			cout("NO ENTERTAINER TO START TAKE PICTURE TASK! \n")
		end
		
		self.waitTimeSuspended = true
		self:setSelected(true)
		self:clearOverhead()
		self:animate("SIT_LAP", 0)
	end
end

function santaChild:onWorkStart(task)
	if (self.sittingWithSanta) then
		self:setSelected(false)
		
		-- animate santa's elf
		if (entertainer ~= nil) then
			entertainer:animate(self.workAnimElf, -1)
			entertainer:playSound(self.workSoundPicture)
		else
			cout("NO ENTERTAINER TO TAKE PICTURE! \n")
		end
		
		---- time it takes to clap
		task:setDuration(self.timeTakePicture)
		self.state = "wait for picture"
		return true
	end
	return false
end

function santaChild:onWorkComplete(task)
	self:animate("IDLE", 0)
	
	if (entertainer ~= nil) then
		entertainer:animate("IDLE", 0)
--		entertainer:stopSound(self.workSoundPicture)
		entertainer:playSound("SOUND_EVENT_COMPLETE_ITEM")
		incScore(self.scorePictureTaken, entertainer:getScreenX(), entertainer:getScreenY() + scorePersonFloaterOffsetY, 0)
	else
		cout("NO ENTERTAINER TO STOP TAKING PICTURE! \n")
	end

	day:onNotify("picture taken")
	self:leaveSanta()
end

function santaChild:leaveSanta()
	
	if (self.sittingWithSanta) then
		self.sittingWithSanta = false
		self.waitTimeSuspended = false
		--self:setClickable(false)
		self:walkToExit()
		day:onNotify("child left santa")
		self:removeHighlight()
	end
	
end

function santaChild:getWorkNode()
	return grid:getNode(23, 16)
end