class 'luacustomer' (D2Person)

luacustomer.moodChangeDuration = 10000
luacustomer.score = 50
luacustomer.startMood = 1

luacustomer.order = nil
luacustomer.orderId = ""
luacustomer.enterNode = nil
luacustomer.exitNode = nil
luacustomer.timer = luacustomer.moodChangeDuration
luacustomer.timerSuspended = true
luacustomer.mood = 0
luacustomer.class = nil
luacustomer.func = nil

function luacustomer:__init(baseName) super(baseName)
	self:setWalkTimePerNode(70)
	self:setDefaultSection("customers")
end

function luacustomer:initCustomer(class, clearFunc)
	self:setPosition(self.enterNode)
	self:changeMood(self.startMood)
	self.class = class
	self.func = clearFunc
	self.moodChangeDuration = level:getMoodDropTime()
	self.timer = self.moodChangeDuration
end

function luacustomer:calcImageName(input)
	in_ = input

	if (self:isSitting()) then
		if (in_ == "IDLE") then
     		in_ = "READ"
		end
	end

	res = D2Person.calcImageName(self, in_)
  
	return res
end

function luacustomer:calcLegsName()
	res = D2Person.calcLegsName(self)
	
	if (self.state ~= nil) then
		if (self.state == "ORDER") then
			res = res .. "_ORDERING"
			
		end
	end
	
	return res
end

function luacustomer:createOrder(orderId)
    if (self.order) then
        self:removeOrder()
    end
   
    self.orderId = orderId
    self.order = createOrder()

    x = -self:getAnchorX() + self:getWidth() / 2
    y = -self:getAnchorY()
    self.order:setX(x)
    self.order:setY(y)
    self.order:setAnchorPointType(BOTTOMCENTER)		
    self:addChild(self.order)
    
    self.order:addProduct(orderId)
end

function luacustomer:showOrder()
	self.order:qPopIn()		
    self:qCreateHighlight()
    self.timerSuspended = false
end

function luacustomer:removeOrder()
    if (self.order) then  
        self:removeHighlight()
        self.order:qPopOut()
        self.order:qDestroy()
        self.order = nil
    end
end

function luacustomer:getWorkNode()
  	return getProduct(self.orderId):getWorkNode()
end

function luacustomer:onClick()	
	if (self:isSelected() == false) then
		D2Person.onClick(self)
		self:setSelected(true)
		emily:qWait(200)
		emily:qWorkOn(self)
		self.timerSuspended = true
	end
end

function luacustomer:onWorkStart(task)
	-- disable selection
	self:setSelected(false)	
	-- time it takes to transfer the handle the order
	task:setDuration(100)
	return true	
end

function luacustomer:onWorkComplete(task)
    -- hand over products
    local n = tray:distributeProducts(self.order)
    if (n > 0) then
        -- update
        addPayingCustomer(self)
        self:changeMood(1)
        self.order:qPopIn()
        self:removeHighlight()       
    else
        self:createHighlight()    
    end

    self.timerSuspended = false    
end

function luacustomer:onPay()
    self:removeOrder()
    
    local tipScore = 0
    if (self.mood > 0) then
        tipScore = self.mood * getInteger("MONEY_TIPS_MP_NORMAL")
        tipScore = tipScore * um:getCounterTipMultiplier()
    	incScoreAndTip(self.score, tipScore, self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, 150)    
    	if (um:isHeated()) then
	    	incScore(level:getHeatedTip(), self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, 800)         
	    end
    else
    	incScore(self.score, self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, 150)         
    end
   
	self:leave()
end

function luacustomer:leave()
	self.func(self.class)
	
	getProduct(self.orderId):removeOverhead()
	
    self:removeOrder()
    self:qWalkToNode(self.exitNode)
    self:qDestroy()
    self.timerSuspended = true   
end

function luacustomer:onTick(time)
	if (scene:isPlayingMovie()) then
		return
	end

    D2Person.onTick(self, time)
    
    if (self.timerSuspended) then
        return
    end
    
    self.timer = self.timer - time
    if (self.timer < 0) then
        
        if (self.mood == -2) then
            self:leave()
            removePayingCustomer(self)
            return
        end
    
        self:changeMood(-1)                
        self.timer = self.timer + self.moodChangeDuration   
    end
end

function luacustomer:changeMood(n)

	self.mood = self.mood + n
	self.mood = math.min(self.mood, 2)
	self.mood = math.max(self.mood, -2)
	
	self:setOverheadX(28)
	self:setOverheadY(50)
	
	if (self.mood == -2) then
		self:createOverhead("INGAME_THUNDER", "ingame")
	    self:setAppearance("ANGRY")
	elseif (self.mood == -1) then
		self:clearOverhead()
	    self:setAppearance("ANGRY")
	elseif (self.mood == 0) then
		self:clearOverhead()
	    self:setAppearance("")
	elseif (self.mood == 1) then
		self:clearOverhead()
	    self:setAppearance("HAPPY")
	elseif (self.mood == 2) then
		self:createOverhead("INGAME_HEART", "ingame")
	    self:setAppearance("HAPPY")
	end

	if (self.order) then
		self.order:setMoodIndicator(self.mood + 2)
		self.order:draw()
	end
	
end