-- ----------------------------------------------------------------------------
-- Elevator customer
-- ----------------------------------------------------------------------------
include("scripts/persons/luacustomer.lua")

class 'elevatorCustomer' (luacustomer)

elevatorCustomer.arriving = false
elevatorCustomer.waitingForLift = false
elevatorCustomer.keyName = nil
elevatorCustomer.waitNode = nil
elevatorCustomer.doKey = true

function elevatorCustomer:__init(baseName) super(baseName)
end

function elevatorCustomer:isArriving()
	return self.arriving
end

function elevatorCustomer:setWaitingForLift(waiting)
	self.waitingForLift = waiting
end

function elevatorCustomer:isWaitingForLift(waiting)
	return self.waitingForLift
end

function elevatorCustomer:getRequestedFloor()
	
	if (self.keyName ~= nil) then
		--cout("key name: " .. self.keyName .. "\n")
		if (self.keyName == "KEY_1" or
			self.keyName == "ELEVATOR_01") then
			return 1
		elseif (self.keyName == "KEY_2" or
				self.keyName == "ELEVATOR_02") then
			return 2
		end
		return 3
	end
	
	return -1
end

function elevatorCustomer:getFloorId()

	local floorNr = self:getRequestedFloor()
	--cout("Requested floor: " .. floorNr)
	if (floorNr > 0) then
		return ("ELEVATOR_0" .. floorNr)
	end
	return nil
end

function elevatorCustomer:createOrder(orderId)
	luacustomer.createOrder(self, orderId)
    self.keyName = orderId
end

function elevatorCustomer:setKeyName(keyName)
	--cout("setting key name " .. keyName .. "\n")
	self.keyName = keyName
end

function elevatorCustomer:onPay()
    self:removeOrder()
    
    local tipScore = 0
    if (self.mood > 0) then
        tipScore = self.mood * getInteger("MONEY_TIPS_MP_NORMAL")
        tipScore = tipScore * um:getCounterTipMultiplier() * um:getMiscMultiplier()
    	incScoreAndTip(self.score, tipScore, self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, 150)       	
    	if (um:isHeated()) then
    		incScore(level:getHeatedTip(), self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, 800)         
    	end

    else
    	incScore(self.score, self:getScreenX(), self:getScreenY() + scorePersonFloaterOffsetY, 150)         
    end

	if (self.arriving) then   
		self:moveToLift()
	else
		self:leave()
	end
end

function elevatorCustomer:moveToLift()
	--self.func(self.class)
	
    self:removeOrder()
    self:qWalkToNode(self.waitNode)
    self:qWait(300)
    self:qCallback(self, function(self)
		local floorId = self:getFloorId()
		self:createOrder(floorId)
		self:showOrder()
		self:qRemoveHighlight()
		self:setWaitingForLift(true)			
		local p = getProduct(floorId)
		if (p) then
			hm:placeArrow(getArrowIndex("ARROW_HINT_INVITATION_PLACE"), p, 15, 15)
		end
	end)
    self.timerSuspended = true
end

--function elevatorCustomer:onCallLift()
	--local actor = self
	--self:qWait(300)
	--
--end
