class 'spiderwebevent' (interface)

--
-- hidden object types
-- all these types are defined as hidden objects!
-- when you come up with a new hidden object event, the preset type needs
-- to be added here!
spiderwebevent.eventBarImage = nil

-- configuration variables
spiderwebevent.baseName = ""					-- appearance of the person
spiderwebevent.baseSection = "characters"	-- section
spiderwebevent.entryX = 0					-- position person enters from
spiderwebevent.entryY = 0
spiderwebevent.highlightX = 0
spiderwebevent.highlightY = 0
spiderwebevent.sequenceStart	= nil			-- text when event starts
spiderwebevent.sequenceThanks = nil			-- text when you find 1 item
spiderwebevent.sequenceDone = nil			-- text when you find all items
spiderwebevent.sequenceFail = nil			-- sequence for when the task time ends and you don't have all of the items
spiderwebevent.timeUntilEnterMin = 0			-- minimum time the person waits outside
spiderwebevent.timeUntilEnterMax = 0			-- maximum time the person waits outside
spiderwebevent.scoreFoundOne	= 0				-- score for finding one item
spiderwebevent.scoreFoundAll	= 0				-- bonus for finding all items
spiderwebevent.hintId = "HINT_SPIDER_WEB_CLEANING"
spiderwebevent.pixelsToClean = 600
spiderwebevent.cleanSound = "SOUND_CLEAN_SPIDER_LOOP"

-- internal variables
-- don't change unless you know what you're doing
spiderwebevent.items = {}
spiderwebevent.itemsProps = {}
spiderwebevent.countItems = 0
spiderwebevent.countFound = 0
spiderwebevent.person = nil
spiderwebevent.timer = 0
spiderwebevent.timerStill = 0
spiderwebevent.started = false
spiderwebevent.eventStarted = false
spiderwebevent.completed = false
spiderwebevent.cleanMode = false
spiderwebevent.cleanObject = nil
spiderwebevent.oldX = 0
spiderwebevent.oldY = 0
spiderwebevent.objectToClean = nil
spiderwebevent.playing = false

function spiderwebevent:__init() super()
end

function spiderwebevent:onLevelGlobals()
	for index, value in ipairs(self.itemsProps) do
       	createDummyObject(value.type, value.x, value.y)
     end   
end

function spiderwebevent:onLevelInited()

	if (self.countItems > 0) then

		-- set enter timer
		self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
	
	  	-- create the person that lost all his/her belongings
	  	if (self.baseName ~= "") then
			self.person = pm:createPerson("npc")
			self.person:setBaseName(self.baseName)
			self.person:setDefaultSection(self.baseSection)
			self.person:setPosition(grid:getNode(self.entryX, self.entryY))
		end
		
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(math.max(1, self.countItems))
		eventBar:setProgress(0)
		eventBar:setDescriptionText(getText("EVENTBAR"))
		if (self.eventBarImage == nil) then
			eventBar:setSubjectImage(self.items[1]:getBaseName() .. "_BAR", self.items[1]:getDefaultSection())
		else
			eventBar:setSubjectImage(self.eventBarImage, self.items[1]:getDefaultSection())
		end
		
	else
	
		warn("spiderwebevent - no hidden object(s) found")
	
	end

end

function spiderwebevent:createObject(desc)
  
  	local result = nil
  
	for index, value in ipairs(self.itemsProps) do
		if (value.type == desc:getType()) then
			result = spiderweb()
			result:setObjectIdName(value.type)
			result:setDefaultSection(player:getCurrentResourceSection())
			result:setType(value.type)
    		result:anchorY(value.anchorY)
    		result:animate(value.image, 0)
			result.event = self
			if (value.hidden ~= nil) then
				result:setVisible(not value.hidden)
			end
			if (value.pixelsToClean ~= nil) then
				result.pixelsToClean = value.pixelsToClean
			else
				result.pixelsToClean = self.pixelsToClean
			end
			break;		
		end
	end  	
  
	if (result ~= nil) then
		self.items[ self.countItems+1 ] = result;
		self.countItems = self.countItems + 1 
	end
  
  	return result

end

function spiderwebevent:onDayBegin()

	self.started = true

	local p = self.items[4]
	if (self.hintId ~= "") then
		hm:openHint(getHintIndex(self.hintId), p:getScreenX(), p:getScreenY() - (p:getHeight() / 2))
	end

end

function spiderwebevent:onDayEnd()

	if (not self.completed) then
	
		if (self.sequenceFail ~= nil) then
			qSequence(self.sequenceFail)		
		else
			if (self.person) then
				self.person:qDestroy()
			end
		end
	end
	
end

function spiderwebevent:onDeactivate()
    if (self.cleanMode) then
       self:setCleanMode(false, nil)
    end
end

function spiderwebevent:onPause(pause)
    if (pause and self.cleanMode) then
        self:setCleanMode(false, nil)
    end
end

function spiderwebevent:doSound(play)

	if (play) then
		if (not self.playing) then
			emily:playSound(self.cleanSound, true)
			self.playing = true
		end
	else
		if (self.playing) then
			emily:stopSound(self.cleanSound)
			self.playing = false
		end
	end

end

function spiderwebevent:onTick(time)

	if (self.started == false) then
		return
	end
	
    if (self.cleanMode) then  

        self.oldX = self.cleanObject:getX()
        self.oldY = self.cleanObject:getY()  
        self.cleanObject:setX(getMouseX())
        self.cleanObject:setY(getMouseY()) 
        
        local x = self.cleanObject:getX()
        local y = self.cleanObject:getY()
        
        if (self.oldX ~= x and self.oldY ~= y) then
        	self:doSound(true)
        	self.timerStill = 0
        else
        	self.timerStill = self.timerStill + time
        	if (self.timerStill > 500) then
        		self:doSound(false)        	
        	end
        end
        
        if (self.oldX ~= x and self.oldY ~= y and self.objectToClean:getHighlight():isHighlighted()) then
            
            local dx = x - self.oldX
            local dy = y - self.oldY
            local l = ((dx * dx) + (dy * dy)) ^ 0.5
            self.objectToClean.curPixels = self.objectToClean.curPixels + l
	        local alpha = math.max(0.2, 1 - ((self.objectToClean.curPixels / self.objectToClean.pixelsToClean) * 0.75))
            self.objectToClean:setAlpha(alpha)
            eventBar:setProgress((1 - ((self.objectToClean:getAlpha() - 0.25) * 1.333333)) * 50)                   
            if (self.objectToClean.curPixels >= self.objectToClean.pixelsToClean) then
				onNotify("object cleaned")
                self.objectToClean:DoFinishObject()
                self:setCleanMode(false, nil)
            end
            
         end
         
    end	

	-- wait until we can enter
	if (self.timer > 0) then

	    self.timer = self.timer - time
	    if (self.timer <= 0) then

			-- start sequence
			if (self.sequenceStart ~= nil) then
				qSequence(self.sequenceStart)
			end			
	    	
	    end	
	end

end

function spiderwebevent:onNotify(notification)

	if (notification == "show bar") then

        self.eventStarted = true

		-- show pearl on bar
		eventBar:animateToActive()
		eventBar:raiseCurtain()
		
	    -- show all hidden items
		for index, value in ipairs(self.items) do
		
		    value:createHighlight()
		    value:getHighlight():setAlphaHitmaskThreshold(-1)
		    
			if (value:getPosition():getGridX() == self.highlightX) then
				if (value:getPosition():getGridY() == self.highlightY) then
					value:createOverhead("INGAME_ARROW")					
				end
			end
		end
	
	end

end


function spiderwebevent:setCleanMode(mode, object)
    self.cleanMode = mode    
    self.objectToClean = object

    if (mode) then    
    	self.timerStill = 0
    	self:doSound(true)
        self.cleanObject = scene:createD2Sprite()
        self.cleanObject:setDefaultSection(player:getCurrentResourceSection())
        self.cleanObject:animate("OBJECT_DIRTY_SCRUB", 0)
        self.cleanObject:setX(getMouseX())
        self.cleanObject:setY(getMouseY())
        self.cleanObject:setAnchorPointType(4)
        scene:addChild(self.cleanObject)    
        self.oldX = self.cleanObject:getX()
        self.oldY = self.cleanObject:getY()   
        if (object) then
        	object:clearOverhead()
        end      
        
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(50)
        eventBar:setProgress((1 - ((self.objectToClean:getAlpha() - 0.25) * 1.333333)) * 50)                   
    else
    	self:doSound(false)
        self.cleanObject:setObsolete(true)
        self.cleanObject = nil

		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(math.max(1, self.countItems))
		eventBar:setProgress(self.countFound)
    end
    
    
end

function spiderwebevent:onClick(x, y)

    if (self.started == false) then
		return false
	end

    if (self.cleanMode) then
        self:setCleanMode(false, nil)
        return true
    end
   
   return false
end

-- a hidden object
class 'spiderweb' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
spiderweb.event = nil
spiderweb.cleanMode = false
spiderweb.curPixels = 0

function spiderweb:__init() super()
end

function spiderweb:onCreate()
end

function spiderweb:onClick()

    if (self:isVisible() and not self.event.cleanMode) then
         self.event:setCleanMode(true, self)
    end

end

function spiderweb:DoFinishObject()
	-- First check if we should even be able to click on this object:
	if (self:isVisible() == true) then
		-- hide the item
		self:setVisible(false)
		self:setClickable(false)
		self:clearOverhead()
		self:playSound(self.event.soundEventCompleteOne)
	
		-- increase the found count
		self.event.countFound = self.event.countFound + 1
		
		-- increase score and pop a floater
		incScore(self.event.scoreFoundOne, self:getScreenX(), self:getScreenY(), 0)
		
		-- update the event bar
		eventBar:setProgress(self.event.countFound)
		
		-- say thanks
		if (self.event.countFound == self.event.countItems) then
		
			self:playSound(self.event.soundEventCompleteAll)
		
			-- found all items
	    	-- set event to completed
	    	self.event.completed = true
	
			-- lower curtain
			eventBar:animateToDeactive()
	
			-- increase score and pop a floater
			incScore(self.event.scoreFoundAll, self:getScreenX(), self:getScreenY(), scoreBonusFloaterDelay, "BONUS")
	
			-- done sequence
			if (self.event.sequenceDone ~= nil) then
				qSequence(self.event.sequenceDone)			
			end					
	
		else
			-- thanks sequence
			if (self.event.person ~= nil) then
				if (self.event.person:isIdle()) then
					if (self.event.sequenceThanks ~= nil) then
						qSequence(self.event.sequenceThanks)
						
					end
				end
			elseif (self.event.sequenceThanks ~= nil) then
				qSequence(self.event.sequenceThanks)
					
			end	
		end
	end
	
end