class 'snowStormEvent' (interface)

snowStormEvent.completed = false
snowStormEvent.stormSound = "SOUND_SNOWSTORM_LOOP"

function snowStormEvent:__init() super()
end

function snowStormEvent:onLevelGlobals()
	
	self.completed = false

end

function snowStormEvent:onLevelInited()
	
	self.snowStorm = level:getLayer(3):addParticleEffectAfter("PARTICLE_SNOW_STORM") 
	self.snowStorm:play()
	self.snowStorm:addInitialTime(10000)
	scene:startSnowStormOverlay()
	emily:playSound(self.stormSound, true)
	
	-- initialize event bar
	eventBar:setTotalShowed(false)
	eventBar:setProgressShowed(false)
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(1)
	eventBar:setProgress(0)	
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setSubjectImage("EVENT_BAR_SNOWSTORM", player:getCurrentResourceSection())
	
end

function snowStormEvent:onDayBegin()
	eventBar:animateToActive()
	eventBar:raiseCurtain()
	
end

function snowStormEvent:onDayEnd()
	
	-- set event to completed
	self.completed = true
	-- lower the curtain
	eventBar:animateToDeactive()
	
end