class 'meltingsnowevent' (interface)

--
-- hidden object types
-- all these types are defined as hidden objects!
-- when you come up with a new hidden object event, the preset type needs
-- to be added here!
meltingsnowevent.eventBarImage = nil

-- configuration variables
meltingsnowevent.baseName = ""					-- appearance of the person
meltingsnowevent.baseSection = "characters"	-- section
meltingsnowevent.entryX = 0					-- position person enters from
meltingsnowevent.entryY = 0
meltingsnowevent.highlightX = 0
meltingsnowevent.highlightY = 0
meltingsnowevent.sequenceStart	= nil			-- text when event starts
meltingsnowevent.sequenceThanks = nil			-- text when you find 1 item
meltingsnowevent.sequenceDone = nil			-- text when you find all items
meltingsnowevent.sequenceFail = nil			-- sequence for when the task time ends and you don't have all of the items
meltingsnowevent.timeUntilEnterMin = 0			-- minimum time the person waits outside
meltingsnowevent.timeUntilEnterMax = 0			-- maximum time the person waits outside
meltingsnowevent.scoreFoundOne	= 0				-- score for finding one item
meltingsnowevent.scoreFoundAll	= 0				-- bonus for finding all items
meltingsnowevent.hintId = ""
meltingsnowevent.spotNr = 0
meltingsnowevent.snowMeltTimer = 2000
meltingsnowevent.newSnowMeltTimer = 24000
meltingsnowevent.cleanFactor = 2000
meltingsnowevent.cleanSound = "SOUND_CLEAN_SPIDER_LOOP"

-- internal variables
-- don't change unless you know what you're doing
meltingsnowevent.items = {}
meltingsnowevent.itemsProps = {}
meltingsnowevent.countItems = 0
meltingsnowevent.countFound = 0
meltingsnowevent.person = nil
meltingsnowevent.timer = 0
meltingsnowevent.timerStill = 0
meltingsnowevent.started = false
meltingsnowevent.eventStarted = false
meltingsnowevent.completed = false
meltingsnowevent.cleanMode = false
meltingsnowevent.cleanObject = nil
meltingsnowevent.oldX = 0
meltingsnowevent.oldY = 0
meltingsnowevent.objectToClean = nil
meltingsnowevent.playing = false
meltingsnowevent.pixelsToClean = 700

function meltingsnowevent:__init() super()
end

function meltingsnowevent:onLevelGlobals()
	for index, value in ipairs(self.itemsProps) do
       	createDummyObject(value.type, value.x, value.y)
     end   
	 
	 for i=1,6 do --countItems.. erros: must be a number
		 self.items[i]:setAlpha(0.0)
		 self.items[i]:setVisible(false)
	 end
	 
end

function meltingsnowevent:onLevelInited()

	if (self.countItems > 0) then
		-- set enter timer
		self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
	
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(math.max(1, self.countItems))
		eventBar:setProgress(0)
		eventBar:setDescriptionText(getText("EVENTBAR"))
	
	  	if (self.eventBarImage == nil) then
			eventBar:setSubjectImage(self.items[1]:getBaseName() .. "_BAR", self.items[1]:getDefaultSection())
		else
			eventBar:setSubjectImage(self.eventBarImage, self.items[1]:getDefaultSection())
		end
		
	else
	
		warn("meltingsnowevent - no hidden object(s) found")
	
	end


end

function meltingsnowevent:createObject(desc)
  
  	local result = nil
  
	for index, value in ipairs(self.itemsProps) do
		if (value.type == desc:getType()) then
			result = meltedsnow()
			result:setObjectIdName(value.type)
			result:setDefaultSection(player:getCurrentResourceSection())
			result:setType(value.type)
    		result:anchorY(value.anchorY)
    		result:animate(value.image, 0)
			result.event = self
			if (value.hidden ~= nil) then
				result:setVisible(not value.hidden)
			end
			if (value.pixelsToClean ~= nil) then
				result.pixelsToClean = value.pixelsToClean
			else
				result.pixelsToClean = self.pixelsToClean
			end
			break;		
		end
	end  	
  
	if (result ~= nil) then
		self.items[ self.countItems+1 ] = result;
		self.countItems = self.countItems + 1 
	end
  
  	return result

end

function meltingsnowevent:onDayBegin()

	self.started = true
	--local p = self.items[4]
	--hm:openHint(getHintIndex(self.hintId), p:getScreenX(), p:getScreenY() - (p:getHeight() / 2))

end

function meltingsnowevent:onDayEnd()

	if (not self.completed) then
	
		if (self.sequenceFail ~= nil) then
			qSequence(self.sequenceFail)		
		else
			if (self.person) then
				self.person:qDestroy()
			end
		end
	end
	
end

function meltingsnowevent:onDeactivate()
    if (self.cleanMode) then
       self:setCleanMode(false, nil)
    end
end

function meltingsnowevent:onPause(pause)
    if (pause and self.cleanMode) then
        self:setCleanMode(false, nil)
    end
end

function meltingsnowevent:doSound(play)

	if (play) then
		if (not self.playing) then
			emily:playSound(self.cleanSound, true)
			self.playing = true
		end
	else
		if (self.playing) then
			emily:stopSound(self.cleanSound)
			self.playing = false
		end
	end

end


function meltingsnowevent:onTick(time)

	if (self.started == false) then
		return
	end
	
    if (self.cleanMode) then  

        self.oldX = self.cleanObject:getX()
        self.oldY = self.cleanObject:getY()  
        self.cleanObject:setX(getMouseX())
        self.cleanObject:setY(getMouseY()) 
        
        local x = self.cleanObject:getX()
        local y = self.cleanObject:getY()
        
        if (self.oldX ~= x and self.oldY ~= y) then
        	self:doSound(true)
        	self.timerStill = 0
        else
        	self.timerStill = self.timerStill + time
        	if (self.timerStill > 500) then
        		self:doSound(false)        	
        	end
        end        
        
        if (self.oldX ~= x and self.oldY ~= y and self.objectToClean:getHighlight():isHighlighted()) then
            
            local dx = x - self.oldX
            local dy = y - self.oldY
            local l = ((dx * dx) + (dy * dy)) ^ 0.5
            self.objectToClean.curPixels = self.objectToClean.curPixels + l
            local alpha = math.max(0.2, 1 - ((self.objectToClean.curPixels / self.objectToClean.pixelsToClean) * 0.75))
            self.objectToClean:setAlpha(alpha)
	        eventBar:setProgress((1 - ((self.objectToClean:getAlpha() - 0.25) * 1.333333)) * 50)                   
            if (self.objectToClean.curPixels >= self.objectToClean.pixelsToClean) then
				onNotify("object cleaned")
                self.objectToClean:DoFinishObject()
                self:setCleanMode(false, nil)
            end
            
         end
         
    end	
	
	if (meltingsnowevent.snowMeltTimer > 0) then
		meltingsnowevent.snowMeltTimer = meltingsnowevent.snowMeltTimer - time
		if (meltingsnowevent.snowMeltTimer <= 0 and self.spotNr < 6) then
			meltingsnowevent.snowMeltTimer = meltingsnowevent.newSnowMeltTimer
			self.spotNr = self.spotNr + 1
			self.items[self.spotNr]:setVisible(true)
		end
	end
	
	for i=1,self.spotNr do 
		if(self.items[i]:getAlpha() < 1 and self.items[i].readyToClean == false) then
			self.items[i]:setAlpha(self.items[i]:getAlpha() + (1.1 / (1000 / time))) 
			if(self.items[i]:getAlpha() >= 1) then
				self.items[i].readyToClean = true
			end
		end
	end

	
	-- wait until we can enter
	if (self.timer > 0) then

	    self.timer = self.timer - time
	    if (self.timer <= 0) then

			-- start sequence
			if (self.sequenceStart ~= nil) then
				qSequence(self.sequenceStart)
			end			
	    	
	    end	
	end

end

function meltingsnowevent:onNotify(notification)

	if (notification == "show bar") then

        self.eventStarted = true

		-- show pearl on bar
		eventBar:animateToActive()
		eventBar:raiseCurtain()
		
	    -- show all hidden items
		for index, value in ipairs(self.items) do
		
		    value:createHighlight()
		    value:getHighlight():setAlphaHitmaskThreshold(-1)
		    
			if (value:getPosition():getGridX() == self.highlightX) then
				if (value:getPosition():getGridY() == self.highlightY) then
					value:createOverhead("INGAME_ARROW")
					
				end
			end
		end
	
	end

end


function meltingsnowevent:setCleanMode(mode, object)
    self.cleanMode = mode    
    self.objectToClean = object

    if (mode) then    
    	self.timerStill = 0
    	self:doSound(true)    
        self.cleanObject = scene:createD2Sprite()
        self.cleanObject:setDefaultSection(player:getCurrentResourceSection())
        self.cleanObject:animate("OBJECT_DIRTY_SCRUB", 0)
        self.cleanObject:setX(getMouseX())
        self.cleanObject:setY(getMouseY())
        self.cleanObject:setAnchorPointType(4)
        scene:addChild(self.cleanObject)    
        self.oldX = self.cleanObject:getX()
        self.oldY = self.cleanObject:getY()         
        
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(50)
        eventBar:setProgress((1 - ((self.objectToClean:getAlpha() - 0.25) * 1.333333)) * 50)                          
    else
    	self:doSound(false)
        self.cleanObject:setObsolete(true)
        self.cleanObject = nil

		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(math.max(1, self.countItems))
		eventBar:setProgress(self.countFound)
    end
    
    
end

function meltingsnowevent:onClick(x, y)

    if (self.started == false) then
		return false
	end

    if (self.cleanMode) then
        self:setCleanMode(false, nil)
        return true
    end
   
   return false
end

-- a hidden object
class 'meltedsnow' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
meltedsnow.event = nil
meltedsnow.cleanMode = false
meltedsnow.readyToClean = false
meltedsnow.curPixels = 0

function meltedsnow:__init() super()
end

function meltedsnow:onCreate()
end

function meltedsnow:onClick()

    if (self:isVisible() and self.readyToClean == true and not self.event.cleanMode) then
         self.event:setCleanMode(true, self)
    end

end

function meltedsnow:DoFinishObject()
	-- First check if we should even be able to click on this object:
	if (self:isVisible() == true) then
		-- hide the item
		self:setVisible(false)
		self:setClickable(false)
		self:clearOverhead()
		self:playSound(self.event.soundEventCompleteOne)
	
		-- increase the found count
		self.event.countFound = self.event.countFound + 1
		
		-- update the event bar
		eventBar:setProgress(self.event.countFound)

		
		-- increase score and pop a floater
		incScore(self.event.scoreFoundOne, self:getScreenX(), self:getScreenY(), 0)
		
		-- say thanks
		if (self.event.countFound == self.event.countItems) then
		
			self:playSound(self.event.soundEventCompleteAll)
		
			-- found all items
	    	-- set event to completed
	    	self.event.completed = true
	
			-- lower curtain
			eventBar:animateToDeactive()
	
			-- increase score and pop a floater
			incScore(self.event.scoreFoundAll, self:getScreenX(), self:getScreenY(), scoreBonusFloaterDelay, "BONUS")
	
			-- done sequence
			if (self.event.sequenceDone ~= nil) then
				qSequence(self.event.sequenceDone)			
			end					
	
		else
			-- thanks sequence
			if (self.event.person ~= nil) then
				if (self.event.person:isIdle()) then
					if (self.event.sequenceThanks ~= nil) then
						qSequence(self.event.sequenceThanks)
						
					end
				end
			elseif (self.event.sequenceThanks ~= nil) then
				qSequence(self.event.sequenceThanks)
					
			end	
		end
	end
	
end