class 'interviewEvent' (interface)

-- configuration variables
interviewEvent.sequenceDayStart = nil				-- sequence played when level starts
interviewEvent.sequenceDayEnd = nil				-- sequence played when the interview ends
interviewEvent.timeUntilInterviewMin = 0			-- minimum walking time before starting drop checks
interviewEvent.timeUntilInterviewMax = 0			-- maximum walking time before starting drop checks
interviewEvent.interviewSequences = {}
interviewEvent.interviewPerson = nil
interviewEvent.interviewPosX = 0
interviewEvent.interviewPosY = 0
interviewEvent.nrInterviews = 0

-- internal variables
-- don't change unless you know what you're doing
interviewEvent.started = false
interviewEvent.completed = false
interviewEvent.interviewing = false
interviewEvent.timer = 0
interviewEvent.interviewIndex = 0

function interviewEvent:__init() super()
end

function interviewEvent:onLevelInited()
		self.timer = getRandomRange(self.timeUntilInterviewMin, self.timeUntilInterviewMax)
	
	-- start sequence
	if (self.sequenceDayStart ~= nil) then
		qSequence(self.sequenceDayStart)			
	end
end

function interviewEvent:onDayBegin()

	self.started = true
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(self.nrInterviews)
	eventBar:setProgress(0)	
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setSubjectImage("EVENT_INTERVIEW_BAR", player:getCurrentResourceSection())
	eventBar:animateToActive()	
	eventBar:raiseCurtain()

end

function interviewEvent:onDayEnd()
	if (self.sequenceDayEnd ~= nil) then
		qSequence(self.sequenceDayEnd)
	end	
end


function interviewEvent:onTick(time)
	
	if (scene:isStartingMovie() or 
		scene:isPlayingMovie() or 
		self.interviewing == true or 
		self.started == false or 
		self.completed == true or
		self.interviewSequences[self.interviewIndex] == nil) then
		return
	end
	
	self.timer = self.timer - time
	if (self.timer < 0) then
		self.timer = getRandomRange(self.timeUntilInterviewMin, self.timeUntilInterviewMax)
		self.interviewing = true
		self.interviewPerson:qWalkToXY(self.interviewPosX, self.interviewPosY)
		self.interviewPerson:qCallback(self, 
			function(self) 
				insert()
				emily:qWalkToXY(self.interviewPosX - 3, self.interviewPosY)
				qSequence(self.interviewSequences[self.interviewIndex])
				self.interviewPerson:qNotify("interview end")
				append()
			end)
	end

end

function interviewEvent:onNotify(notification)
	if (notification == "interview end") then
		self.interviewing = false
		self.interviewIndex = self.interviewIndex + 1
		emily:playSound("SOUND_EVENT_COMPLETE_ITEM")
		
		-- update the eventbar
		eventBar:setProgress(self.interviewIndex)
		if (self.interviewIndex == self.nrInterviews) then
			eventBar:animateToDeactive()
		end
	end
end
