class 'hiddenPersonEvent' (interface)

--
hiddenPersonEvent.eventBarImage = nil
hiddenPersonEvent.hiddenPerson = nil

-- configuration variables
hiddenPersonEvent.timeUntilPopMin = 5000			-- minimum time the person waits before pop
hiddenPersonEvent.timeUntilPopMax = 6000			-- maximum time the person waits before pop
hiddenPersonEvent.timeLooking = 3000				-- time person is looking
hiddenPersonEvent.countItems = 6					-- total times we need to click the person
hiddenPersonEvent.baseName = "EVENT_ELF"			-- appearance of the hidden person
hiddenPersonEvent.section = "characters"			-- section for hidden person image
hiddenPersonEvent.overheadY = 30					-- Verical distance between character and hint arrow

hiddenPersonEvent.timer = 0
hiddenPersonEvent.started = false
hiddenPersonEvent.completed = false
hiddenPersonEvent.failed = false

hiddenPersonEvent.spots = {}
hiddenPersonEvent.spots[1] = nil
hiddenPersonEvent.spots[2] = nil
hiddenPersonEvent.spots[3] = nil
hiddenPersonEvent.spots[4] = nil
hiddenPersonEvent.spots[5] = nil
hiddenPersonEvent.spots[6] = nil
hiddenPersonEvent.countSpots = 6					-- total amount of spots the hidden person can appear

hiddenPersonEvent.sequenceDone = nil				-- text when you find all items
hiddenPersonEvent.sequenceFail = nil				-- sequence for when the task time ends and you don't have all of the items
hiddenPersonEvent.scoreFoundOne	= 10				-- score for finding one item
hiddenPersonEvent.scoreFoundAll	= 50				-- bonus for finding all items

-- internal variables
-- don't change unless you know what you're doing
hiddenPersonEvent.timer = 0
hiddenPersonEvent.started = false
hiddenPersonEvent.completed = false
hiddenPersonEvent.personShowing = false
hiddenPersonEvent.hiddenCharacter = nil
hiddenPersonEvent.countFound = 0					-- current correctly clicked count

function hiddenPersonEvent:__init() super()
end

function hiddenPersonEvent:onLevelInited()
	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(math.max(1, self.countItems))
	eventBar:setProgress(0)
	eventBar:setDescriptionText(getText("EVENTBAR"))
	if (self.eventBarImage == nil) then
		eventBar:setSubjectImage(self.baseName .. "_BAR", player:getCurrentResourceSection())
	else
		eventBar:setSubjectImage(self.eventBarImage, player:getCurrentResourceSection())
	end
end

function hiddenPersonEvent:createObject(desc)

	local result = nil

	if (desc:getObjectId() == "rest1_hidden_person") then
		result = hiddenPerson()
		result:setType(desc:getType())
		result:setObjectIdName(desc:getType())
		result:setDefaultSection(player:getCurrentResourceSection())
		result.baseName = self.baseName
		result:animate(result.baseName .. "_APPEAR", 0)
		result:createHighlight()
		result:setOverheadY(self.overheadY)
		
		self.hiddenCharacter = result
		result.event = self
		result.timerLooking = 0
		
	end
	return result

end

function hiddenPersonEvent:onDayBegin()

	hiddenPersonEvent.spots[1] = getObject("rest1_elf_spawn_1")
	hiddenPersonEvent.spots[2] = getObject("rest1_elf_spawn_2")
	hiddenPersonEvent.spots[3] = getObject("rest1_elf_spawn_3")
	hiddenPersonEvent.spots[4] = getObject("rest1_elf_spawn_4")
	hiddenPersonEvent.spots[5] = getObject("rest1_elf_spawn_5")
	hiddenPersonEvent.spots[6] = getObject("rest1_elf_spawn_6")
	
	self.started = true
	self.personShowing = false
	
	self.timer = self:getTimeUntilPop()
	
	eventBar:animateToActive()
	eventBar:raiseCurtain()

end

function hiddenPersonEvent:onDayEnd()

	cout("hiddenPersonEvent:onDayEnd() \n")
	if (not self.completed) then
	
		if (self.sequenceFail ~= nil) then
			cout("qSequence(self.sequenceFail) \n")
			qSequence(self.sequenceFail)
		end
		
	end
	
end

function hiddenPersonEvent:onAllTasksFinished()
	if (not self.completed) then
		self.failed = true
	end
	return true
end

function hiddenPersonEvent:onTick(time)

	if ((self.started == false) or (self.personShowing == true) or (self.completed == true)) then
		return
	end

	if (scene:isStartingMovie() or scene:isPlayingMovie() or self.failed) then
		return
	end
	
	-- wait until we can enter
	if (self.timer > 0) then

	    self.timer = self.timer - time
	    if (self.timer <= 0) then

			self.timer = self:getTimeUntilPop()
			
			-- Pop person in random location	
	    	local randomSpot = self:getRandomSpawnSpot()
	    	
	    	spawnX = randomSpot:getPosition():getGridX()
	    	spawnY = randomSpot:getPosition():getGridY()	    	
	    	self.hiddenCharacter:popUp(spawnX, spawnY)
	    	
	    end	
	end

end

-- Helpers:
function hiddenPersonEvent:getNumberOfSpots()
	
	return self.countSpots
	
end

function hiddenPersonEvent:getRandomSpawnSpot()

	local randomValue = getRandomRange(1, self:getNumberOfSpots() + 1)
	
	return self.spots[randomValue]

end

function hiddenPersonEvent:getTimeUntilPop()
	
	return getRandomRange(self.timeUntilPopMin, self.timeUntilPopMax)

end

-- a hidden object
class 'hiddenPerson' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
hiddenPerson.event = nil
hiddenPerson.baseName = nil
hiddenPerson.sequencePopUp = nil
hiddenPerson.timerLooking = 0

function hiddenPerson:__init() super()
end

function hiddenPerson:onCreate()

end

function hiddenPerson:popUp(x, y)
	
	self.event.personShowing = true
	
	self:setPosition(grid:getNode(x, y))
	
	self:setVisible(true)
	self:setClickable(true)
	
	-- Hint about clicking the hidden person
	if (gHiddenPersonArrowShown ~= true) then
		self:createOverhead("INGAME_ARROW")
		gHiddenPersonArrowShown = true
	end
	
	-- Animation showing hidden person
	self:qAnimateWait(self.baseName .. "_APPEAR", 1)
	self:qAnimate(self.baseName .. "_LOOK", -1)
	
	self.timerLooking = self.event.timeLooking
	
end

function hiddenPerson:hide(fast)
	self:setClickable(false)
	
	if (fast == true) then
		self:qAnimateWait(self.baseName .. "_STARTLED", 1)
	else
		self:qAnimateWait(self.baseName .. "_HIDE", 1)
	end
		
	self:qSetVisible(false)
	self:qAnimate(self.baseName .. "_APPEAR", 0)
	self.event.personShowing = false
	self:clearOverhead()

end

function hiddenPerson:onTick(time)
	
	if (self.timerLooking > 0) then
		
		self.timerLooking = self.timerLooking - time
		
		if (self.timerLooking <= 0) then
			self.timerLooking = 0
			self:hide(false)
		end
		
	end
	
end

function hiddenPerson:onClick()
  
	-- First check if we should even be able to click on this object:
	if (self:isVisible() == true) then
		
		self:setClickable(false)
		self:clearOverhead()
		self:playSound(self.event.soundEventCompleteOne)
	
		-- increase the found count
		self.event.countFound = self.event.countFound + 1
		
		-- increase score and pop a floater
		incScore(self.event.scoreFoundOne, self:getScreenX(), self:getScreenY(), 0)
		
		-- update the event bar
		eventBar:setProgress(self.event.countFound)
		
		-- Animation hiding hidden person	
		self.timerLooking = 0
		self:hide(true)
		
		
		-- say thanks
		if (self.event.countFound == self.event.countItems) then
		
			self:playSound(self.event.soundEventCompleteAll)
		
			-- found all items
	    	-- set event to completed
	    	self.event.completed = true
	
			-- lower curtain
			eventBar:animateToDeactive()
	
			-- increase score and pop a floater
			incScore(self.event.scoreFoundAll, self:getScreenX(), self:getScreenY(), scoreBonusFloaterDelay, "BONUS")
	
			-- done sequence
			if (self.event.sequenceDone ~= nil) then
				qSequence(self.event.sequenceDone)			
			end					
	
		end

	end
	
end