class 'decorateEvent' (interface)

-- configuration variables
decorateEvent.animFix = ""					-- Animation played while decorating
decorateEvent.soundFix = ""					-- Sound played while fixing
decorateEvent.workAnimationFrameRate = -1	-- (optional) frame rate of the work animation
decorateEvent.timeUntilFixed = 1			-- Time it takes to fix the object
decorateEvent.scoreGotAll = 0				-- Score got all
decorateEvent.overheadY = 0					-- Overhead Y offset
decorateEvent.pbY = 30						-- Progress bar Y offset
decorateEvent.sequenceStart = nil			-- Start animation
decorateEvent.sequenceWin = nil				-- Win animation
decorateEvent.sequenceWinAfterSwap = nil
decorateEvent.decorationObjects = {}
decorateEvent.decorateObjectId = ""			-- id of the object which is to be decorated

-- internal variables
-- don't change unless you know what you're doing
decorateEvent.decorateObject = nil
decorateEvent.started = false
decorateEvent.completed = false
decorateEvent.totalTime = 1

function decorateEvent:__init() super()
end

function decorateEvent:onLevelInited()

	if (self.decorateObject ~= nil) then
	
		-- init object
		self.decorateObject:setOverheadY(self.overheadY)
		self.decorateObject:removeHighlight()
		self.decorateObject:createHighlight()
		self.decorateObject.timer = self.timeUntilFixed
				
		-- initialize progress bar
		self.decorateObject.pb = createDefaultFillProgressBar();
		self.decorateObject.pb:setProgress(0)	
		self.decorateObject.pb:setY(self.pbY)
		self.decorateObject.pb:setVisible(false)
		self.decorateObject:addChild(self.decorateObject.pb)
		
		self.totalTime = self.timeUntilFixed
	
		-- start sequence
		if (self.sequenceStart ~= nil) then
			qSequence(self.sequenceStart)			
		end
		
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(100)
		eventBar:setProgress(0)	
		eventBar:setSubjectImage(self.decorateObject:calcImageName(self.decorateObject:getBaseName()) .. "_BAR", player:getCurrentResourceSection())
		eventBar:setDescriptionText(getText("EVENTBAR"))

	else
		
		warn("decorateEvent - no target object found")		
	end
end

function decorateEvent:onTick()
	if (not self.completed) then
		if (self.started) then
			eventBar:setProgress((self.totalTime - self.decorateObject.timer) / self.totalTime * 100)
		end
	end
end

function decorateEvent:createObject(desc)
	local result = nil
	
	if (self.decorateObject == nil and desc:getObjectId() == self.decorateObjectId) then
		result = decorateObject()
		result.event = self
		result:setType("decorateObject")
		result.desc = desc				
		self.decorateObject = result
	end
	
	return result
end

function decorateEvent:onDayBegin()

	self.started = true
	
	eventBar:animateToActive()
	eventBar:raiseCurtain()

end

function decorateEvent:onDone()

	--cleaner:animate("IDLE", 0)
	--cleaner:setReturnHome(true)

	-- are all objects fixed?
	if (self.decorateObject.state == "fixed") then
	
		incScore(self.scoreGotAll, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")
	
		if (self.sequenceWinAfterSwap ~= nil) then
			qInsertSequence(self.sequenceWinAfterSwap)
		end			
	end
		
	-- are all objects fixed?
	if (self.decorateObject.state == "fixed") then

		emily:playSound(self.soundEventCompleteAll)	

		-- lower curtain
		eventBar:animateToDeactive()
		
		self.completed = true
	end
end


-- a broken object
class 'decorateObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
decorateObject.event = nil
decorateObject.timer = 0
decorateObject.state = "broken"
decorateObject.pb = nil
decorateObject.index = 1
decorateObject.pbY = decorateEvent.pbY						-- Progress bar Y offset

function decorateObject:__init() super()
end

function decorateObject:onCreate()
	--D2Object.onCreate(self)
	self:animate(self:getBaseName(), 0)
end

function decorateObject:onClick()

	if (self.state == "broken") then
		self:playSound("SOUND_OBJECT_CLICK")
		if (self:isSelected() == false) then
			self:setSelected(true)
			self:clearOverhead()			
			emily:qWorkOn(self)
		end
	end	
end

function decorateObject:onWorkStart(task)

	self:setSelected(false)
	self.pb:setVisible(true)
		
	--cleaner:qWalkToXY(emily:getPosition():getGridX() - 2, emily:getPosition():getGridY())
	--cleaner:qSetReturnHome(false)
	
	if (self.event.workAnimationFrameRate == -1) then
		emily:animate(self.event.animFix, -1)
		--cleaner:qAnimate(self.event.animFix, -1)
	else
		emily:animate(self.event.animFix, -1, self.event.workAnimationFrameRate)				
		--cleaner:animate(self.event.animFix, -1, self.event.workAnimationFrameRate)
	end
	
	if (self.event.soundFix ~= "") then
		emily:playSound(self.event.soundFix, true)
	end
	
	return (self.state == "broken")
end

function decorateObject:onWorkUpdate(task, time)

	self.timer = self.timer - time
	local numDecorations = table.getn(self.event.decorationObjects)
	local decorateDuration = self.event.timeUntilFixed / numDecorations
	curActivateDuration = self.event.timeUntilFixed - (self.index * decorateDuration)	

	if (self.timer <= curActivateDuration) then
		getObject(self.event.decorationObjects[self.index]):setVisible(true)
		self.index = self.index + 1

		if (self.index > numDecorations) then
			self.timer = 0
			self.state = "fixed"
			self.event:onDone()
			return true
		end
	end
	
	self.pb:setProgress((self.event.timeUntilFixed - self.timer) / self.event.timeUntilFixed)
	
	return emily:hasTasksToDo()
end

function decorateObject:getWorkNode()
	if (self.event.targetWorkX >= 0 and self.event.targetWorkY >= 0) then
		return grid:getNode(self.event.targetWorkX, self.event.targetWorkY)
	end
end

function decorateObject:onWorkComplete(task)

	--cleaner:qAnimate("IDLE", 0)
	--cleaner:qSetReturnHome(true)

	if (self.event.soundFix ~= "") then
		emily:stopSound(self.event.soundFix)
	end
	
	self.pb:setVisible(false)
	
end
