class 'clickEvent' (interface)

--
-- hidden object types
-- all these types are defined as hidden objects!
-- when you come up with a new hidden object event, the preset type needs
-- to be added here!
clickEvent.eventBarImage = nil

-- configuration variables
clickEvent.baseName = ""					-- appearance of the person
clickEvent.baseSection = "characters"	-- section
clickEvent.entryX = 0					-- position person enters from
clickEvent.entryY = 0
clickEvent.highlightX = 0
clickEvent.highlightY = 0
clickEvent.sequenceStart	= nil			-- text when event starts
clickEvent.sequenceThanks = nil			-- text when you find 1 item
clickEvent.sequenceDone = nil			-- text when you find all items
clickEvent.sequenceFail = nil			-- sequence for when the task time ends and you don't have all of the items
clickEvent.timeUntilEnterMin = 0			-- minimum time the person waits outside
clickEvent.timeUntilEnterMax = 0			-- maximum time the person waits outside
clickEvent.scoreFoundOne	= 0				-- score for finding one item
clickEvent.scoreFoundAll	= 0				-- bonus for finding all items
clickEvent.hintId = "HINT_SPIDER_WEB_CLEANING"
clickEvent.clicksNeeded = 25
clickEvent.soundClick = {"SOUND_PICK_FRANCOIS0", 
						 "SOUND_PICK_FRANCOIS1", 
						 "SOUND_PICK_FRANCOIS2", 
						 "SOUND_PICK_FRANCOIS3", 
						 "SOUND_PICK_FRANCOIS4" }

-- internal variables
-- don't change unless you know what you're doing
clickEvent.items = {}
clickEvent.itemsProps = {}
clickEvent.countItems = 0
clickEvent.countFound = 0
clickEvent.person = nil
clickEvent.timer = 0
clickEvent.started = false
clickEvent.eventStarted = false
clickEvent.completed = false
clickEvent.cleanMode = false
clickEvent.cleanObject = nil
clickEvent.oldX = 0
clickEvent.oldY = 0
clickEvent.objectToClean = nil

function clickEvent:__init() super()
end

function clickEvent:onLevelGlobals()
	for index, value in ipairs(self.itemsProps) do
       	createDummyObject(value.type, value.x, value.y)
     end   
end

function clickEvent:onLevelInited()

	if (self.countItems > 0) then

		-- set enter timer
		self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
	
	  	-- create the person that lost all his/her belongings
	  	if (self.baseName ~= "") then
			self.person = pm:createPerson("npc")
			self.person:setBaseName(self.baseName)
			self.person:setDefaultSection(self.baseSection)
			self.person:setPosition(grid:getNode(self.entryX, self.entryY))
		end
		
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(self.countItems * self.clicksNeeded)
		eventBar:setProgress(0)
		eventBar:setDescriptionText(getText("EVENTBAR"))
		if (self.eventBarImage == nil) then
			eventBar:setSubjectImage(self.items[1]:getBaseName() .. "_BAR", self.items[1]:getDefaultSection())
		else
			eventBar:setSubjectImage(self.eventBarImage, self.items[1]:getDefaultSection())
		end
		
	else
	
		warn("clickEvent - no hidden object(s) found")
	
	end

end

function clickEvent:createObject(desc)
  
  	local result = nil
  
	for index, value in ipairs(self.itemsProps) do
		if (value.type == desc:getType()) then
			result = clickObject()
			result:setObjectIdName(value.type)
			result:setDefaultSection(player:getCurrentResourceSection())
			result:setType(value.type)
    		result:anchorY(value.anchorY)
    		result:animate(value.image, 0)
			result.event = self
			if (value.hidden ~= nil) then
				result:setVisible(not value.hidden)
			end
			break;		
		end
	end  	
  
	if (result ~= nil) then
		self.items[ self.countItems+1 ] = result;
		self.countItems = self.countItems + 1 
	end
  
  	return result

end

function clickEvent:onDayBegin()

	self.started = true

	--local p = self.items[4]
	--hm:openHint(getHintIndex(self.hintId), p:getScreenX(), p:getScreenY() - (p:getHeight() / 2))
	
end

function clickEvent:onDayEnd()

	if (not self.completed) then
	
		if (self.sequenceFail ~= nil) then
			qSequence(self.sequenceFail)		
		else
			if (self.person) then
				self.person:qDestroy()
			end
		end
	end
	
end

function clickEvent:onTick(time)
	
	if (not self.started) then
		return
	end
	
	-- wait until we can enter
	if (self.timer > 0) then

	    self.timer = self.timer - time
	    if (self.timer <= 0) then

			-- start sequence
			if (self.sequenceStart ~= nil) then
				qSequence(self.sequenceStart)
			end			
	    	
	    end	
	end

end

function clickEvent:onNotify(notification)

	if (notification == "show bar") then

        self.eventStarted = true

		-- show pearl on bar
		eventBar:animateToActive()
		eventBar:raiseCurtain()
		
	    -- show all hidden items
		for index, value in ipairs(self.items) do
		
		    value:createHighlight()
		    value:getHighlight():setAlphaHitmaskThreshold(-1)
		    
   		    value.xPos = value:getX()
			value.yPos = value:getY()
		    
			--if (value:getPosition():getGridX() == self.highlightX) then
				--if (value:getPosition():getGridY() == self.highlightY) then
					--value:createOverhead("INGAME_ARROW")
					--
				--end
			--end
		end
	
	end

end

-- a hidden object
class 'clickObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
clickObject.event = nil
clickObject.numClicks = 0
clickObject.movingTimer = 0
clickObject.xPos = 0
clickObject.yPos = 0

function clickObject:__init() super()
end

function clickObject:onCreate()
end

function clickObject:onClick()
    if (self:isVisible()) then
    	if (type(self.event.soundClick) == "string") then
    		if (self.event.soundClick ~= "") then    		
				self:playSound(self.event.soundClick)
			end
		end
		if (type(self.event.soundClick) == "table") then
			local soundClick = self.event.soundClick[getRandom(#(self.event.soundClick))+1]
			self:playSound(soundClick)
		end
   		eventBar:incrementProgress(1)
		self.numClicks = self.numClicks + 1
		self:setAlpha(1 - ((self.numClicks / self.event.clicksNeeded) * 0.8))
		self.movingTimer = 60
		if (self.numClicks >= self.event.clicksNeeded) then
			self:DoFinishObject()
		end
		self:clearOverhead()
    end
end

function clickObject:onTick(time)
	if (self.movingTimer > 0) then
		self.movingTimer = self.movingTimer - time		
		self:setX(self.xPos + math.random(-1, 1))
		self:setY(self.yPos + math.random(-1, 1))
	end
end

function clickObject:DoFinishObject()
	-- First check if we should even be able to click on this object:
	if (self:isVisible() == true) then
		-- hide the item
		self:setVisible(false)
		self:setClickable(false)
		self:clearOverhead()
		self:playSound(self.event.soundEventCompleteOne)
	
		-- increase the found count
		self.event.countFound = self.event.countFound + 1
		
		-- increase score and pop a floater
		incScore(self.event.scoreFoundOne, self:getScreenX(), self:getScreenY(), 0)
		
		-- say thanks
		if (self.event.countFound == self.event.countItems) then
		
			self:playSound(self.event.soundEventCompleteAll)
		
			-- found all items
	    	-- set event to completed
	    	self.event.completed = true
	
			-- lower curtain
			eventBar:animateToDeactive()
	
			-- increase score and pop a floater
			incScore(self.event.scoreFoundAll, self:getScreenX(), self:getScreenY(), scoreBonusFloaterDelay, "BONUS")
	
			-- done sequence
			if (self.event.sequenceDone ~= nil) then
				qSequence(self.event.sequenceDone)			
			end					
	
		else
			-- thanks sequence
			if (self.event.person ~= nil) then
				if (self.event.person:isIdle()) then
					if (self.event.sequenceThanks ~= nil) then
						qSequence(self.event.sequenceThanks)						
					end
				end
			elseif (self.event.sequenceThanks ~= nil) then
				qSequence(self.event.sequenceThanks)					
			end	
			scene:qNotify("click object done")
		end
	end
	
end