class 'cleaningReappearEvent' (interface)

--
-- hidden object types
-- all these types are defined as hidden objects!
-- when you come up with a new hidden object event, the preset type needs
-- to be added here!
cleaningReappearEvent.eventBarImage = nil 

-- configuration variables
cleaningReappearEvent.entryX = 0					-- position person enters from
cleaningReappearEvent.entryY = 0
cleaningReappearEvent.highlightX = 0
cleaningReappearEvent.highlightY = 0
cleaningReappearEvent.sequenceStart	= nil			-- text when event starts
cleaningReappearEvent.sequenceThanks = nil			-- text when you find 1 item
cleaningReappearEvent.sequenceDone = nil			-- text when you find all items
cleaningReappearEvent.sequenceFail = nil			-- sequence for when the task time ends and you don't have all of the items
cleaningReappearEvent.scoreFoundOne	= 0				-- score for finding one item
cleaningReappearEvent.scoreFoundAll	= 0				-- bonus for finding all items

-- internal variables
-- don't change unless you know what you're doing
cleaningReappearEvent.items = {}
cleaningReappearEvent.itemsProps = {}
cleaningReappearEvent.countItems = 5				-- number of times we need to clean the target's face
cleaningReappearEvent.countFound = 0				-- number of times the target's face is cleaned
cleaningReappearEvent.dirtObject = nil				-- object which needs to be cleaned
cleaningReappearEvent.timer = 0
cleaningReappearEvent.started = false
cleaningReappearEvent.eventStarted = false
cleaningReappearEvent.completed = false
cleaningReappearEvent.cleanMode = false
cleaningReappearEvent.cleanObject = nil				-- Image of cleaning cloth
cleaningReappearEvent.oldX = 0
cleaningReappearEvent.oldY = 0
cleaningReappearEvent.objectToClean = nil			-- object which needs to be cleaned
cleaningReappearEvent.pixelsToClean = 1500
cleaningReappearEvent.objectCurrentlyClean = false

function cleaningReappearEvent:__init() super()
end

function cleaningReappearEvent:onLevelGlobals()
end

function cleaningReappearEvent:onLevelInited()

	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(math.max(1, self.countItems))
	eventBar:setProgress(0)
	eventBar:setDescriptionText(getText("EVENTBAR"))
	if (self.eventBarImage == nil) then
		warn("cleaningReappearEvent: eventBarImage == nil")
	else
		eventBar:setSubjectImage(self.eventBarImage, player:getCurrentResourceSection())
	end
		
end

function cleaningReappearEvent:createObject(desc)
  
  	local result = nil

	if (desc:getObjectId() == "rest1_paul_hit") then
		result = spiderweb()
		result:setType(desc:getType())
		result:setObjectIdName(desc:getType())
		result:setDefaultSection(player:getCurrentResourceSection())
		result:animate("EVENT_PAUL_SNOW_HIT", 0)
		result:createHighlight()
		result.event = self
		result.cleaned = true
		result.pixelsToClean = event.pixelsToClean
		result:setVisible(false)
		result:setClickable(false)
		result.didAllCleans = true
		self.objectToClean = result
		self.objectCurrentlyClean = true
	end

  	return result

end

function cleaningReappearEvent:onDayBegin()

	self.started = true

end

function cleaningReappearEvent:onDayEnd()

	if (not self.completed) then
	
		if (self.sequenceFail ~= nil) then
			qSequence(self.sequenceFail)		
		end
	end
	
end

function cleaningReappearEvent:onDeactivate()
    if (self.cleanMode) then
       self:setCleanMode(false, nil)
    end
end

function cleaningReappearEvent:onPause(pause)
    if (pause and self.cleanMode) then
        self:setCleanMode(false, nil)
    end
end

function cleaningReappearEvent:onTick(time)

	if (self.started == false) then
		return
	end
	
    if (self.cleanMode) then  

        self.oldX = self.cleanObject:getX()
        self.oldY = self.cleanObject:getY()  
        self.cleanObject:setX(getMouseX())
        self.cleanObject:setY(getMouseY()) 
        
        local x = self.cleanObject:getX()
        local y = self.cleanObject:getY()
        if (self.oldX ~= x and self.oldY ~= y and self.objectToClean:getHighlight():isHighlighted()) then           
        
            local dx = x - self.oldX
            local dy = y - self.oldY
            local l = ((dx * dx) + (dy * dy)) ^ 0.5
            self.objectToClean.curPixels = self.objectToClean.curPixels + l
            local alpha = math.max(0.35, 1 - ((self.objectToClean.curPixels / self.objectToClean.pixelsToClean) * 0.6))
            self.objectToClean:setAlpha(alpha)
	        eventBar:setProgress((1 - ((self.objectToClean:getAlpha() - 0.4) * 1.666666667)) * 50)                   
            if (self.objectToClean.curPixels >= self.objectToClean.pixelsToClean) then
				onNotify("object cleaned")
                self.objectToClean:DoFinishObject()
                self:setCleanMode(false, nil)
            end
            
         end
                  
    end	

	-- wait until we can enter
	if (self.timer > 0) then

	    self.timer = self.timer - time
	    if (self.timer <= 0) then

			-- start sequence
			if (self.sequenceStart ~= nil) then
				qSequence(self.sequenceStart)
			end			
	    	
	    end	
	end

end

function cleaningReappearEvent:reappear()

	self.objectToClean:reappear()
	self.objectCurrentlyClean = false
	
end

function cleaningReappearEvent:onNotify(notification)

	if (notification == "show bar") then

        self.eventStarted = true

		-- show pearl on bar
		eventBar:animateToActive()
		eventBar:raiseCurtain()
		
	    -- show all hidden items
		for index, value in ipairs(self.items) do
		
		    value:createHighlight()
		    value:getHighlight():setAlphaHitmaskThreshold(-1)
		    
			if (value:getPosition():getGridX() == self.highlightX) then
				if (value:getPosition():getGridY() == self.highlightY) then
					value:createOverhead("INGAME_ARROW")
					
				end
			end
		end
	
	end

end


function cleaningReappearEvent:setCleanMode(mode, object)
    self.cleanMode = mode    
--    self.objectToClean = object --

    if (mode) then    
        self.cleanObject = scene:createD2Sprite()
        self.cleanObject:setDefaultSection(player:getCurrentResourceSection())
        self.cleanObject:animate("OBJECT_DIRTY_SCRUB", 0)
        self.cleanObject:setX(getMouseX())
        self.cleanObject:setY(getMouseY())
        self.cleanObject:setAnchorPointType(4)
        scene:addChild(self.cleanObject)    
        self.oldX = self.cleanObject:getX()
        self.oldY = self.cleanObject:getY()

		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(50)
        eventBar:setProgress((1 - ((self.objectToClean:getAlpha() - 0.4) * 1.666666667)) * 50)                   
    else
        self.cleanObject:setObsolete(true)
        self.cleanObject = nil
        
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(math.max(1, self.countItems))
		eventBar:setProgress(self.countFound)      
    end
    
    
end

function cleaningReappearEvent:onClick(x, y)

    if (self.started == false) then
		return false
	end

    if (self.cleanMode) then
        self:setCleanMode(false, nil)
        return true
    end
   
   return false
end

function cleaningReappearEvent:removeObjectWithoutScoring()
	self.objectToClean:DoFinishObject(false)
end

-- a hidden object
class 'spiderweb' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
spiderweb.event = nil
spiderweb.cleanMode = false
spiderweb.cleaned = true
spiderweb.timeReappear = 4000
spiderweb.reappearTimer = 0
spiderweb.didAllCleans = true
spiderweb.curPixels = 0

function spiderweb:__init() super()
end

function spiderweb:onCreate()
end

function spiderweb:onClick()

    if (self:isVisible() and not self.event.cleanMode) then
         self.event:setCleanMode(true, self)
         
         self:clearOverhead()
    end

end

function spiderweb:reappear()

	self:setVisible(true)
	self:setClickable(true)
	self:setAlpha(1.0)
	
end

function spiderweb:DoFinishObject(withScore)
	-- First check if we should even be able to click on this object:
	if (self:isVisible() == true) then
		
		self.curPixels = 0
		
		-- hide the item
		self:setVisible(false)
		self:setClickable(false)
		self:clearOverhead()
		self:playSound(self.event.soundEventCompleteOne)
	
		self.event.objectCurrentlyClean = true
	
		-- increase the found count
		self.event.countFound = self.event.countFound + 1
		
		if (withScore == true) then
			-- increase score and pop a floater
			incScore(self.event.scoreFoundOne, self:getScreenX(), self:getScreenY(), 0)
		else
			-- Player didn't clean dirty object every time:
			self.didAllCleans = false
		end
		
		-- update the event bar
		eventBar:setProgress(self.event.countFound)
		
		-- say thanks
		if (self.event.countFound == self.event.countItems) then
		
			self:playSound(self.event.soundEventCompleteAll)
		
			-- found all items
	    	-- set event to completed
	    	self.event.completed = true
	
			-- lower curtain
			eventBar:animateToDeactive()
	
			if (self.didAllCleans == true) then
				-- increase score and pop a floater
				incScore(self.event.scoreFoundAll, self:getScreenX(), self:getScreenY(), scoreBonusFloaterDelay, "BONUS")
			end

			-- done sequence
			cout("Is done \n")
			if (self.event.sequenceDone ~= nil) then
				qSequence(self.event.sequenceDone)		
			end					
	
		else
		--	self.reappearTimer = self.timeReappear		-- Uncomment this line if you want an automatically reappearing dirt object
			-- thanks sequence
			if (self.event.sequenceThanks ~= nil) then
				qSequence(self.event.sequenceThanks)
			end
		end
	end
	
end