class 'cardPlacingEvent' (interface)

--
-- hidden object types
-- all these types are defined as hidden objects!
-- when you come up with a new hidden object event, the preset type needs
-- to be added here!
cardPlacingEvent.eventBarImage = nil

-- configuration variables
cardPlacingEvent.baseName = ""				-- appearance of the person
cardPlacingEvent.baseSection = "characters"	-- section
cardPlacingEvent.entryX = 0					-- position person enters from
cardPlacingEvent.entryY = 0
cardPlacingEvent.workX = 0					-- workpos
cardPlacingEvent.workY = 0
cardPlacingEvent.sequenceStart	= nil		-- text when event starts
cardPlacingEvent.sequenceDone = nil			-- text when you find all items
cardPlacingEvent.sequenceFail = nil			-- sequence for when the task time ends and you don't have all of the items
cardPlacingEvent.scoreOneCard	= 0			-- score for finding one item
cardPlacingEvent.scoreAllCards	= 0			-- bonus for finding all items
cardPlacingEvent.workAnimEmily = "WORK_UP"
cardPlacingEvent.minDuration = 3000					-- workpos
cardPlacingEvent.maxDuration = 10000
cardPlacingEvent.cardOrder = {4, 15, 1, 10, 7, 14, 5, 6, 11, 2, 9, 13, 3, 8, 12, 0}

-- internal variables
-- don't change unless you know what you're doing
cardPlacingEvent.countCards = 0
cardPlacingEvent.person = nil
cardPlacingEvent.started = false
cardPlacingEvent.completed = false
cardPlacingEvent.active = true

function cardPlacingEvent:__init() super()
end

function cardPlacingEvent:onLevelInited()

	self.person = pm:createPerson("angela")
	self.person:setBaseName(self.baseName)
	
	-- start sequence
	if (self.sequenceStart ~= nil) then
		qSequence(self.sequenceStart)
	end			

	-- initialize event bar
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(16)
	eventBar:setProgress(0)
	eventBar:setDescriptionText(getText("EVENTBAR"))
	eventBar:setSubjectImage("OBJECT_CARD_BAR", player:getCurrentResourceSection())	
end

function cardPlacingEvent:createObject(desc)  
  	result = nil
   	return result
end

function cardPlacingEvent:createPerson(class)
	if (class == "angela") then
		m = angela(self.baseName)
		m.event = self
		m:setType(class)
		return m		
	end		
	return nil		
end

function cardPlacingEvent:onDayBegin()
	self.started = true
	-- raise the curtain
	eventBar:animateToActive()
	eventBar:raiseCurtain()
end

function cardPlacingEvent:onDayEnd()
	
    if (self.order) then
		self.person:removeHighlight()
		self.order:qPopOut()
		self.order:qDestroy()
		self.order = nil
	end
	
	if (not self.completed) then	
		if (self.sequenceFail ~= nil) then
			qSequence(self.sequenceFail)		
		end		
	end	
end

function cardPlacingEvent:incCardsDone()
	self.countCards = self.countCards + 1	
	if (self.countCards == 16) then
    	-- set event to completed
    	self.completed = true
		-- lower curtain
		eventBar:animateToDeactive()
		-- increase score and pop a floater
		incScore(self.scoreAllCards,emily:getScreenX(), emily:getScreenY(), scoreBonusFloaterDelay, "BONUS")
		-- done sequence
		if (self.sequenceDone ~= nil) then
			qSequence(self.sequenceDone)			
		end					
	else
	    eventBar:setProgress(self.countCards)
		incScore(self.scoreOneCard, emily:getScreenX(), emily:getScreenY(), scoreBonusFloaterDelay, "BONUS")
		self.active = true
	end
end

function cardPlacingEvent:onRemoveProductFromTray(product)
	if (product == "CARD") then
		self.active = true
		emily:playSound("SOUND_PICKUP_POST_CARD")
		getProduct("PLATE" .. self.cardOrder[self.countCards + 1]):setClickable(false)
		getProduct("PLATE" .. self.cardOrder[self.countCards + 1]):removeHighlight()		
	end
end

-- a angela
class 'angela' (npc)

-- internal variables
-- don't change unless you know what you're doing
angela.timer = 0
angela.target = nil
angela.event = nil	
angela.order = nil
angela.product = nil

function angela:__init(baseName) super(baseName)
end

function angela:onCreate()
	self:setDefaultSection(self.event.baseSection)
	D2Person.onCreate(self)	
	self:setPosition(grid:getNode(self.event.entryX, self.event.entryY))
	self.timer = getRandomRange(self.event.minDuration, self.event.maxDuration)
end

function angela:onTick(time)
	if (self.event.started == false or 
        self.event.active == false or 
        self.event.completed == true or 
        self.event.countCards >= 16) then
		return
	end
	
	self.timer = self.timer - time
	if (self.timer < 0) then
		self:createHighlight()
		self:playSound("SOUND_EVENT_ATTENTION")		
		self.order = createOrder()
		x = -self:getAnchorX() + self:getWidth() / 2
		y = -self:getAnchorY() + 30
		self.order:setX(x)
		self.order:setY(y)
		self.order:setAnchorPointType(BOTTOMCENTER)		
		self:addChild(self.order)
		self.order:addProduct("CARD")
		self.order:popIn()		
		self.event.active = false
	    self.timer = getRandomRange(self.event.minDuration, self.event.maxDuration)
		self.product = prm:createProduct("CARD")
		self.product:setX(x)
		self.product:setX(y)
		
		hm:placeArrow(getArrowIndex("ARROW_HINT_INVITATION_MADE"), self, 0, -5)
	end
end

function angela:onClick()
	-- if the angela is already selected then the player already
	-- clicked on him. in that case we ignore the click.
	if (not self:isSelected()) then
		-- make emily get the package
		emily:qWorkOn(self)
		-- select the angela
		-- this makes sure that we can't receive multiple packages
		-- from him at once
		self:setSelected(true)
		
		-- product stuff
		if (self.product:isQueuableToTray()) then
			self.product:queue()		
		else
			self.event.active = true
		end			
	end
end

function angela:onWorkStart(task)
	-- disable highlight so we can't click the angela anymore
    self:removeHighlight()
    self.order:qPopOut()
    self.order:qDestroy()
    self.order = nil

	-- disable selection
	self:setSelected(false)
    
	-- animate emily
	emily:animate(self.event.workAnimEmily, 1)
   		
	-- time it takes to transfer the package
	task:setDuration(200)
	
	if (self.product:isQueuedOnTray()) then
		return true		
	else
		self.event.active = true
		tray:clearInvisible()	
	end	
	
	return false
end

function angela:onWorkComplete(task)
	self:animate("IDLE", 0)
	emily:animate("IDLE", 0)
	
	local plate = getProduct("PLATE" .. self.event.cardOrder[self.event.countCards + 1])
    plate:setClickable(true)
    plate:createHighlight()
    local h = plate:getHighlight()
    h:setSelected(true)
    
    hm:placeArrow(getArrowIndex("ARROW_HINT_INVITATION_PLACE"), plate, 15, 15)
    
	self.product:moveToTray()
	self.product:setObsolete(true)
	self.product = nil
end

function angela:getWorkNode()
	return grid:getNode(self.event.workX, self.event.workY)
end
