
class 'candle' (D2Object)

candle.canFade = false
candle.canRestore = false
candle.timeAlight = 5 * 1000
candle.timeToFade = 5 * 1000
candle.timeToDie = 600
candle.timeToLightFromFade = 1 * 1000	-- Time taken by Emily to relight the flame from "fading"
candle.timeToLightFromDying = 3 * 1000	-- Time taken by Emily to light the flame from "dying"
candle.timeToLightFromDead = 3 * 1000	-- Time taken by Emily to light the flame from "dead"

candle.timer = 0
candle.timerSuspended = false
candle.flameState = ""
candle.workAnim = "WORK_UP"

candle.burnFrameTime = 0

function candle:__init() super()
end

function candle:onCreate()
	self:createHighlight()
	self:setFlameState("dead")
end

function candle:onClick()
	if (self.flameState == "fading" or
		self.flameState == "dying" or
		self.flameState == "dead") then
		if (not self:isSelected()) then
			self.timerSuspended = true
			self:setSelected(true)
			emily:qWorkOn(self)
			self:clearOverhead()
		end
	end
end

function candle:onWorkStart(task)
	if (self.flameState == "fading") then
		task:setDuration(self.timeToLightFromFade)
		emily:animate(self.workAnim, -1)
		return true
	elseif (self.flameState == "dying") then
		task:setDuration(self.timeToLightFromDead)
		emily:animate(self.workAnim, -1)
		return true	
	elseif (self.flameState == "dead") then
		task:setDuration(self.timeToLightFromDead)
		emily:animate(self.workAnim, -1)
		return true
	end
	return false
end

function candle:onWorkComplete(task)
	if (self.flameState == "dead" or
		self.flameState == "dying" or
		self.flameState == "fading") then
	
		self:setFlameState("alight")
		self.timerSuspended = false
		self:setSelected(false)
		emily:animate("IDLE", 0)
	end
end

function candle:onTick(time)
	
	if (scene:isStartingMovie() or scene:isPlayingMovie()) then
		return
	end
	
	--cout("&&&&&  Candle: onTick ")
	if (self.canFade) then
	--	cout(" canFAde ")
		if (not self.timerSuspended) then
	--		cout(" Timer NOT SUSPENDED ")
			self.timer = self.timer - time
			if (self.timer <= 0) then
				if (self.flameState == "alight") then
					self:setFlameState("fading")
				elseif (self.flameState == "fading") then
					self:setFlameState("dying")
					if (not self.canRestore) then
						self:clearOverhead()
						self:removeHighlight()		-- This baby will never live again
						self:setClickable(false)	-- This baby will never live again
					end					
				elseif (self.flameState == "dying") then
					self:setFlameState("dead")
					if (not self.canRestore) then
						self:clearOverhead()
						self:removeHighlight()		-- This baby will never live again
						self:setClickable(false)	-- This baby will never live again
					end						
				end
			end
	--	else
	--		cout(" Timer SUSPENDED ")
		end
	end
	--cout(" &&&&&&&\n")
end

function candle:setFlameState(state)
	cout("candle:setFlameState(state) " .. state .. " \n")
	if (state ~= self.flameState) then
		self.flameState = state
		if (state == "alight") then
			self.timer = self.timeAlight
			if (self.burnFrameTime ~= 0) then
				self:animate("OBJECT_CANDLE_BURN_ANIM", -1, self.burnFrameTime)
			else
				self:animate("OBJECT_CANDLE_BURN_ANIM", -1)
			end
			self:setClickable(false)
			
		elseif (state == "fading") then
			self.timer = self.timeToFade
			self:animate("OBJECT_CANDLE_FLICKER_ANIM", -1)
			self:blink(5)
			self:setClickable(true)
			self:playSound("SOUND_EVENT_ATTENTION")
			
			-- Hint about clicking the candle to keep it lit
			if (gFlameArrowShown ~= true) then
				self:createOverhead("INGAME_ARROW")
				gFlameArrowShown = true
			end
		
		elseif (state == "dying") then
			self.timer = self.timeToDie
			self.timerSuspended = true
			self:animate("OBJECT_CANDLE_DYING_ANIM", 1, false, -1, true)
			self:setClickable(true)
			
		elseif (state == "dead") then
			self.timerSuspended = true
			self:animate("OBJECT_CANDLE_DEAD", 0)
			self:setClickable(true)
		end
	end
end

function candle:isLit()
	return (self.flameState == "alight")
end