class 'attentionEvent' (interface)

-- configuration variables
attentionEvent.sequenceDayStart = nil
attentionEvent.sequenceDayEnd = nil
attentionEvent.baseName1 = ""						-- appearance of the attentionPerson
attentionEvent.baseName2 = ""
attentionEvent.baseSection = "characters"
attentionEvent.timeUntilEnterMin = 0				-- minimum time the attentionPerson waits outside
attentionEvent.timeUntilEnterMax = 1				-- maximum time the attentionPerson waits outside
attentionEvent.scoreGotOne = 0						-- score for finding one item
attentionEvent.scoreGotAll = 0						-- bonus for finding all items
attentionEvent.p1WorkX = 0
attentionEvent.p1WorkY = 0
attentionEvent.p2WorkX = 0
attentionEvent.p2WorkY = 0
attentionEvent.p1PBY = 0
attentionEvent.p2PBY = 0
attentionEvent.p1Appearance = ""
attentionEvent.p2Appearance = ""
attentionEvent.p1TextLines = {}
attentionEvent.p2TextLines = {}
attentionEvent.p1WalkAwayPerson = false
attentionEvent.p2WalkAwayPerson = false	
attentionEvent.p1TalkX = 0
attentionEvent.p1TalkY = 0
attentionEvent.p2TalkX = 0
attentionEvent.p2TalkY = 0
attentionEvent.p1barEmptyDuration = 0
attentionEvent.p2barEmptyDuration = 0

-- internal variables
-- don't change unless you know what you're doing
attentionEvent.started = false
attentionEvent.completed = false
attentionEvent.person1 = nil
attentionEvent.person2 = nil


function attentionEvent:__init() super()
end

function attentionEvent:onLevelInited()
	
  	-- create the attentionPerson
	self.person1 = pm:createPerson("attentionPerson")
	self.person1:setBaseName(self.baseName1)
	self.person1:setPosition(grid:getNode(0, 0))
	self.person1.workX = self.p1WorkX
	self.person1.workY = self.p1WorkY
	self.person1.textLines = self.p1TextLines
	self.person1.textLinesCopy = table.copy(self.p1TextLines)
	self.person1.pb:setY(self.p1PBY)
	self.person1.appearance = self.p1Appearance
	self.person1.timer = self.p1barEmptyDuration
	self.person1.barEmptyDuration = self.p1barEmptyDuration
	self.person1.walkAway = self.p1WalkAwayPerson
	self.person1.talkX = self.p1TalkX
	self.person1.talkY = self.p1TalkY
	
	self.person2 = pm:createPerson("attentionPerson")
	self.person2:setBaseName(self.baseName2)
	self.person2:setPosition(grid:getNode(0, 0))
	self.person2.workX = self.p2WorkX
	self.person2.workY = self.p2WorkY
	self.person2.textLines = self.p2TextLines
	self.person2.textLinesCopy = table.copy(self.p2TextLines)
	self.person2.pb:setY(self.p2PBY)
	self.person2.appearance = self.p2Appearance
	self.person2.timer = self.p2barEmptyDuration
	self.person2.barEmptyDuration = self.p2barEmptyDuration
	self.person2.walkAway = self.p2WalkAwayPerson
	self.person2.talkX = self.p2TalkX
	self.person2.talkY = self.p2TalkY
	
	-- start sequence
	if (self.sequenceDayStart ~= nil) then
		qSequence(self.sequenceDayStart)
	end				
end

function attentionEvent:onDayEnd()
	self.person1:setActive(false)
	self.person2:setActive(false)
	
	if (self.person1.win) then
		incScore(self.scoreGotOne, self.person1:getScreenX(), self.person1:getScreenY() + scorePersonFloaterOffsetY)	
	end
	if (self.person2.win) then
		incScore(self.scoreGotOne, self.person2:getScreenX(), self.person2:getScreenY() + scorePersonFloaterOffsetY)	
	end
	if (self.person1.win and self.person2.win) then
		incScore(self.scoreGotAll, 400, 300, scoreBonusFloaterDelay, "BONUS")		
	end
	
	if (self.sequenceDayEnd ~= nil) then
		qSequence(self.sequenceDayEnd)
	end			
end

function attentionEvent:createPerson(class)

	if (class == "attentionPerson") then
		m = attentionPerson("")
		m.event = self
		m:setType(class)
		return m	
	end
		
	return nil		
end

function attentionEvent:onDayBegin()
	self.started = true	
end

-- a attentionPerson
class 'attentionPerson' (npc)

-- internal variables
-- don't change unless you know what you're doing
attentionPerson.timer = 0	
attentionPerson.event = nil	
attentionPerson.workX = 0
attentionPerson.workY = 0
attentionPerson.working = false
attentionPerson.active = false
attentionPerson.pb = nil
attentionPerson.textLines = {}
attentionPerson.textLinesCopy = {}
attentionPerson.appearance = ""
attentionPerson.walkAway = false
attentionPerson.talkX = 0
attentionPerson.talkY = 0
attentionPerson.win = true
attentionPerson.barEmptyDuration = 0

function attentionPerson:__init(baseName) super(baseName)
end

function attentionPerson:onCreate()
	self:setDefaultSection(self.event.baseSection)
	D2Person.onCreate(self)	
	
    -- initialize progress bar
    self.pb = createDefaultFillProgressBar();
    self.pb:setFillImage("FILL_BAR_FILLING_RED_GREEN", "scenegame")
    self.pb:setProgress(1)
    self.pb:setVisible(false)
    self.pb.isBlinking = false
    self:addChild(self.pb)
end

function attentionPerson:setActive(active)
	if (active == self.active or self.win == false) then
		return
	end	
	
	self.pb:setVisible(active)
	self.active = active
	if (active) then
		self:createHighlight()
	else
		self:removeHighlight()
	end
end

function attentionPerson:lose()
	self.pb.isBlinking = false
	self:setActive(false)
	self.win = false
end

function attentionPerson:onTick(time)
	if (scene:isStartingMovie() or 
		scene:isPlayingMovie() or 
		self.event.started == false or
		self.event.completed or
		self.working or
		self.win == false) then
		return
	end
	
	if (self.walkAway and self:isVisible() == false) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			self:setVisible(true)
			self.pb:setProgress(1)
			self.timer = self.barEmptyDuration
		    self.pb.isBlinking = false

			insert()
			self:qWalkToXY(self.talkX, self.talkY)
			self:qCallback(self, function(self) self:setActive(true) end)
			append()		
		end		
		
		if (self.timer < 20000 and self.pb.isBlinking == false) then
			self.pb.isBlinking = true
			-- blink needs to be done
			--self.pb:blink(1000)
		end
	end

	if	(self.active == false) then
		return
	end
		
	self.timer = self.timer - time
	self.pb:setProgress((self.timer / self.barEmptyDuration))
	if (self.timer <= 0) then
		self:lose()
		if (self.walkAway) then		
			insert()
			self:qWait(100)
			self:qWalkToXY(0, 0)
			self:qSetVisible(false)
			append()
		end
	end
end

function attentionPerson:onClick()

	-- if the attentionPerson is already selected then the player already
	-- clicked on him. in that case we ignore the click.
	if (self:isSelected() == false) then
		-- make emily go to person to talk
		self.working = true
		emily:qWorkOn(self)   
		self:setSelected(true)
		self:clearOverhead()    
	end
end

function attentionPerson:onWorkStart(task)
	-- disable selection
	self:setSelected(false)
    self.pb.isBlinking = false   

	-- disable highlight so we can't click the attentionPerson anymore
	self:getHighlight():clear()    
	self:getHighlight():setActive(false)	 
		
	-- time it takes to transfer the package
	task:setDuration(2000)

	-- animate attentionPerson
	insert()
	self:qSetAppearance(self.appearance)
	
	if (table.getn(self.textLines) == 0) then
		self.textLines = table.copy(self.textLinesCopy)
	end
	
	local idx = getRandom(table.getn(self.textLines)) + 1	
	self:qSayTimed(self.textLines[idx], 2000)
	table.remove(self.textLines, idx)
	append()
	
	return true
end

function attentionPerson:onWorkComplete(task)
	self:qSetAppearance("")
	self:animate("IDLE", 0)
	emily:animate("IDLE", 0)	
	emily:playSound(event.soundEventCompleteOne)
	self:getHighlight():setActive(true)	 
    self.pb:setProgress(1)
    self.timer = self.barEmptyDuration
	self.working = false

	if (self.walkAway) then
		self.timer = getRandomRange(self.event.timeUntilEnterMin, self.event.timeUntilEnterMax)
		self:setActive(false)
		insert()
		self:qWait(200)
		self:qWalkToXY(0, 0)
		self:qSetVisible(false)
		append()
	end   
end

function attentionPerson:getWorkNode()  
	return grid:getNode(self.workX, self.workY)  
end
